/*
 * Decompiled with CFR 0.152.
 */
package nz.co.k.tms.exception;

import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.Vector;
import nz.co.k.tms.exception.TmsGeneralExceptionItem;

public class TmsGeneralException
extends Exception {
    public static final int PropertyType = 1;
    public static final int LogicType = 2;
    public static final int ApplicationType = 3;
    public static final int UnknownType = 4;
    private int errorCode = -1;
    private Vector errorItems = null;
    private Exception rootException = null;

    public TmsGeneralException(int errorCode) {
        super("General Exception");
        this.errorCode = errorCode;
    }

    public TmsGeneralException(int errorCode, Vector itms) {
        super("General Exception");
        this.errorCode = errorCode;
        this.errorItems = itms;
    }

    public TmsGeneralException(String msg) {
        super(msg);
    }

    public TmsGeneralException(String msg, int errorCode) {
        super(msg);
        this.errorCode = errorCode;
    }

    public TmsGeneralException(String msg, Vector itms) {
        super(msg);
        this.errorItems = itms;
    }

    public TmsGeneralException(String msg, int errorCode, Vector itms) {
        super(msg);
        this.errorCode = errorCode;
        this.errorItems = itms;
    }

    public TmsGeneralException(String msg, Exception e) {
        super(msg);
        this.rootException = e;
    }

    public TmsGeneralException(Vector itms) {
        super("General-Exception");
        this.errorItems = itms;
    }

    public void addApplicationException(String itemDescription) {
        TmsGeneralExceptionItem newExceptionItem = new TmsGeneralExceptionItem(itemDescription, -1, 3);
        if (this.errorItems == null) {
            this.errorItems = new Vector();
        }
        this.errorItems.addElement(newExceptionItem);
    }

    public void addApplicationException(String itemDescription, int itemErrorCode) {
        TmsGeneralExceptionItem newExceptionItem = new TmsGeneralExceptionItem(itemDescription, itemErrorCode, 3);
        if (this.errorItems == null) {
            this.errorItems = new Vector();
        }
        this.errorItems.addElement(newExceptionItem);
    }

    public void addGeneralException(String itemDescription, int itemErrorCode, int itemErrorType) {
        TmsGeneralExceptionItem newExceptionItem = new TmsGeneralExceptionItem(itemDescription, itemErrorCode, itemErrorType);
        if (this.errorItems == null) {
            this.errorItems = new Vector();
        }
        this.errorItems.addElement(newExceptionItem);
    }

    public void addLogicException(String itemDescription) {
        TmsGeneralExceptionItem newExceptionItem = new TmsGeneralExceptionItem(itemDescription, -1, 2);
        if (this.errorItems == null) {
            this.errorItems = new Vector();
        }
        this.errorItems.addElement(newExceptionItem);
    }

    public void addLogicException(String itemDescription, int itemErrorCode) {
        TmsGeneralExceptionItem newExceptionItem = new TmsGeneralExceptionItem(itemDescription, itemErrorCode, 2);
        if (this.errorItems == null) {
            this.errorItems = new Vector();
        }
        this.errorItems.addElement(newExceptionItem);
    }

    public void addPropertyException(String itemDescription, int itemErrorCode, String itemFieldName) {
        TmsGeneralExceptionItem newExceptionItem = new TmsGeneralExceptionItem(itemDescription, itemErrorCode, itemFieldName, 1);
        if (this.errorItems == null) {
            this.errorItems = new Vector();
        }
        this.errorItems.addElement(newExceptionItem);
    }

    public void addPropertyException(String itemDescription, String itemFieldName) {
        TmsGeneralExceptionItem newExceptionItem = new TmsGeneralExceptionItem(itemDescription, -1, itemFieldName, 1);
        if (this.errorItems == null) {
            this.errorItems = new Vector();
        }
        this.errorItems.addElement(newExceptionItem);
    }

    public void combine(TmsGeneralException ex) {
        if (ex.getExceptionItemCount() > 0) {
            int i = 0;
            while (i < ex.getExceptionItemCount()) {
                TmsGeneralExceptionItem currentItem = ex.getExceptionItemAt(i);
                if (this.errorItems == null) {
                    this.errorItems = new Vector();
                }
                this.errorItems.addElement(currentItem);
                ++i;
            }
        }
    }

    public int getErrorCode() {
        return this.errorCode;
    }

    public void setErrorCode(int error) {
        this.errorCode = error;
    }

    public Vector getExceptionItems() {
        return this.errorItems;
    }

    public TmsGeneralExceptionItem getExceptionItemAt(int itemIndex) {
        if (this.errorItems == null) {
            return null;
        }
        return (TmsGeneralExceptionItem)this.errorItems.elementAt(itemIndex);
    }

    public int getExceptionItemCount() {
        if (this.errorItems == null) {
            return 0;
        }
        return this.errorItems.size();
    }

    public void removeExceptionItemAt(int itemIndex) {
        if (this.errorItems != null) {
            this.errorItems.removeElementAt(itemIndex);
        }
    }

    public String toString() {
        String output = String.valueOf(super.toString()) + "\r\n";
        output = String.valueOf(output) + "  Exception Error Code : " + this.errorCode + "\r\n";
        if (this.errorItems != null && !this.errorItems.isEmpty()) {
            output = String.valueOf(output) + "  Exception Error Item(s) : \r\n";
            int itemCount = 0;
            while (itemCount < this.errorItems.size()) {
                output = String.valueOf(output) + ((TmsGeneralExceptionItem)this.errorItems.elementAt(itemCount)).toString() + "\r\n";
                ++itemCount;
            }
        }
        return output;
    }

    public void printStackTrace() {
        super.printStackTrace();
        if (this.rootException != null) {
            System.err.println("\nInitiating exception:");
            this.rootException.printStackTrace();
        }
    }

    public void printStackTrace(PrintStream stream) {
        super.printStackTrace(stream);
        if (this.rootException != null) {
            stream.println("\nInitiating exception:");
            this.rootException.printStackTrace(stream);
        }
    }

    public void printStackTrace(PrintWriter writer) {
        super.printStackTrace(writer);
        if (this.rootException != null) {
            writer.println("\nInitiating exception:");
            this.rootException.printStackTrace(writer);
        }
    }
}

