/*
 * Decompiled with CFR 0.152.
 */
package nz.co.k.tms.billing.settlement.buyline;

import java.util.StringTokenizer;
import nz.co.k.tms.billing.settlement.buyline.BuyLineHelper;
import nz.co.k.tms.exception.TmsParseException;

public class BuyLineVoidResponse {
    private Integer dataOpsId = null;
    private Integer dataSequneceNumber = null;
    private String dataResponseCode = null;
    private String dataResponseText = null;
    private static final int MES_TYP_POS = 1;
    private static final int OPS_ID_POS = 2;
    private static final int SEQ_NUM_POS = 3;
    private static final int RES_COD_POS = 4;
    private static final int RES_TXT_POS = 5;

    public BuyLineVoidResponse(Integer opsId, Integer sequneceNumber, String responseCode, String responseText) throws TmsParseException {
        if (opsId.toString().length() > 8) {
            throw new TmsParseException("BuyLineVoidResponse: The OPS ID :" + opsId.toString() + ": is longer than the allowed maximum of :" + 8 + ":");
        }
        this.dataOpsId = opsId;
        if (sequneceNumber.toString().length() > 6) {
            throw new TmsParseException("BuyLineVoidResponse: The Sequnece Number :" + sequneceNumber.toString() + ": is longer than the allowed maximum of :" + 6 + ":");
        }
        this.dataSequneceNumber = sequneceNumber;
        if (responseCode.length() > 2) {
            throw new TmsParseException("BuyLineVoidResponse: The Response Code :" + responseCode + ": is longer than the allowed maximum of :" + 2 + ":");
        }
        this.dataResponseCode = responseCode;
        if (responseText.length() > 60) {
            throw new TmsParseException("BuyLineVoidResponse: The Response Text :" + responseText + ": is longer than the allowed maximum of :" + 60 + ":");
        }
        this.dataResponseText = responseText;
    }

    public BuyLineVoidResponse(String messageString) throws TmsParseException {
        if (messageString != null) {
            StringTokenizer tokenizedMessage = new StringTokenizer(messageString = BuyLineHelper.removeBuyLineControlInfo(messageString), "~");
            if (tokenizedMessage != null) {
                int tokenCount = 1;
                while (tokenizedMessage.hasMoreTokens()) {
                    if (tokenCount == 1) {
                        if (!tokenizedMessage.nextToken().equals("V")) {
                            throw new TmsParseException("BuyLineVoidResponse create : the message string passed in is not a Void response ");
                        }
                    } else if (tokenCount == 2) {
                        try {
                            this.dataOpsId = new Integer(tokenizedMessage.nextToken());
                        }
                        catch (NumberFormatException nfex) {
                            throw new TmsParseException("BuyLineVoidResponse create : OpsId must be an Integer : " + nfex.getMessage());
                        }
                    } else if (tokenCount == 3) {
                        try {
                            this.dataSequneceNumber = new Integer(tokenizedMessage.nextToken());
                        }
                        catch (NumberFormatException nfex) {
                            throw new TmsParseException("BuyLineVoidResponse create : SequneceNumber must be an Integer : " + nfex.getMessage());
                        }
                    } else if (tokenCount == 4) {
                        this.dataResponseCode = tokenizedMessage.nextToken();
                    } else if (tokenCount == 5) {
                        this.dataResponseText = tokenizedMessage.nextToken();
                    }
                    ++tokenCount;
                }
                if (this.dataOpsId == null) {
                    throw new TmsParseException("BuyLineVoidResponse create : OpsId was null after tokenizing message string");
                }
                if (this.dataSequneceNumber == null) {
                    throw new TmsParseException("BuyLineVoidResponse create : SequneceNumber was null after tokenizing message string");
                }
                if (this.dataResponseCode == null) {
                    throw new TmsParseException("BuyLineVoidResponse create : ResponseCode was null after tokenizing message string");
                }
                if (this.dataResponseText == null) {
                    throw new TmsParseException("BuyLineVoidResponse create : ResponseText was null after tokenizing message string");
                }
            }
        } else {
            throw new TmsParseException("BuyLineVoidResponse create : You cannot create a response from a null message string");
        }
    }

    public String toString() {
        String result = "V";
        result = result.concat("~");
        result = result.concat(this.dataOpsId.toString());
        result = result.concat("~");
        result = result.concat(this.dataSequneceNumber.toString());
        result = result.concat("~");
        result = result.concat(this.dataResponseCode);
        result = result.concat("~");
        result = result.concat(this.dataResponseText);
        result = BuyLineHelper.addBuyLineControlInfo(result);
        return result;
    }

    public Integer getOpsId() {
        return this.dataOpsId;
    }

    public Integer getSequneceNumber() {
        return this.dataSequneceNumber;
    }

    public String getResponseCode() {
        return this.dataResponseCode;
    }

    public String getResponseText() {
        return this.dataResponseText;
    }
}

