/*
 * Decompiled with CFR 0.152.
 */
package nz.co.k.tms.billing.settlement.buyline;

import java.io.IOException;
import java.util.Timer;
import java.util.TimerTask;
import nz.co.k.tms.billing.BillingEngine;
import nz.co.k.tms.billing.settlement.buyline.BuyLineVoidMessageProcessor;
import nz.co.k.tms.exception.TmsGeneralException;
import nz.co.k.tms.utility.FileQueue;
import nz.co.k.tms.utility.LogHelper;
import nz.co.k.tms.utility.TmsPropertyHelper;
import org.apache.log4j.Level;

public class BuyLineVoidMessageSender {
    protected String buyLineVoidSendQueueLocation = null;
    protected String scheduledPeriod = null;
    private static TmsPropertyHelper tmsProperties = null;
    protected Timer timer;
    protected BillingEngine billingEngine;

    public BuyLineVoidMessageSender(BillingEngine billingEngine) {
        if (billingEngine != null) {
            this.billingEngine = billingEngine;
            if (tmsProperties == null) {
                try {
                    tmsProperties = new TmsPropertyHelper();
                    tmsProperties.load();
                }
                catch (TmsGeneralException tmsgex) {
                    LogHelper.getBuyLineLogger().log(Level.FATAL, (Object)("BuyLine Void Message Sender failed to load TmsProperties file:/config/application/tms.properties: details :" + tmsgex.toString() + ":"));
                }
            }
            this.buyLineVoidSendQueueLocation = BuyLineVoidMessageSender.tmsProperties.BuyLineVoidQueueBase;
            this.scheduledPeriod = BuyLineVoidMessageSender.tmsProperties.BuyLineVoidScheduledPeriod;
            this.timer = new Timer();
            long scheduleRegularLong = 10000L;
            try {
                scheduleRegularLong = Long.parseLong(this.scheduledPeriod) * 1000L;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            if (scheduleRegularLong < 1L) {
                LogHelper.getBuyLineLogger().log(Level.INFO, (Object)"BuyLine Void Sender is not running. Config file set to disable");
                this.timer.cancel();
            } else {
                this.timer.schedule((TimerTask)new Sender(), 10000L, scheduleRegularLong);
            }
        } else {
            LogHelper.getBuyLineLogger().log(Level.FATAL, (Object)"Could not create BuyLine Void Message Sender as BillingEngine passed to constructor is null");
        }
    }

    class Sender
    extends TimerTask {
        Sender() {
        }

        public void run() {
            if (BuyLineVoidMessageSender.this.billingEngine.getServletContext() != null) {
                this.processQueuedMessages(BuyLineVoidMessageSender.this.buyLineVoidSendQueueLocation);
            } else {
                this.cancel();
                if (BuyLineVoidMessageSender.this.timer != null) {
                    BuyLineVoidMessageSender.this.timer.cancel();
                    LogHelper.getBuyLineLogger().log(Level.WARN, (Object)"BuyLine Void Sender timer cancelled.");
                }
            }
        }

        private void processQueuedMessages(String queueLocation) {
            LogHelper.getBuyLineLogger().log(Level.INFO, (Object)"BuyLine Void Message Sender is running");
            FileQueue queue = new FileQueue(queueLocation);
            String[] fileNames = queue.getAllFileNames();
            if (fileNames == null) {
                LogHelper.getBuyLineLogger().log(Level.INFO, (Object)"BuyLine Void Message Sender has stopped. No File(s) in the queue");
                return;
            }
            BuyLineVoidMessageProcessor processor = new BuyLineVoidMessageProcessor();
            int buylineVoidQueueIndex = 0;
            while (buylineVoidQueueIndex < fileNames.length) {
                try {
                    boolean resultRemoveFileLdapQueue;
                    String fileName = fileNames[buylineVoidQueueIndex];
                    String fileContent = queue.getByName(fileName);
                    LogHelper.getBuyLineLogger().log(Level.INFO, (Object)("BuyLine Void Message Sender: Processing the file :" + fileNames[buylineVoidQueueIndex] + ":"));
                    boolean processedSuccessfully = processor.processMessage(fileContent);
                    if (processedSuccessfully && (resultRemoveFileLdapQueue = queue.removeByName(fileName))) {
                        LogHelper.getBuyLineLogger().log(Level.INFO, (Object)("<<<< The file :" + fileName + ": was removed from the BuyLine Void Message queue."));
                    }
                }
                catch (IOException ioe) {
                    LogHelper.getBuyLineLogger().log(Level.ERROR, (Object)("BuyLine Void Message Sender: Could not get the file contents. File :" + fileNames[buylineVoidQueueIndex] + ":"));
                }
                ++buylineVoidQueueIndex;
            }
            LogHelper.getBuyLineLogger().log(Level.INFO, (Object)("BuyLine Void Message Sender has stopped. " + fileNames.length + " File(s) were in the queue "));
        }
    }
}

