/*
 * Decompiled with CFR 0.152.
 */
package nz.co.k.tms.billing.settlement.buyline;

import java.io.IOException;
import java.net.SocketTimeoutException;
import nz.co.k.tms.billing.settlement.buyline.BuyLineMessageSender;
import nz.co.k.tms.billing.settlement.buyline.BuyLineVoidResponse;
import nz.co.k.tms.exception.TmsGeneralException;
import nz.co.k.tms.exception.TmsParseException;
import nz.co.k.tms.utility.LogHelper;
import nz.co.k.tms.utility.TmsPropertyHelper;
import org.apache.log4j.Level;

public class BuyLineVoidMessageProcessor {
    public static TmsPropertyHelper tmsProperties = null;

    public BuyLineVoidMessageProcessor() {
        if (tmsProperties == null) {
            try {
                tmsProperties = new TmsPropertyHelper();
                tmsProperties.load();
            }
            catch (TmsGeneralException tmsgex) {
                LogHelper.getBuyLineLogger().log(Level.FATAL, (Object)("BuyLineVoidMessageProcessor failed to load TmsProperties file:/config/application/tms.properties: details :" + tmsgex.toString() + ":"));
            }
        }
    }

    public boolean processMessage(String queuedMessage) {
        boolean result = false;
        try {
            String responseString = BuyLineMessageSender.sendMessage(queuedMessage, true);
            if (responseString != null) {
                BuyLineVoidResponse responseBuyLineVoidResponse = new BuyLineVoidResponse(responseString);
                LogHelper.getBuyLineLogger().log(Level.INFO, (Object)("BuyLine Void Message Processor sent message. Reponse code from server :" + responseBuyLineVoidResponse.getResponseCode() + ":"));
                result = true;
            }
        }
        catch (SocketTimeoutException e) {
            result = false;
        }
        catch (IOException e) {
            result = false;
        }
        catch (TmsParseException tmspex) {
            result = false;
        }
        catch (TmsGeneralException tmsgex) {
            result = false;
        }
        return result;
    }
}

