/*
 * Decompiled with CFR 0.152.
 */
package nz.co.k.tms.billing.settlement.buyline;

import java.io.IOException;
import nz.co.k.tms.billing.settlement.buyline.BuyLineHelper;
import nz.co.k.tms.billing.settlement.buyline.BuyLineMessageSender;
import nz.co.k.tms.billing.settlement.buyline.BuyLineRefundResponse;
import nz.co.k.tms.exception.TmsGeneralException;
import nz.co.k.tms.exception.TmsParseException;
import nz.co.k.tms.utility.DateHelper;

public class BuyLineRefundRequest {
    private Integer dataOpsId = null;
    private Integer dataSequneceNumber = null;
    private String dataOpsPassord = null;
    private Integer dataAmount = null;
    private Long dataCardNumber = null;
    private Integer dataCardExpiry = null;
    private Integer dataCurrencyCode = null;

    public BuyLineRefundRequest(Integer opsId, String opsPassord, Integer amount, Long cardNumber, Integer cardExpiry, Integer currencyCode) throws TmsParseException {
        if (opsId.toString().length() > 8) {
            throw new TmsParseException("BuyLineRefundRequest: The OPS ID :" + opsId.toString() + ": is longer than the allowed maximum of :" + 8 + ":");
        }
        this.dataOpsId = opsId;
        this.dataSequneceNumber = BuyLineHelper.getNextSequenceNumber();
        if (opsPassord.length() > 8) {
            throw new TmsParseException("BuyLineRefundRequest: The OPS Passord:" + opsPassord + ": is longer than the allowed maximum of :" + 8 + ":");
        }
        this.dataOpsPassord = opsPassord;
        if (amount.toString().length() > 8) {
            throw new TmsParseException("BuyLineRefundRequest: The Amount :" + amount.toString() + ": is longer than the allowed maximum of :" + 8 + ":");
        }
        this.dataAmount = amount;
        if (cardNumber.toString().length() > 19) {
            throw new TmsParseException("BuyLineRefundRequest: The Card Number :" + cardNumber.toString() + ": is longer than the allowed maximum of :" + 19 + ":");
        }
        this.dataCardNumber = cardNumber;
        if (cardExpiry.toString().length() > 6) {
            throw new TmsParseException("BuyLineRefundRequest: The Card Expiry :" + cardExpiry.toString() + ": is longer than the allowed maximum of :" + 6 + ":");
        }
        this.dataCardExpiry = cardExpiry;
        DateHelper.parseExpiryDate(this.dataCardExpiry.toString());
        if (currencyCode.toString().length() > 3) {
            throw new TmsParseException("BuyLineRefundRequest: The Currency Code :" + currencyCode.toString() + ": is longer than the allowed maximum of :" + 3 + ":");
        }
        this.dataCurrencyCode = currencyCode;
    }

    public BuyLineRefundRequest(Integer opsId, Integer sequneceNumber, String opsPassord, Integer amount, Long cardNumber, Integer cardExpiry, Integer currencyCode) throws TmsParseException {
        if (opsId.toString().length() > 8) {
            throw new TmsParseException("BuyLineRefundRequest: The OPS ID :" + opsId.toString() + ": is longer than the allowed maximum of :" + 8 + ":");
        }
        this.dataOpsId = opsId;
        this.dataSequneceNumber = sequneceNumber == null ? BuyLineHelper.getNextSequenceNumber() : sequneceNumber;
        if (opsPassord.length() > 8) {
            throw new TmsParseException("BuyLineRefundRequest: The OPS Passord:" + opsPassord + ": is longer than the allowed maximum of :" + 8 + ":");
        }
        this.dataOpsPassord = opsPassord;
        if (amount.toString().length() > 8) {
            throw new TmsParseException("BuyLineRefundRequest: The Amount :" + amount.toString() + ": is longer than the allowed maximum of :" + 8 + ":");
        }
        this.dataAmount = amount;
        if (cardNumber.toString().length() > 19) {
            throw new TmsParseException("BuyLineRefundRequest: The Card Number :" + cardNumber.toString() + ": is longer than the allowed maximum of :" + 19 + ":");
        }
        this.dataCardNumber = cardNumber;
        if (cardExpiry.toString().length() > 6) {
            throw new TmsParseException("BuyLineRefundRequest: The Card Expiry :" + cardExpiry.toString() + ": is longer than the allowed maximum of :" + 6 + ":");
        }
        this.dataCardExpiry = cardExpiry;
        DateHelper.parseExpiryDate(this.dataCardExpiry.toString());
        if (currencyCode.toString().length() > 3) {
            throw new TmsParseException("BuyLineRefundRequest: The Currency Code :" + currencyCode.toString() + ": is longer than the allowed maximum of :" + 3 + ":");
        }
        this.dataCurrencyCode = currencyCode;
    }

    public BuyLineRefundResponse sendMessage() throws TmsGeneralException {
        return this.sendMessage(true);
    }

    public BuyLineRefundResponse sendMessage(boolean obeyStatus) throws TmsGeneralException {
        BuyLineRefundResponse result = null;
        try {
            String responseString = BuyLineMessageSender.sendMessage(this.toString(), obeyStatus);
            if (responseString != null) {
                result = new BuyLineRefundResponse(responseString);
            }
        }
        catch (IOException ioex) {
            throw new TmsGeneralException(" BuyLineRefundRequest sendMessage: IOException ", ioex);
        }
        return result;
    }

    public String toString() {
        String result = "R";
        result = result.concat("~");
        result = result.concat(this.dataOpsId.toString());
        result = result.concat("~");
        result = result.concat(BuyLineHelper.paddSequenceNumber(this.dataSequneceNumber));
        result = result.concat("~");
        result = result.concat(this.dataOpsPassord);
        result = result.concat("~");
        result = result.concat(this.dataAmount.toString());
        result = result.concat("~");
        result = result.concat(this.dataCardNumber.toString());
        result = result.concat("~");
        result = result.concat(BuyLineHelper.paddExpiryDate(this.dataCardExpiry));
        result = result.concat("~");
        result = result.concat(this.dataCurrencyCode.toString());
        result = BuyLineHelper.addBuyLineControlInfo(result);
        return result;
    }

    public Integer getOpsId() {
        return this.dataOpsId;
    }

    public Integer getSequneceNumber() {
        return this.dataSequneceNumber;
    }

    public String getOpsPassord() {
        return this.dataOpsPassord;
    }

    public Integer getAmount() {
        return this.dataAmount;
    }

    public Long getCardNumber() {
        return this.dataCardNumber;
    }

    public Integer getCardExpiry() {
        return this.dataCardExpiry;
    }

    public Integer getCurrencyCode() {
        return this.dataCurrencyCode;
    }
}

