/*
 * Decompiled with CFR 0.152.
 */
package nz.co.k.tms.billing.settlement.buyline;

import java.io.IOException;
import java.net.SocketTimeoutException;
import nz.co.k.tms.billing.settlement.buyline.BuyLineHelper;
import nz.co.k.tms.billing.settlement.buyline.BuyLineMessageSender;
import nz.co.k.tms.billing.settlement.buyline.BuyLinePurchaseResponse;
import nz.co.k.tms.billing.settlement.buyline.BuyLineVoidMessageHandler;
import nz.co.k.tms.billing.settlement.buyline.BuyLineVoidRequest;
import nz.co.k.tms.exception.TmsGeneralException;
import nz.co.k.tms.exception.TmsParseException;
import nz.co.k.tms.utility.DateHelper;
import nz.co.k.tms.utility.LogHelper;
import nz.co.k.tms.utility.TmsPropertyHelper;
import org.apache.log4j.Level;

public class BuyLinePurchaseRequest {
    private Integer dataOpsId = null;
    private Integer dataSequneceNumber = null;
    private Integer dataAmount = null;
    private Long dataCardNumber = null;
    private Integer dataCardExpiry = null;
    private Integer dataCurrencyCode = null;

    public BuyLinePurchaseRequest(Integer opsId, Integer amount, Long cardNumber, Integer cardExpiry, Integer currencyCode) throws TmsParseException {
        if (opsId.toString().length() > 8) {
            throw new TmsParseException("BuyLinePurchaseRequest: The OPS ID :" + opsId.toString() + ": is longer than the allowed maximum of :" + 8 + ":");
        }
        this.dataOpsId = opsId;
        this.dataSequneceNumber = BuyLineHelper.getNextSequenceNumber();
        if (amount.toString().length() > 8) {
            throw new TmsParseException("BuyLinePurchaseRequest: The Amount :" + amount.toString() + ": is longer than the allowed maximum of :" + 8 + ":");
        }
        this.dataAmount = amount;
        if (cardNumber.toString().length() > 19) {
            throw new TmsParseException("BuyLinePurchaseRequest: The Card Number :" + cardNumber.toString() + ": is longer than the allowed maximum of :" + 19 + ":");
        }
        this.dataCardNumber = cardNumber;
        if (cardExpiry.toString().length() > 6) {
            throw new TmsParseException("BuyLinePurchaseRequest: The Card Expiry :" + cardExpiry.toString() + ": is longer than the allowed maximum of :" + 6 + ":");
        }
        this.dataCardExpiry = cardExpiry;
        DateHelper.parseExpiryDate(this.dataCardExpiry.toString());
        if (currencyCode.toString().length() > 3) {
            throw new TmsParseException("BuyLinePurchaseRequest: The Currency Code :" + currencyCode.toString() + ": is longer than the allowed maximum of :" + 3 + ":");
        }
        this.dataCurrencyCode = currencyCode;
    }

    public BuyLinePurchaseRequest(Integer opsId, Integer sequneceNumber, Integer amount, Long cardNumber, Integer cardExpiry, Integer currencyCode) throws TmsParseException {
        if (opsId.toString().length() > 8) {
            throw new TmsParseException("BuyLinePurchaseRequest: The OPS ID :" + opsId.toString() + ": is longer than the allowed maximum of :" + 8 + ":");
        }
        this.dataOpsId = opsId;
        this.dataSequneceNumber = sequneceNumber == null ? BuyLineHelper.getNextSequenceNumber() : sequneceNumber;
        if (amount.toString().length() > 8) {
            throw new TmsParseException("BuyLinePurchaseRequest: The Amount :" + amount.toString() + ": is longer than the allowed maximum of :" + 8 + ":");
        }
        this.dataAmount = amount;
        if (cardNumber.toString().length() > 19) {
            throw new TmsParseException("BuyLinePurchaseRequest: The Card Number :" + cardNumber.toString() + ": is longer than the allowed maximum of :" + 19 + ":");
        }
        this.dataCardNumber = cardNumber;
        if (cardExpiry.toString().length() > 6) {
            throw new TmsParseException("BuyLinePurchaseRequest: The Card Expiry :" + cardExpiry.toString() + ": is longer than the allowed maximum of :" + 6 + ":");
        }
        this.dataCardExpiry = cardExpiry;
        DateHelper.parseExpiryDate(this.dataCardExpiry.toString());
        if (currencyCode.toString().length() > 3) {
            throw new TmsParseException("BuyLinePurchaseRequest: The Currency Code :" + currencyCode.toString() + ": is longer than the allowed maximum of :" + 3 + ":");
        }
        this.dataCurrencyCode = currencyCode;
    }

    public BuyLinePurchaseResponse sendMessage() throws TmsGeneralException {
        return this.sendMessage(true);
    }

    public BuyLinePurchaseResponse sendMessage(boolean obeyStatus) throws TmsGeneralException {
        BuyLinePurchaseResponse result = null;
        try {
            String responseString = BuyLineMessageSender.sendMessage(this.toString(), obeyStatus);
            if (responseString != null) {
                result = new BuyLinePurchaseResponse(responseString);
            } else {
                this.sendVoidToQueue();
            }
        }
        catch (SocketTimeoutException socktimeex) {
            this.sendVoidToQueue();
            throw new TmsGeneralException(" BuyLinePurchaseRequest sendMessage: SocketTimeoutException ", socktimeex);
        }
        catch (IOException ioex) {
            this.sendVoidToQueue();
            throw new TmsGeneralException(" BuyLinePurchaseRequest sendMessage: IOException ", ioex);
        }
        return result;
    }

    public void sendVoidToQueue() {
        try {
            TmsPropertyHelper tmsProperties = new TmsPropertyHelper();
            tmsProperties.load();
            BuyLineVoidRequest newBuyLineVoidRequest = new BuyLineVoidRequest(this.getOpsId(), this.getSequneceNumber(), tmsProperties.BuyLineServerOpsPass, this.getAmount(), this.getCardNumber(), this.getCurrencyCode());
            BuyLineVoidMessageHandler.sendMessageToQueue(newBuyLineVoidRequest.toString());
        }
        catch (TmsGeneralException tmsgex) {
            LogHelper.getBuyLineLogger().log(Level.ERROR, (Object)("TmsGeneralException : Could not send void for failed BuyLine purchase. Details :" + tmsgex.getMessage() + ":"));
        }
    }

    public String toString() {
        String result = "P";
        result = result.concat("~");
        result = result.concat(this.dataOpsId.toString());
        result = result.concat("~");
        result = result.concat(BuyLineHelper.paddSequenceNumber(this.dataSequneceNumber));
        result = result.concat("~");
        result = result.concat("~");
        result = result.concat(this.dataAmount.toString());
        result = result.concat("~");
        result = result.concat(this.dataCardNumber.toString());
        result = result.concat("~");
        result = result.concat(BuyLineHelper.paddExpiryDate(this.dataCardExpiry));
        result = result.concat("~");
        result = result.concat(this.dataCurrencyCode.toString());
        result = BuyLineHelper.addBuyLineControlInfo(result);
        return result;
    }

    public Integer getOpsId() {
        return this.dataOpsId;
    }

    public Integer getSequneceNumber() {
        return this.dataSequneceNumber;
    }

    public Integer getAmount() {
        return this.dataAmount;
    }

    public Long getCardNumber() {
        return this.dataCardNumber;
    }

    public Integer getCardExpiry() {
        return this.dataCardExpiry;
    }

    public Integer getCurrencyCode() {
        return this.dataCurrencyCode;
    }
}

