/*
 * Decompiled with CFR 0.152.
 */
package nz.co.k.tms.billing.settlement.buyline;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.Socket;
import java.net.SocketTimeoutException;
import nz.co.k.tms.billing.settlement.buyline.BuyLineAuthorizationResponse;
import nz.co.k.tms.billing.settlement.buyline.BuyLineCompletionResponse;
import nz.co.k.tms.billing.settlement.buyline.BuyLineEnquiryResponse;
import nz.co.k.tms.billing.settlement.buyline.BuyLineHelper;
import nz.co.k.tms.billing.settlement.buyline.BuyLinePurchaseResponse;
import nz.co.k.tms.billing.settlement.buyline.BuyLineRefundResponse;
import nz.co.k.tms.billing.settlement.buyline.BuyLineVoidResponse;
import nz.co.k.tms.exception.TmsGeneralException;
import nz.co.k.tms.utility.LogHelper;
import nz.co.k.tms.utility.TmsPropertyHelper;
import org.apache.log4j.Level;

public class BuyLineMessageSender {
    private static TmsPropertyHelper tmsProperties = null;

    public static String sendMessage(String messageToSend, boolean obeyStatus) throws IOException, SocketTimeoutException, TmsGeneralException {
        if (tmsProperties == null) {
            tmsProperties = new TmsPropertyHelper();
            try {
                tmsProperties.load();
            }
            catch (TmsGeneralException tmsgex) {
                LogHelper.getBuyLineLogger().log(Level.FATAL, (Object)("BuyLineMessageSender failed to load TmsProperties file:/config/application/tms.properties: details :" + tmsgex.toString() + ":"));
                throw new TmsGeneralException("BuyLineMessageSender failed to load TmsProperties file:/config/application/tms.properties: details :" + tmsgex.toString() + ":");
            }
        }
        String receivedBuyLineMessage = null;
        LogHelper.getBuyLineLogger().log(Level.DEBUG, (Object)("BuyLine message to send :" + messageToSend + ":"));
        if (BuyLineMessageSender.tmsProperties.BuyLineServerStatus == 0 || !obeyStatus) {
            LogHelper.getBuyLineLogger().log(Level.DEBUG, (Object)"BuyLine message to be sent via socket.");
            receivedBuyLineMessage = BuyLineMessageSender.sendMessageViaSocket(messageToSend);
        } else if (BuyLineMessageSender.tmsProperties.BuyLineServerStatus == 1) {
            LogHelper.getBuyLineLogger().log(Level.DEBUG, (Object)"BuyLine Disable FAILURE message to be returned.");
            receivedBuyLineMessage = null;
        } else if (BuyLineMessageSender.tmsProperties.BuyLineServerStatus == 2) {
            LogHelper.getBuyLineLogger().log(Level.DEBUG, (Object)"BuyLine Disable SUCCESSS message to be returned.");
            String messageType = BuyLineHelper.getMessageTypeIdentifier(messageToSend);
            if (messageType.equals("A")) {
                receivedBuyLineMessage = new BuyLineAuthorizationResponse(new Integer(Integer.parseInt(BuyLineMessageSender.tmsProperties.BuyLineServerOpsId)), BuyLineHelper.getMessageSequenceOrSettlementNumber(messageToSend), "OK", "00").toString();
            } else if (messageType.equals("C")) {
                receivedBuyLineMessage = new BuyLineCompletionResponse(new Integer(Integer.parseInt(BuyLineMessageSender.tmsProperties.BuyLineServerOpsId)), BuyLineHelper.getMessageSequenceOrSettlementNumber(messageToSend), "OK", "00").toString();
            } else if (messageType.equals("E")) {
                receivedBuyLineMessage = new BuyLineEnquiryResponse(new Integer(Integer.parseInt(BuyLineMessageSender.tmsProperties.BuyLineServerOpsId)), BuyLineHelper.getMessageSequenceOrSettlementNumber(messageToSend), "OK", new Integer(0), new Long("6009199900000017"), "00", new Integer(0)).toString();
            } else if (messageType.equals("P")) {
                receivedBuyLineMessage = new BuyLinePurchaseResponse(new Integer(Integer.parseInt(BuyLineMessageSender.tmsProperties.BuyLineServerOpsId)), BuyLineHelper.getMessageSequenceOrSettlementNumber(messageToSend), "OK", "00").toString();
            } else if (messageType.equals("R")) {
                receivedBuyLineMessage = new BuyLineRefundResponse(new Integer(Integer.parseInt(BuyLineMessageSender.tmsProperties.BuyLineServerOpsId)), BuyLineHelper.getMessageSequenceOrSettlementNumber(messageToSend), "OK", "00").toString();
            } else if (messageType.equals("V")) {
                receivedBuyLineMessage = new BuyLineVoidResponse(new Integer(Integer.parseInt(BuyLineMessageSender.tmsProperties.BuyLineServerOpsId)), BuyLineHelper.getMessageSequenceOrSettlementNumber(messageToSend), "OK", "00").toString();
            }
        }
        LogHelper.getBuyLineLogger().log(Level.DEBUG, (Object)("BuyLine message received :" + receivedBuyLineMessage + ":"));
        return receivedBuyLineMessage;
    }

    public static String sendMessageViaSocket(String sendMessage) throws IOException, SocketTimeoutException, TmsGeneralException {
        if (tmsProperties == null) {
            tmsProperties = new TmsPropertyHelper();
            try {
                tmsProperties.load();
            }
            catch (TmsGeneralException tmsgex) {
                LogHelper.getBuyLineLogger().log(Level.FATAL, (Object)("BuyLineMessageSender failed to load TmsProperties file:/config/application/tms.properties: details :" + tmsgex.toString() + ":"));
                throw new TmsGeneralException("BuyLineMessageSender failed to load TmsProperties file:/config/application/tms.properties: details :" + tmsgex.toString() + ":");
            }
        }
        String receivedFromBuyLine = null;
        Socket connectionToBuyLineServer = new Socket(BuyLineMessageSender.tmsProperties.BuyLineServerIP, BuyLineMessageSender.tmsProperties.BuyLineServerPort);
        connectionToBuyLineServer.setSoTimeout(BuyLineMessageSender.tmsProperties.BuyLineConnectionTimeout * 1000);
        PrintWriter dataSentToBuyLine = new PrintWriter(connectionToBuyLineServer.getOutputStream(), true);
        BufferedReader buyLineBufferedReader = new BufferedReader(new InputStreamReader(connectionToBuyLineServer.getInputStream()));
        dataSentToBuyLine.println(sendMessage);
        dataSentToBuyLine.flush();
        receivedFromBuyLine = buyLineBufferedReader.readLine();
        dataSentToBuyLine.close();
        buyLineBufferedReader.close();
        connectionToBuyLineServer.close();
        return receivedFromBuyLine;
    }
}

