/*
 * Decompiled with CFR 0.152.
 */
package nz.co.k.tms.billing.settlement.buyline;

import java.util.StringTokenizer;
import nz.co.k.tms.billing.settlement.buyline.BuyLineHelper;
import nz.co.k.tms.exception.TmsParseException;

public class BuyLineListingDetailResponse {
    private Integer dataOpsId = null;
    private Integer dataSequneceNumber = null;
    private String dataResponseCode = null;
    private String dataResponseMessageType = null;
    private Integer dataResponseAmount = null;
    private Long dataResponseCardNumber = null;
    private String dataSequenceNumber = null;
    private Integer dataResponseCurrency = null;
    private static final int MES_TYP_POS = 1;
    private static final int OPS_ID_POS = 2;
    private static final int SEQ_NUM_POS = 3;
    private static final int RES_COD_POS = 4;
    private static final int RES_MT_POS = 5;
    private static final int RES_AMT_POS = 6;
    private static final int RES_CDN_POS = 7;
    private static final int RES_SEQ_POS = 8;
    private static final int RES_CUR_POS = 9;

    public BuyLineListingDetailResponse(Integer opsId, Integer sequneceNumber, String responseCode, Integer responseAmount, Long responseCardNumber, String responseSequenceNumber, Integer responseCurrency) throws TmsParseException {
        if (opsId.toString().length() > 8) {
            throw new TmsParseException("BuyLineListingDetailResponse: The OPS ID :" + opsId.toString() + ": is longer than the allowed maximum of :" + 8 + ":");
        }
        this.dataOpsId = opsId;
        if (sequneceNumber.toString().length() > 6) {
            throw new TmsParseException("BuyLineListingDetailResponse: The Sequnece Number :" + sequneceNumber.toString() + ": is longer than the allowed maximum of :" + 6 + ":");
        }
        this.dataSequneceNumber = sequneceNumber;
        if (responseCode.length() > 2) {
            throw new TmsParseException("BuyLineListingDetailResponse: The Response Code :" + responseCode + ": is longer than the allowed maximum of :" + 2 + ":");
        }
        this.dataResponseCode = responseCode;
        this.dataResponseMessageType = "L";
        if (responseAmount.toString().length() > 8) {
            throw new TmsParseException("BuyLineListingDetailResponse: The Amount :" + responseAmount.toString() + ": is longer than the allowed maximum of :" + 8 + ":");
        }
        this.dataResponseAmount = responseAmount;
        if (responseCardNumber.toString().length() > 19) {
            throw new TmsParseException("BuyLineListingDetailResponse: The Card Number :" + responseCardNumber.toString() + ": is longer than the allowed maximum of :" + 19 + ":");
        }
        this.dataResponseCardNumber = responseCardNumber;
        if (responseSequenceNumber.length() > 6) {
            throw new TmsParseException("BuyLineListingDetailResponse: The Sequence Number :" + responseSequenceNumber + ": is longer than the allowed maximum of :" + 6 + ":");
        }
        this.dataSequenceNumber = responseSequenceNumber;
        if (responseCurrency.toString().length() > 10) {
            throw new TmsParseException("BuyLineListingDetailResponse: The Currency :" + responseCurrency.toString() + ": is longer than the allowed maximum of :" + 10 + ":");
        }
        this.dataResponseCurrency = responseCurrency;
    }

    public BuyLineListingDetailResponse(String messageString) throws TmsParseException {
        if (messageString != null) {
            StringTokenizer tokenizedMessage = new StringTokenizer(messageString = BuyLineHelper.removeBuyLineControlInfo(messageString), "~");
            if (tokenizedMessage != null) {
                int tokenCount = 1;
                while (tokenizedMessage.hasMoreTokens()) {
                    if (tokenCount == 1) {
                        if (!tokenizedMessage.nextToken().equals("E")) {
                            throw new TmsParseException("BuyLineListingDetailResponse create : the message string passed in is not an Enquiry response ");
                        }
                    } else {
                        if (tokenCount == 2) {
                            try {
                                this.dataOpsId = new Integer(tokenizedMessage.nextToken());
                            }
                            catch (NumberFormatException nfex) {
                                throw new TmsParseException("BuyLineListingDetailResponse create : OpsId must be an Integer : " + nfex.getMessage());
                            }
                        }
                        if (tokenCount == 3) {
                            try {
                                this.dataSequneceNumber = new Integer(tokenizedMessage.nextToken());
                            }
                            catch (NumberFormatException nfex) {
                                throw new TmsParseException("BuyLineListingDetailResponse create : SequneceNumber must be an Integer : " + nfex.getMessage());
                            }
                        }
                        if (tokenCount == 4) {
                            this.dataResponseCode = tokenizedMessage.nextToken();
                        } else if (tokenCount == 5) {
                            this.dataResponseMessageType = tokenizedMessage.nextToken();
                        } else {
                            if (tokenCount == 6) {
                                try {
                                    this.dataResponseAmount = new Integer(tokenizedMessage.nextToken());
                                }
                                catch (NumberFormatException nfex) {
                                    throw new TmsParseException("BuyLineListingDetailResponse create : Amount must be an Integer : " + nfex.getMessage());
                                }
                            }
                            if (tokenCount == 7) {
                                try {
                                    this.dataResponseCardNumber = new Long(tokenizedMessage.nextToken());
                                }
                                catch (NumberFormatException nfex) {
                                    throw new TmsParseException("BuyLineListingDetailResponse create : Card Number must be an Integer : " + nfex.getMessage());
                                }
                            }
                            if (tokenCount == 8) {
                                this.dataSequenceNumber = tokenizedMessage.nextToken();
                            } else if (tokenCount == 9) {
                                try {
                                    this.dataResponseCurrency = new Integer(tokenizedMessage.nextToken());
                                }
                                catch (NumberFormatException nfex) {
                                    throw new TmsParseException("BuyLineListingDetailResponse create : Currency must be an Integer : " + nfex.getMessage());
                                }
                            }
                        }
                    }
                    ++tokenCount;
                }
                if (this.dataOpsId == null) {
                    throw new TmsParseException("BuyLineListingDetailResponse create : OpsId was null after tokenizing message string");
                }
                if (this.dataSequneceNumber == null) {
                    throw new TmsParseException("BuyLineListingDetailResponse create : SequneceNumber was null after tokenizing message string");
                }
                if (this.dataResponseCode == null) {
                    throw new TmsParseException("BuyLineListingDetailResponse create : ResponseCode was null after tokenizing message string");
                }
                if (this.dataResponseMessageType == null) {
                    throw new TmsParseException("BuyLineListingDetailResponse create : Response Message Type was null after tokenizing message string");
                }
                if (this.dataResponseAmount == null) {
                    throw new TmsParseException("BuyLineListingDetailResponse create : Amount was null after tokenizing message string");
                }
                if (this.dataResponseCardNumber == null) {
                    throw new TmsParseException("BuyLineListingDetailResponse create : Customer Card Number was null after tokenizing message string");
                }
                if (this.dataSequenceNumber == null) {
                    throw new TmsParseException("BuyLineListingDetailResponse create : Sequence Number was null after tokenizing message string");
                }
                if (this.dataResponseCurrency == null) {
                    throw new TmsParseException("BuyLineListingDetailResponse create : Currency was null after tokenizing message string");
                }
            }
        } else {
            throw new TmsParseException("BuyLineEnquiryResponse create : You cannot create a response from a null message string");
        }
    }

    public String toString() {
        String result = "E";
        result = result.concat("~");
        result = result.concat(this.dataOpsId.toString());
        result = result.concat("~");
        result = result.concat(this.dataSequneceNumber.toString());
        result = result.concat("~");
        result = result.concat(this.dataResponseCode);
        result = result.concat("~");
        result = result.concat(this.dataResponseMessageType);
        result = result.concat("~");
        result = result.concat(this.dataResponseAmount.toString());
        result = result.concat("~");
        result = result.concat(this.dataResponseCardNumber.toString());
        result = result.concat("~");
        result = result.concat(this.dataSequenceNumber);
        result = result.concat("~");
        result = result.concat(this.dataResponseCurrency.toString());
        result = BuyLineHelper.addBuyLineControlInfo(result);
        return result;
    }

    public Integer getOpsId() {
        return this.dataOpsId;
    }

    public Integer getSequneceNumber() {
        return this.dataSequneceNumber;
    }

    public String getResponseCode() {
        return this.dataResponseCode;
    }

    public String getResponseMessageType() {
        return this.dataResponseMessageType;
    }

    public Integer getResponseAmount() {
        return this.dataResponseAmount;
    }

    public Long getResponseCardNumber() {
        return this.dataResponseCardNumber;
    }

    public String getResponseStatus() {
        return this.dataSequenceNumber;
    }

    public Integer getResponseCurrency() {
        return this.dataResponseCurrency;
    }
}

