/*
 * Decompiled with CFR 0.152.
 */
package nz.co.k.tms.billing.settlement.buyline;

import java.rmi.RemoteException;
import java.util.StringTokenizer;
import nz.co.k.tms.billing.ejb.GeneralManager;
import nz.co.k.tms.exception.TmsGeneralException;
import nz.co.k.tms.utility.EjbHelper;
import nz.co.k.tms.utility.FormatHelper;

public class BuyLineHelper {
    public static String paddExpiryDate(Integer expiryDateToPadd) {
        String result = "";
        String expiryDateToPaddTemp = expiryDateToPadd.toString();
        result = expiryDateToPaddTemp.length() < 4 ? FormatHelper.padString('0', 4 - expiryDateToPaddTemp.length(), expiryDateToPaddTemp) : (expiryDateToPaddTemp.length() > 4 && expiryDateToPaddTemp.length() < 6 ? FormatHelper.padString('0', 6 - expiryDateToPaddTemp.length(), expiryDateToPaddTemp) : expiryDateToPaddTemp);
        return result;
    }

    public static String paddSequenceNumber(Integer sequneceNumberToPadd) {
        return FormatHelper.padString('0', 6 - sequneceNumberToPadd.toString().length(), sequneceNumberToPadd.toString());
    }

    public static String paddSettlementNumber(Integer settlementNumberToPadd) {
        return FormatHelper.padString('0', 6 - settlementNumberToPadd.toString().length(), settlementNumberToPadd.toString());
    }

    public static boolean isResponseCodeSuccess(String responseCode) {
        boolean result = false;
        if (responseCode.equals("OK") || responseCode.equals("00")) {
            result = true;
        }
        return result;
    }

    public static String removeBuyLineControlInfo(String buylineDataMessageToRemoveFrom) {
        String result = null;
        if (buylineDataMessageToRemoveFrom != null && !buylineDataMessageToRemoveFrom.trim().equals("")) {
            int startIndex = "\u0002".length() + 3;
            int endIndex = buylineDataMessageToRemoveFrom.length() - "\u0003".length();
            if (startIndex >= 0 && startIndex < endIndex && endIndex > 0 && endIndex <= buylineDataMessageToRemoveFrom.length()) {
                result = buylineDataMessageToRemoveFrom.substring(startIndex, endIndex);
            }
        }
        return result;
    }

    public static String addBuyLineControlInfo(String buylineDataMessageToAddTo) {
        String result = null;
        if (buylineDataMessageToAddTo != null && !buylineDataMessageToAddTo.trim().equals("")) {
            Integer messageLength = new Integer(buylineDataMessageToAddTo.length() + "\u0002".length() + 3 + "\u0003".length());
            String messageLengthString = FormatHelper.padString('0', 3 - messageLength.toString().length(), messageLength.toString());
            result = "\u0002" + messageLengthString + buylineDataMessageToAddTo + "\u0003";
        }
        return result;
    }

    public static String getMessageTypeIdentifier(String buylineDataMessageToProcess) {
        StringTokenizer tokenizedMessage;
        String result = null;
        if ((buylineDataMessageToProcess = BuyLineHelper.removeBuyLineControlInfo(buylineDataMessageToProcess)) != null && (tokenizedMessage = new StringTokenizer(buylineDataMessageToProcess, "~")) != null && tokenizedMessage.hasMoreTokens()) {
            result = tokenizedMessage.nextToken();
        }
        return result;
    }

    public static Integer getMessageSequenceOrSettlementNumber(String buylineDataMessageToProcess) {
        StringTokenizer tokenizedMessage;
        Integer result = null;
        if ((buylineDataMessageToProcess = BuyLineHelper.removeBuyLineControlInfo(buylineDataMessageToProcess)) != null && (tokenizedMessage = new StringTokenizer(buylineDataMessageToProcess, "~")) != null) {
            int tokenCounter = 1;
            while (tokenizedMessage.hasMoreTokens()) {
                if (tokenCounter == 3) {
                    try {
                        result = new Integer(tokenizedMessage.nextToken());
                    }
                    catch (NumberFormatException nfe) {
                        result = null;
                    }
                    break;
                }
                tokenizedMessage.nextToken();
                ++tokenCounter;
            }
        }
        return result;
    }

    public static Integer getNextSequenceNumber() {
        Integer result = null;
        try {
            GeneralManager generalManager = EjbHelper.getGeneralManager();
            int maxAllowedValue = Integer.parseInt(FormatHelper.padString('9', 6, ""));
            result = generalManager.incrementSystemProfileValue("BuyLineSeqNum", maxAllowedValue);
        }
        catch (RemoteException remoteException) {
        }
        catch (TmsGeneralException tmsGeneralException) {
            // empty catch block
        }
        return result;
    }
}

