/*
 * Decompiled with CFR 0.152.
 */
package nz.co.k.tms.billing.settlement.buyline;

import java.io.IOException;
import nz.co.k.tms.billing.settlement.buyline.BuyLineEnquiryResponse;
import nz.co.k.tms.billing.settlement.buyline.BuyLineHelper;
import nz.co.k.tms.billing.settlement.buyline.BuyLineMessageSender;
import nz.co.k.tms.exception.TmsGeneralException;
import nz.co.k.tms.exception.TmsParseException;

public class BuyLineEnquiryRequest {
    private Integer dataOpsId = null;
    private Integer dataSequneceNumber = null;
    private String dataOpsPassword = null;

    public BuyLineEnquiryRequest(Integer opsId, String opsPassword) throws TmsParseException {
        if (opsId.toString().length() > 8) {
            throw new TmsParseException("BuyLineEnquiryRequest: The OPS ID :" + opsId.toString() + ": is longer than the allowed maximum of :" + 8 + ":");
        }
        this.dataOpsId = opsId;
        this.dataSequneceNumber = BuyLineHelper.getNextSequenceNumber();
        if (opsPassword.length() > 8) {
            throw new TmsParseException("BuyLineEnquiryRequest: The OPS Password :" + opsPassword + ": is longer than the allowed maximum of :" + 8 + ":");
        }
        this.dataOpsPassword = opsPassword;
    }

    public BuyLineEnquiryResponse sendMessage() throws TmsGeneralException {
        return this.sendMessage(true);
    }

    public BuyLineEnquiryResponse sendMessage(boolean obeyStatus) throws TmsGeneralException {
        BuyLineEnquiryResponse result = null;
        try {
            String responseString = BuyLineMessageSender.sendMessage(this.toString(), obeyStatus);
            if (responseString != null) {
                result = new BuyLineEnquiryResponse(responseString);
            }
        }
        catch (IOException ioex) {
            throw new TmsGeneralException(" BuyLineEnquiryRequest sendMessage: IOException ", ioex);
        }
        return result;
    }

    public String toString() {
        String result = "E";
        result = result.concat("~");
        result = result.concat(this.dataOpsId.toString());
        result = result.concat("~");
        result = result.concat(BuyLineHelper.paddSequenceNumber(this.dataSequneceNumber));
        result = result.concat("~");
        result = result.concat(this.dataOpsPassword);
        result = BuyLineHelper.addBuyLineControlInfo(result);
        return result;
    }

    public Integer getOpsId() {
        return this.dataOpsId;
    }

    public Integer getSequneceNumber() {
        return this.dataSequneceNumber;
    }

    public String getOpsPassword() {
        return this.dataOpsPassword;
    }
}

