/*
 * Decompiled with CFR 0.152.
 */
package nz.co.k.tms.billing.settlement.buyline;

import java.util.StringTokenizer;
import nz.co.k.tms.billing.settlement.buyline.BuyLineHelper;
import nz.co.k.tms.exception.TmsParseException;

public class BuyLineCurrencyTotalResponse {
    private Integer dataOpsId = null;
    private Integer dataSequneceNumber = null;
    private String dataResponseCode = null;
    private Integer dataResponseAcquirerCount = null;
    private Integer dataResponseTotalCount = null;
    private Integer dataResponseTotalValue = null;
    private String dataResponseAutomaticFlag = null;
    private Integer dataResponseCurrency = null;
    private static final int MES_TYP_POS = 1;
    private static final int OPS_ID_POS = 2;
    private static final int SEQ_NUM_POS = 3;
    private static final int RES_COD_POS = 4;
    private static final int ACQ_CNT_POS = 5;
    private static final int TOT_CNT_POS = 6;
    private static final int TOT_VAL_POS = 7;
    private static final int AUT_FLG_POS = 8;
    private static final int CUR_TXT_POS = 9;

    public BuyLineCurrencyTotalResponse(Integer opsId, Integer sequneceNumber, String responseCode, Integer responseAcquirerCount, Integer responseTotalCount, Integer responseTotalValue, Integer responseCurrency) throws TmsParseException {
        if (opsId.toString().length() > 8) {
            throw new TmsParseException("BuyLineCurrencyTotalResponse: The OPS ID :" + opsId.toString() + ": is longer than the allowed maximum of :" + 8 + ":");
        }
        this.dataOpsId = opsId;
        if (sequneceNumber.toString().length() > 6) {
            throw new TmsParseException("BuyLineCurrencyTotalResponse: The Sequnece Number :" + sequneceNumber.toString() + ": is longer than the allowed maximum of :" + 6 + ":");
        }
        this.dataSequneceNumber = sequneceNumber;
        if (responseCode.length() > 2) {
            throw new TmsParseException("BuyLineCurrencyTotalResponse: The Response Code :" + responseCode + ": is longer than the allowed maximum of :" + 2 + ":");
        }
        this.dataResponseCode = responseCode;
        if (responseAcquirerCount.toString().length() > 2) {
            throw new TmsParseException("BuyLineCurrencyTotalResponse: The Acquirer Count :" + responseAcquirerCount.toString() + ": is longer than the allowed maximum of :" + 2 + ":");
        }
        this.dataResponseAcquirerCount = responseAcquirerCount;
        if (responseTotalCount.toString().length() > 6) {
            throw new TmsParseException("BuyLineCurrencyTotalResponse: The Total Count :" + responseTotalCount.toString() + ": is longer than the allowed maximum of :" + 6 + ":");
        }
        this.dataResponseTotalCount = responseTotalCount;
        if (responseTotalValue.toString().length() > 10) {
            throw new TmsParseException("BuyLineCurrencyTotalResponse: The Total Value :" + responseTotalValue.toString() + ": is longer than the allowed maximum of :" + 10 + ":");
        }
        this.dataResponseTotalValue = responseTotalValue;
        this.dataResponseAutomaticFlag = "Y";
        if (responseCurrency.toString().length() > 10) {
            throw new TmsParseException("BuyLineCurrencyTotalResponse: The Currency :" + responseCurrency.toString() + ": is longer than the allowed maximum of :" + 10 + ":");
        }
        this.dataResponseCurrency = responseCurrency;
    }

    public BuyLineCurrencyTotalResponse(String messageString) throws TmsParseException {
        if (messageString != null) {
            StringTokenizer tokenizedMessage = new StringTokenizer(messageString = BuyLineHelper.removeBuyLineControlInfo(messageString), "~");
            if (tokenizedMessage != null) {
                int tokenCount = 1;
                while (tokenizedMessage.hasMoreTokens()) {
                    if (tokenCount == 1) {
                        if (!tokenizedMessage.nextToken().equals("X") && !tokenizedMessage.nextToken().equals("T")) {
                            throw new TmsParseException("BuyLineCurrencyTotalResponse create : the message string passed in is not a Curreny Total or Batch Total response ");
                        }
                    } else {
                        if (tokenCount == 2) {
                            try {
                                this.dataOpsId = new Integer(tokenizedMessage.nextToken());
                            }
                            catch (NumberFormatException nfex) {
                                throw new TmsParseException("BuyLineCurrencyTotalResponse create : OpsId must be an Integer : " + nfex.getMessage());
                            }
                        }
                        if (tokenCount == 3) {
                            try {
                                this.dataSequneceNumber = new Integer(tokenizedMessage.nextToken());
                            }
                            catch (NumberFormatException nfex) {
                                throw new TmsParseException("BuyLineCurrencyTotalResponse create : SequneceNumber must be an Integer : " + nfex.getMessage());
                            }
                        }
                        if (tokenCount == 4) {
                            this.dataResponseCode = tokenizedMessage.nextToken();
                        } else {
                            if (tokenCount == 5) {
                                try {
                                    this.dataResponseAcquirerCount = new Integer(tokenizedMessage.nextToken());
                                }
                                catch (NumberFormatException nfex) {
                                    throw new TmsParseException("BuyLineCurrencyTotalResponse create : Acquirer Count must be an Integer : " + nfex.getMessage());
                                }
                            }
                            if (tokenCount == 6) {
                                try {
                                    this.dataResponseTotalCount = new Integer(tokenizedMessage.nextToken());
                                }
                                catch (NumberFormatException nfex) {
                                    throw new TmsParseException("BuyLineCurrencyTotalResponse create : Total Count must be an Integer : " + nfex.getMessage());
                                }
                            }
                            if (tokenCount == 7) {
                                try {
                                    this.dataResponseTotalValue = new Integer(tokenizedMessage.nextToken());
                                }
                                catch (NumberFormatException nfex) {
                                    throw new TmsParseException("BuyLineCurrencyTotalResponse create : Total Value must be an Integer : " + nfex.getMessage());
                                }
                            }
                            if (tokenCount == 9) {
                                try {
                                    this.dataResponseCurrency = new Integer(tokenizedMessage.nextToken());
                                }
                                catch (NumberFormatException nfex) {
                                    throw new TmsParseException("BuyLineCurrencyTotalResponse create : Currency must be an Integer : " + nfex.getMessage());
                                }
                            }
                        }
                    }
                    ++tokenCount;
                }
                if (this.dataOpsId == null) {
                    throw new TmsParseException("BuyLineCurrencyTotalResponse create : OpsId was null after tokenizing message string");
                }
                if (this.dataSequneceNumber == null) {
                    throw new TmsParseException("BuyLineCurrencyTotalResponse create : SequneceNumber was null after tokenizing message string");
                }
                if (this.dataResponseCode == null) {
                    throw new TmsParseException("BuyLineCurrencyTotalResponse create : ResponseCode was null after tokenizing message string");
                }
                if (this.dataResponseAcquirerCount == null) {
                    throw new TmsParseException("BuyLineCurrencyTotalResponse create : Acquirer Count was null after tokenizing message string");
                }
                if (this.dataResponseTotalCount == null) {
                    throw new TmsParseException("BuyLineCurrencyTotalResponse create : Total Count was null after tokenizing message string");
                }
                if (this.dataResponseTotalValue == null) {
                    throw new TmsParseException("BuyLineCurrencyTotalResponse create : Total Value null after tokenizing message string");
                }
                if (this.dataResponseCurrency == null) {
                    throw new TmsParseException("BuyLineCurrencyTotalResponse create : Currency was null after tokenizing message string");
                }
            }
        } else {
            throw new TmsParseException("BuyLineEnquiryResponse create : You cannot create a response from a null message string");
        }
    }

    public String toString() {
        String result = "X";
        result = result.concat("~");
        result = result.concat(this.dataOpsId.toString());
        result = result.concat("~");
        result = result.concat(this.dataSequneceNumber.toString());
        result = result.concat("~");
        result = result.concat(this.dataResponseCode);
        result = result.concat("~");
        result = result.concat(this.dataResponseAcquirerCount.toString());
        result = result.concat("~");
        result = result.concat(this.dataResponseTotalCount.toString());
        result = result.concat("~");
        result = result.concat(this.dataResponseTotalValue.toString());
        result = result.concat("~");
        result = result.concat(this.dataResponseAutomaticFlag);
        result = result.concat("~");
        result = result.concat(this.dataResponseCurrency.toString());
        result = BuyLineHelper.addBuyLineControlInfo(result);
        return result;
    }

    public Integer getOpsId() {
        return this.dataOpsId;
    }

    public Integer getSequneceNumber() {
        return this.dataSequneceNumber;
    }

    public String getResponseCode() {
        return this.dataResponseCode;
    }

    public Integer getResponseAcquirerCount() {
        return this.dataResponseAcquirerCount;
    }

    public Integer getResponseTotalCount() {
        return this.dataResponseTotalCount;
    }

    public Integer getResponseTotalValue() {
        return this.dataResponseTotalValue;
    }

    public Integer getResponseCurrency() {
        return this.dataResponseCurrency;
    }
}

