/*
 * Decompiled with CFR 0.152.
 */
package nz.co.k.tms.billing.settlement.buyline;

import java.io.IOException;
import nz.co.k.tms.billing.settlement.buyline.BuyLineCompletionResponse;
import nz.co.k.tms.billing.settlement.buyline.BuyLineHelper;
import nz.co.k.tms.billing.settlement.buyline.BuyLineMessageSender;
import nz.co.k.tms.exception.TmsGeneralException;
import nz.co.k.tms.exception.TmsParseException;

public class BuyLineCompletionRequest {
    private Integer dataOpsId = null;
    private Integer dataSequneceNumber = null;
    private Integer dataAmount = null;
    private Long dataCardNumber = null;
    private Integer dataCurrencyCode = null;

    public BuyLineCompletionRequest(Integer opsId, Integer sequneceNumber, Integer amount, Long cardNumber, Integer currencyCode) throws TmsParseException {
        if (opsId.toString().length() > 8) {
            throw new TmsParseException("BuyLineCompletionRequest: The OPS ID :" + opsId.toString() + ": is longer than the allowed maximum of :" + 8 + ":");
        }
        this.dataOpsId = opsId;
        if (sequneceNumber.toString().length() > 6) {
            throw new TmsParseException("BuyLineCompletionRequest: The Sequnece Number :" + sequneceNumber.toString() + ": is longer than the allowed maximum of :" + 6 + ":");
        }
        this.dataSequneceNumber = sequneceNumber;
        if (amount.toString().length() > 8) {
            throw new TmsParseException("BuyLineCompletionRequest: The Amount :" + amount.toString() + ": is longer than the allowed maximum of :" + 8 + ":");
        }
        this.dataAmount = amount;
        if (cardNumber.toString().length() > 19) {
            throw new TmsParseException("BuyLineCompletionRequest: The Card Number :" + cardNumber.toString() + ": is longer than the allowed maximum of :" + 19 + ":");
        }
        this.dataCardNumber = cardNumber;
        if (currencyCode.toString().length() > 3) {
            throw new TmsParseException("BuyLineCompletionRequest: The Currency Code :" + currencyCode.toString() + ": is longer than the allowed maximum of :" + 3 + ":");
        }
        this.dataCurrencyCode = currencyCode;
    }

    public BuyLineCompletionResponse sendMessage() throws TmsGeneralException {
        return this.sendMessage(true);
    }

    public BuyLineCompletionResponse sendMessage(boolean obeyStatus) throws TmsGeneralException {
        BuyLineCompletionResponse result = null;
        try {
            String responseString = BuyLineMessageSender.sendMessage(this.toString(), obeyStatus);
            if (responseString != null) {
                result = new BuyLineCompletionResponse(responseString);
            }
        }
        catch (IOException ioex) {
            throw new TmsGeneralException(" BuyLineCompletionRequest sendMessage: IOException ", ioex);
        }
        return result;
    }

    public String toString() {
        String result = "C";
        result = result.concat("~");
        result = result.concat(this.dataOpsId.toString());
        result = result.concat("~");
        result = result.concat(BuyLineHelper.paddSequenceNumber(this.dataSequneceNumber));
        result = result.concat("~");
        result = result.concat("~");
        result = result.concat(this.dataAmount.toString());
        result = result.concat("~");
        result = result.concat(this.dataCardNumber.toString());
        result = result.concat("~");
        result = result.concat("~");
        result = result.concat(this.dataCurrencyCode.toString());
        result = BuyLineHelper.addBuyLineControlInfo(result);
        return result;
    }

    public Integer getOpsId() {
        return this.dataOpsId;
    }

    public Integer getSequneceNumber() {
        return this.dataSequneceNumber;
    }

    public Integer getAmount() {
        return this.dataAmount;
    }

    public Long getCardNumber() {
        return this.dataCardNumber;
    }

    public Integer getCurrencyCode() {
        return this.dataCurrencyCode;
    }
}

