/*
 * Decompiled with CFR 0.152.
 */
package nz.co.k.tms.billing.settlement.buyline;

import java.io.IOException;
import nz.co.k.tms.billing.settlement.buyline.BuyLineBatchTotalsResponse;
import nz.co.k.tms.billing.settlement.buyline.BuyLineHelper;
import nz.co.k.tms.billing.settlement.buyline.BuyLineMessageSender;
import nz.co.k.tms.exception.TmsGeneralException;
import nz.co.k.tms.exception.TmsParseException;

public class BuyLineBatchTotalsRequest {
    private Integer dataOpsId = null;
    private Integer dataSettlementNumber = null;
    private String dataOpsPassword = null;

    public BuyLineBatchTotalsRequest(Integer opsId, Integer settlementNumber, String opsPassword) throws TmsParseException {
        if (opsId.toString().length() > 8) {
            throw new TmsParseException("BuyLineBatchTotalsRequest: The OPS ID :" + opsId.toString() + ": is longer than the allowed maximum of :" + 8 + ":");
        }
        this.dataOpsId = opsId;
        if (settlementNumber.toString().length() > 6) {
            throw new TmsParseException("BuyLineBatchTotalsRequest: The Settlement Number :" + settlementNumber.toString() + ": is longer than the allowed maximum of :" + 6 + ":");
        }
        this.dataSettlementNumber = settlementNumber;
        if (this.dataOpsPassword.length() > 8) {
            throw new TmsParseException("BuyLineBatchTotalsRequest: The OPS Password :" + this.dataOpsPassword + ": is longer than the allowed maximum of :" + 8 + ":");
        }
        this.dataOpsPassword = opsPassword;
    }

    public BuyLineBatchTotalsResponse sendMessage() throws TmsGeneralException {
        return this.sendMessage(true);
    }

    public BuyLineBatchTotalsResponse sendMessage(boolean obeyStatus) throws TmsGeneralException {
        BuyLineBatchTotalsResponse result = null;
        try {
            String responseString = BuyLineMessageSender.sendMessage(this.toString(), obeyStatus);
            if (responseString != null) {
                result = new BuyLineBatchTotalsResponse(responseString);
            }
        }
        catch (IOException ioex) {
            throw new TmsGeneralException(" BuyLineBatchTotalsRequest sendMessage: IOException ", ioex);
        }
        return result;
    }

    public String toString() {
        String result = "T";
        result = result.concat("~");
        result = result.concat(this.dataOpsId.toString());
        result = result.concat("~");
        result = result.concat(BuyLineHelper.paddSettlementNumber(this.dataSettlementNumber));
        result = result.concat("~");
        result = result.concat(this.dataOpsPassword);
        result = BuyLineHelper.addBuyLineControlInfo(result);
        return result;
    }

    public Integer getOpsId() {
        return this.dataOpsId;
    }

    public Integer getSettlementNumber() {
        return this.dataSettlementNumber;
    }

    public String getOpsPassword() {
        return this.dataOpsPassword;
    }
}

