/*
 * Decompiled with CFR 0.152.
 */
package nz.co.k.tms.billing.settlement.buyline;

import java.util.ArrayList;
import java.util.StringTokenizer;
import nz.co.k.tms.billing.settlement.buyline.BuyLineAcquirerTotalResponse;
import nz.co.k.tms.billing.settlement.buyline.BuyLineCurrencyTotalResponse;
import nz.co.k.tms.billing.settlement.buyline.BuyLineHelper;
import nz.co.k.tms.billing.settlement.buyline.BuyLineListingDetailResponse;
import nz.co.k.tms.exception.TmsParseException;

public class BuyLineBatchListingResponse {
    private ArrayList dataAcquirerTotals = new ArrayList();
    private ArrayList dataCurrencyTotals = new ArrayList();
    private ArrayList dataDetails = new ArrayList();

    public BuyLineBatchListingResponse(String messageString) throws TmsParseException {
        if (messageString != null) {
            StringTokenizer tokenizedMessage = new StringTokenizer(messageString, "\u0003");
            if (tokenizedMessage != null) {
                while (tokenizedMessage.hasMoreTokens()) {
                    String subMessageString = BuyLineHelper.removeBuyLineControlInfo(tokenizedMessage.nextToken());
                    if (subMessageString == null) continue;
                    StringTokenizer subTokenizedMessage = new StringTokenizer(subMessageString, "~");
                    while (subTokenizedMessage.hasMoreTokens()) {
                        String subMessageType = subTokenizedMessage.nextToken();
                        if (subMessageType.equals("Q")) {
                            BuyLineAcquirerTotalResponse currentBuyLineAcquirerTotalResponse = new BuyLineAcquirerTotalResponse(subMessageString);
                            this.dataAcquirerTotals.add(currentBuyLineAcquirerTotalResponse);
                            continue;
                        }
                        if (subMessageType.equals("D")) {
                            BuyLineListingDetailResponse currentBuyLineListingDetailResponse = new BuyLineListingDetailResponse(subMessageString);
                            this.dataDetails.add(currentBuyLineListingDetailResponse);
                            continue;
                        }
                        if (!subMessageType.equals("X") && !subMessageType.equals("L")) continue;
                        BuyLineCurrencyTotalResponse currentBuyLineCurrencyTotalResponse = new BuyLineCurrencyTotalResponse(subMessageString);
                        this.dataCurrencyTotals.add(currentBuyLineCurrencyTotalResponse);
                    }
                }
            }
        } else {
            throw new TmsParseException("BuyLineBatchListingResponse create : You cannot create a response from a null message string");
        }
    }

    public int getAcquirerTotalsCount() {
        return this.dataAcquirerTotals.size();
    }

    public int getCurrencyTotalsCount() {
        return this.dataCurrencyTotals.size();
    }

    public int getDetailsCount() {
        return this.dataDetails.size();
    }

    public ArrayList getAcquirerTotals() {
        if (this.dataAcquirerTotals.isEmpty()) {
            return null;
        }
        return this.dataAcquirerTotals;
    }

    public ArrayList getCurrencyTotals() {
        if (this.dataCurrencyTotals.isEmpty()) {
            return null;
        }
        return this.dataCurrencyTotals;
    }

    public ArrayList getDetails() {
        if (this.dataDetails.isEmpty()) {
            return null;
        }
        return this.dataDetails;
    }
}

