/*
 * Decompiled with CFR 0.152.
 */
package nz.co.k.tms.billing.settlement.buyline;

import java.io.IOException;
import nz.co.k.tms.billing.settlement.buyline.BuyLineBatchListingResponse;
import nz.co.k.tms.billing.settlement.buyline.BuyLineHelper;
import nz.co.k.tms.billing.settlement.buyline.BuyLineMessageSender;
import nz.co.k.tms.exception.TmsGeneralException;
import nz.co.k.tms.exception.TmsParseException;

public class BuyLineBatchListingRequest {
    private Integer dataOpsId = null;
    private Integer dataSettlementNumber = null;
    private String dataOpsPassword = null;

    public BuyLineBatchListingRequest(Integer opsId, Integer settlementNumber, String opsPassword) throws TmsParseException {
        if (opsId.toString().length() > 8) {
            throw new TmsParseException("BuyLineBatchListingRequest: The OPS ID :" + opsId.toString() + ": is longer than the allowed maximum of :" + 8 + ":");
        }
        this.dataOpsId = opsId;
        if (settlementNumber.toString().length() > 6) {
            throw new TmsParseException("BuyLineBatchListingRequest: The Settlement Number :" + settlementNumber.toString() + ": is longer than the allowed maximum of :" + 6 + ":");
        }
        this.dataSettlementNumber = settlementNumber;
        if (this.dataOpsPassword.length() > 8) {
            throw new TmsParseException("BuyLineBatchListingRequest: The OPS Password :" + this.dataOpsPassword + ": is longer than the allowed maximum of :" + 8 + ":");
        }
        this.dataOpsPassword = opsPassword;
    }

    public BuyLineBatchListingResponse sendMessage() throws TmsGeneralException {
        return this.sendMessage(true);
    }

    public BuyLineBatchListingResponse sendMessage(boolean obeyStatus) throws TmsGeneralException {
        BuyLineBatchListingResponse result = null;
        try {
            String responseString = BuyLineMessageSender.sendMessage(this.toString(), obeyStatus);
            if (responseString != null) {
                result = new BuyLineBatchListingResponse(responseString);
            }
        }
        catch (IOException ioex) {
            throw new TmsGeneralException(" BuyLineBatchListingRequest sendMessage: IOException ", ioex);
        }
        return result;
    }

    public String toString() {
        String result = "T";
        result = result.concat("~");
        result = result.concat(this.dataOpsId.toString());
        result = result.concat("~");
        result = result.concat(BuyLineHelper.paddSettlementNumber(this.dataSettlementNumber));
        result = result.concat("~");
        result = result.concat(this.dataOpsPassword);
        result = BuyLineHelper.addBuyLineControlInfo(result);
        return result;
    }

    public Integer getOpsId() {
        return this.dataOpsId;
    }

    public Integer getSettlementNumber() {
        return this.dataSettlementNumber;
    }

    public String getOpsPassword() {
        return this.dataOpsPassword;
    }
}

