/*
 * Decompiled with CFR 0.152.
 */
package nz.co.k.tms.billing.settlement.buyline;

import java.util.StringTokenizer;
import nz.co.k.tms.billing.settlement.buyline.BuyLineHelper;
import nz.co.k.tms.exception.TmsParseException;

public class BuyLineAcquirerTotalResponse {
    private Integer dataOpsId = null;
    private Integer dataSequneceNumber = null;
    private String dataResponseCode = null;
    private String dataResponseAcquirer = null;
    private Integer dataResponsePurchaseCount = null;
    private Integer dataResponsePurchaseValue = null;
    private Integer dataResponseRefundCount = null;
    private Integer dataResponseRefundValue = null;
    private Integer dataResponseCurrency = null;
    private static final int MES_TYP_POS = 1;
    private static final int OPS_ID_POS = 2;
    private static final int SEQ_NUM_POS = 3;
    private static final int RES_COD_POS = 4;
    private static final int ACQ_TXT_POS = 5;
    private static final int PUR_CNT_POS = 6;
    private static final int PUR_VAL_POS = 7;
    private static final int REF_CNT_POS = 8;
    private static final int REF_VAL_POS = 9;
    private static final int CUR_TXT_POS = 10;

    public BuyLineAcquirerTotalResponse(Integer opsId, Integer sequneceNumber, String responseCode, String responseAcquirer, Integer responsePurchaseCount, Integer responsePurchaseValue, Integer responseRefundCount, Integer responseRefundValue, Integer responseCurrency) throws TmsParseException {
        if (opsId.toString().length() > 8) {
            throw new TmsParseException("BuyLineAcquirerTotalResponse: The OPS ID :" + opsId.toString() + ": is longer than the allowed maximum of :" + 8 + ":");
        }
        this.dataOpsId = opsId;
        if (sequneceNumber.toString().length() > 6) {
            throw new TmsParseException("BuyLineAcquirerTotalResponse: The Sequnece Number :" + sequneceNumber.toString() + ": is longer than the allowed maximum of :" + 6 + ":");
        }
        this.dataSequneceNumber = sequneceNumber;
        if (responseCode.length() > 2) {
            throw new TmsParseException("BuyLineAcquirerTotalResponse: The Response Code :" + responseCode + ": is longer than the allowed maximum of :" + 2 + ":");
        }
        this.dataResponseCode = responseCode;
        if (responseAcquirer.length() > 10) {
            throw new TmsParseException("BuyLineAcquirerTotalResponse: The Acquirer :" + responseAcquirer + ": is longer than the allowed maximum of :" + 10 + ":");
        }
        this.dataResponseAcquirer = responseAcquirer;
        if (responsePurchaseCount.toString().length() > 6) {
            throw new TmsParseException("BuyLineAcquirerTotalResponse: The Purchase Count :" + responsePurchaseCount.toString() + ": is longer than the allowed maximum of :" + 6 + ":");
        }
        this.dataResponsePurchaseCount = responsePurchaseCount;
        if (responsePurchaseValue.toString().length() > 10) {
            throw new TmsParseException("BuyLineAcquirerTotalResponse: The Purchase Value :" + responsePurchaseValue.toString() + ": is longer than the allowed maximum of :" + 10 + ":");
        }
        this.dataResponsePurchaseValue = responsePurchaseValue;
        if (responseRefundCount.toString().length() > 6) {
            throw new TmsParseException("BuyLineAcquirerTotalResponse: The Refund Count :" + responseRefundCount.toString() + ": is longer than the allowed maximum of :" + 6 + ":");
        }
        this.dataResponseRefundCount = responseRefundCount;
        if (responseRefundValue.toString().length() > 10) {
            throw new TmsParseException("BuyLineAcquirerTotalResponse: The Refund Value :" + responseRefundValue.toString() + ": is longer than the allowed maximum of :" + 10 + ":");
        }
        this.dataResponseRefundValue = responseRefundValue;
        if (responseCurrency.toString().length() > 10) {
            throw new TmsParseException("BuyLineAcquirerTotalResponse: The Currency :" + responseCurrency.toString() + ": is longer than the allowed maximum of :" + 10 + ":");
        }
        this.dataResponseCurrency = responseCurrency;
    }

    public BuyLineAcquirerTotalResponse(String messageString) throws TmsParseException {
        if (messageString != null) {
            StringTokenizer tokenizedMessage = new StringTokenizer(messageString = BuyLineHelper.removeBuyLineControlInfo(messageString), "~");
            if (tokenizedMessage != null) {
                int tokenCount = 1;
                while (tokenizedMessage.hasMoreTokens()) {
                    if (tokenCount == 1) {
                        if (!tokenizedMessage.nextToken().equals("Q")) {
                            throw new TmsParseException("BuyLineAcquirerTotalResponse create : the message string passed in is not an Acquirer Total response ");
                        }
                    } else {
                        if (tokenCount == 2) {
                            try {
                                this.dataOpsId = new Integer(tokenizedMessage.nextToken());
                            }
                            catch (NumberFormatException nfex) {
                                throw new TmsParseException("BuyLineAcquirerTotalResponse create : OpsId must be an Integer : " + nfex.getMessage());
                            }
                        }
                        if (tokenCount == 3) {
                            try {
                                this.dataSequneceNumber = new Integer(tokenizedMessage.nextToken());
                            }
                            catch (NumberFormatException nfex) {
                                throw new TmsParseException("BuyLineAcquirerTotalResponse create : SequneceNumber must be an Integer : " + nfex.getMessage());
                            }
                        }
                        if (tokenCount == 4) {
                            this.dataResponseCode = tokenizedMessage.nextToken();
                        } else if (tokenCount == 5) {
                            this.dataResponseAcquirer = tokenizedMessage.nextToken();
                        } else {
                            if (tokenCount == 6) {
                                try {
                                    this.dataResponsePurchaseCount = new Integer(tokenizedMessage.nextToken());
                                }
                                catch (NumberFormatException nfex) {
                                    throw new TmsParseException("BuyLineAcquirerTotalResponse create : Purchase Count must be an Integer : " + nfex.getMessage());
                                }
                            }
                            if (tokenCount == 7) {
                                try {
                                    this.dataResponsePurchaseValue = new Integer(tokenizedMessage.nextToken());
                                }
                                catch (NumberFormatException nfex) {
                                    throw new TmsParseException("BuyLineAcquirerTotalResponse create : Purchase Value must be an Integer : " + nfex.getMessage());
                                }
                            }
                            if (tokenCount == 8) {
                                try {
                                    this.dataResponseRefundCount = new Integer(tokenizedMessage.nextToken());
                                }
                                catch (NumberFormatException nfex) {
                                    throw new TmsParseException("BuyLineAcquirerTotalResponse create : Refund Count must be an Integer : " + nfex.getMessage());
                                }
                            }
                            if (tokenCount == 9) {
                                try {
                                    this.dataResponseRefundValue = new Integer(tokenizedMessage.nextToken());
                                }
                                catch (NumberFormatException nfex) {
                                    throw new TmsParseException("BuyLineAcquirerTotalResponse create : Refund Value must be an Integer : " + nfex.getMessage());
                                }
                            }
                            if (tokenCount == 10) {
                                try {
                                    this.dataResponseCurrency = new Integer(tokenizedMessage.nextToken());
                                }
                                catch (NumberFormatException nfex) {
                                    throw new TmsParseException("BuyLineAcquirerTotalResponse create : Currency Code must be an Integer : " + nfex.getMessage());
                                }
                            }
                        }
                    }
                    ++tokenCount;
                }
                if (this.dataOpsId == null) {
                    throw new TmsParseException("BuyLineAcquirerTotalResponse create : OpsId was null after tokenizing message string");
                }
                if (this.dataSequneceNumber == null) {
                    throw new TmsParseException("BuyLineAcquirerTotalResponse create : SequneceNumber was null after tokenizing message string");
                }
                if (this.dataResponseCode == null) {
                    throw new TmsParseException("BuyLineAcquirerTotalResponse create : ResponseCode was null after tokenizing message string");
                }
                if (this.dataResponseAcquirer == null) {
                    throw new TmsParseException("BuyLineAcquirerTotalResponse create : Acquirer was null after tokenizing message string");
                }
                if (this.dataResponsePurchaseCount == null) {
                    throw new TmsParseException("BuyLineAcquirerTotalResponse create : Purchase Count was null after tokenizing message string");
                }
                if (this.dataResponsePurchaseValue == null) {
                    throw new TmsParseException("BuyLineAcquirerTotalResponse create : Purchase Value was null after tokenizing message string");
                }
                if (this.dataResponseRefundCount == null) {
                    throw new TmsParseException("BuyLineAcquirerTotalResponse create : Refund Count was null after tokenizing message string");
                }
                if (this.dataResponseRefundValue == null) {
                    throw new TmsParseException("BuyLineAcquirerTotalResponse create : Refund Value was null after tokenizing message string");
                }
                if (this.dataResponseCurrency == null) {
                    throw new TmsParseException("BuyLineAcquirerTotalResponse create : Currency was null after tokenizing message string");
                }
            }
        } else {
            throw new TmsParseException("BuyLineAcquirerTotalResponse create : You cannot create a response from a null message string");
        }
    }

    public String toString() {
        String result = "Q";
        result = result.concat("~");
        result = result.concat(this.dataOpsId.toString());
        result = result.concat("~");
        result = result.concat(this.dataSequneceNumber.toString());
        result = result.concat("~");
        result = result.concat(this.dataResponseCode);
        result = result.concat("~");
        result = result.concat(this.dataResponseAcquirer);
        result = result.concat("~");
        result = result.concat(this.dataResponsePurchaseCount.toString());
        result = result.concat("~");
        result = result.concat(this.dataResponsePurchaseValue.toString());
        result = result.concat("~");
        result = result.concat(this.dataResponseRefundCount.toString());
        result = result.concat("~");
        result = result.concat(this.dataResponseRefundValue.toString());
        result = result.concat("~");
        result = result.concat(this.dataResponseCurrency.toString());
        result = BuyLineHelper.addBuyLineControlInfo(result);
        return result;
    }

    public Integer getOpsId() {
        return this.dataOpsId;
    }

    public Integer getSequneceNumber() {
        return this.dataSequneceNumber;
    }

    public String getResponseCode() {
        return this.dataResponseCode;
    }

    public String getResponseAcquirer() {
        return this.dataResponseAcquirer;
    }

    public Integer getResponsePurchaseCount() {
        return this.dataResponsePurchaseCount;
    }

    public Integer getResponsePurchaseValue() {
        return this.dataResponsePurchaseValue;
    }

    public Integer getResponseRefundCount() {
        return this.dataResponseRefundCount;
    }

    public Integer getResponseRefundValue() {
        return this.dataResponseRefundValue;
    }

    public Integer getResponseCurrency() {
        return this.dataResponseCurrency;
    }
}

