/*
 * Decompiled with CFR 0.152.
 */
package nz.co.k.tms.billing.report;

import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.Iterator;
import javax.ejb.FinderException;
import nz.co.k.tms.billing.ejb.BrandData;
import nz.co.k.tms.billing.ejb.ItemData;
import nz.co.k.tms.billing.ejb.NCBAddressData;
import nz.co.k.tms.billing.ejb.NCBData;
import nz.co.k.tms.billing.ejb.NCBRoleData;
import nz.co.k.tms.billing.ejb.OrderRequestData;
import nz.co.k.tms.billing.ejb.OrderRequestItemData;
import nz.co.k.tms.billing.ejb.ServiceData;
import nz.co.k.tms.billing.ejb.SettlementBrandData;
import nz.co.k.tms.billing.ejb.SettlementData;
import nz.co.k.tms.exception.TmsBillingException;
import nz.co.k.tms.exception.TmsGeneralException;
import nz.co.k.tms.exception.TmsNoResultException;
import nz.co.k.tms.utility.EjbHelper;
import nz.co.k.tms.utility.FormatHelper;
import nz.co.k.tms.utility.LogHelper;
import nz.co.k.tms.utility.TmsConst;
import nz.co.k.tms.utility.XmlHelper;
import nz.co.k.tms.xml.report.settlement.Address;
import nz.co.k.tms.xml.report.settlement.ChildNcb;
import nz.co.k.tms.xml.report.settlement.Ncb;
import nz.co.k.tms.xml.report.settlement.Order;
import nz.co.k.tms.xml.report.settlement.OrderItem;
import nz.co.k.tms.xml.report.settlement.Role;
import nz.co.k.tms.xml.report.settlement.Settlement;
import nz.co.k.tms.xml.report.settlement.TmsSettlementReport;
import nz.co.k.tms.xml.types.NcbAddressTypeType;
import nz.co.k.tms.xml.types.NcbTypeType;
import org.apache.log4j.Level;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.ValidationException;

public class SettlementReport {
    private Integer dataFilterNcbId;
    private String dataFilterName;
    private String dataFilterDeliveryTrackingRefRef;
    private Date dataFilterInvoiceDate;
    private Date dataFilterStartDate;
    private Date dataFilterEndDate;
    private boolean dataFilterIncludeChildrenNcb;

    public SettlementReport(Integer reportNcbId, String ncbName, String deliveryTrackingRef, Date invoiceDate, Date startDateTime, Date endDateTime, boolean includeChildrenNcb) {
        this.dataFilterNcbId = reportNcbId;
        this.dataFilterName = ncbName;
        this.dataFilterDeliveryTrackingRefRef = deliveryTrackingRef;
        this.dataFilterInvoiceDate = invoiceDate;
        this.dataFilterStartDate = startDateTime;
        this.dataFilterEndDate = endDateTime;
        this.dataFilterIncludeChildrenNcb = includeChildrenNcb;
    }

    public String getReportXmlString() throws TmsBillingException, TmsNoResultException {
        TmsSettlementReport tmsSettlementReport = new TmsSettlementReport();
        if (this.dataFilterNcbId == null) {
            ArrayList ncbsFound = null;
            try {
                ncbsFound = EjbHelper.getNCBManager().findAllNcb(true);
            }
            catch (FinderException fndex) {
                throw new TmsNoResultException("Could not find any NCBs.");
            }
            catch (RemoteException rmiex) {
                throw new TmsBillingException("SettlementReport:findAllNcb: RemoteException. Finding all NCB. Details :" + rmiex.toString());
            }
            catch (TmsGeneralException tmsgenex) {
                throw new TmsBillingException("SettlementReport:findAllNcb: TmsGeneralException. Finding all NCB.  Details :" + tmsgenex.toString());
            }
            if (ncbsFound != null) {
                Iterator ncbsFoundIterator = ncbsFound.iterator();
                while (ncbsFoundIterator.hasNext()) {
                    Ncb ncb;
                    NCBData currentNcbData = (NCBData)ncbsFoundIterator.next();
                    if (this.dataFilterName != null) {
                        String ncbFullName = "";
                        if (currentNcbData.getNamePrefix() != null) {
                            ncbFullName = String.valueOf(ncbFullName) + currentNcbData.getNamePrefix();
                        }
                        if (currentNcbData.getName() != null) {
                            ncbFullName = String.valueOf(ncbFullName) + " " + currentNcbData.getName();
                        }
                        if (currentNcbData.getNameLast() != null) {
                            ncbFullName = String.valueOf(ncbFullName) + " " + currentNcbData.getNameLast();
                        }
                        if (currentNcbData.getNameSuffix() != null) {
                            ncbFullName = String.valueOf(ncbFullName) + " " + currentNcbData.getNameSuffix();
                        }
                        if ((ncbFullName = ncbFullName.trim()).equals("") || ncbFullName.toLowerCase().indexOf(this.dataFilterName.toLowerCase()) == -1) continue;
                    }
                    if ((ncb = this.createNcb(currentNcbData)) == null) continue;
                    tmsSettlementReport.addNcb(ncb);
                }
            }
        } else {
            Ncb ncb = this.findNcb(this.dataFilterNcbId);
            if (ncb == null) {
                throw new TmsNoResultException("Could not find a NCB with the ID :" + this.dataFilterNcbId);
            }
            tmsSettlementReport.addNcb(ncb);
        }
        if (tmsSettlementReport.getNcbCount() <= 0) {
            throw new TmsNoResultException("Could not find any settlement report details.");
        }
        try {
            return XmlHelper.marshalTmsSettlementReportMessage(tmsSettlementReport);
        }
        catch (MarshalException me) {
            LogHelper.getBillingLogger().log(Level.ERROR, (Object)("SettlementReport:getReportXmlString: MarshalException. Details :" + me.toString()));
            throw new TmsBillingException("SettlementReport:getReportXmlString: MarshalException.Details :" + me.toString());
        }
        catch (ValidationException ve) {
            LogHelper.getBillingLogger().log(Level.ERROR, (Object)("SettlementReport:getReportXmlString: ValidationException. Details :" + ve.toString()));
            throw new TmsBillingException("SettlementReport:getReportXmlString: ValidationException. Details :" + ve.toString());
        }
    }

    private Ncb findNcb(Integer filterNcbId) throws TmsBillingException, TmsNoResultException {
        NCBData currentNcbData = null;
        try {
            if (filterNcbId != null) {
                currentNcbData = EjbHelper.getNCBManager().findNcbById(filterNcbId.intValue(), true);
            }
        }
        catch (FinderException fndex) {
            throw new TmsNoResultException("Could not find a NCB with the ID :" + this.dataFilterNcbId);
        }
        catch (RemoteException rmiex) {
            throw new TmsBillingException("SettlementReport:findNcb: RemoteException. Finding NCB NCB ID :" + filterNcbId + ": Details :" + rmiex.toString());
        }
        catch (TmsGeneralException tmsgenex) {
            throw new TmsBillingException("SettlementReport:findNcb: TmsGeneralException. Finding NCB NCB ID :" + filterNcbId + ": Details :" + tmsgenex.toString());
        }
        if (currentNcbData == null) {
            return null;
        }
        String ncbFullName = "";
        if (currentNcbData.getNamePrefix() != null) {
            ncbFullName = String.valueOf(ncbFullName) + currentNcbData.getNamePrefix();
        }
        if (currentNcbData.getName() != null) {
            ncbFullName = String.valueOf(ncbFullName) + " " + currentNcbData.getName();
        }
        if (currentNcbData.getNameLast() != null) {
            ncbFullName = String.valueOf(ncbFullName) + " " + currentNcbData.getNameLast();
        }
        if (currentNcbData.getNameSuffix() != null) {
            ncbFullName = String.valueOf(ncbFullName) + " " + currentNcbData.getNameSuffix();
        }
        if ((ncbFullName = ncbFullName.trim()).equals("") || ncbFullName.toLowerCase().indexOf(this.dataFilterName.toLowerCase()) == -1) {
            return null;
        }
        return this.createNcb(currentNcbData);
    }

    private Ncb createNcb(NCBData ncbData) throws TmsBillingException {
        Integer ncbId = ncbData.getNcbId();
        Ncb ncb = this.convertNCBDataToNcb(ncbData);
        try {
            Iterator rolesForNcbIterator;
            ArrayList rolesForNcb = EjbHelper.getNCBManager().findNcbRoleByNcb(ncbId.intValue());
            if (rolesForNcb != null && (rolesForNcbIterator = rolesForNcb.iterator()) != null) {
                while (rolesForNcbIterator.hasNext()) {
                    NCBRoleData roleData = (NCBRoleData)rolesForNcbIterator.next();
                    Role role = new Role();
                    role.setDescription(roleData.getRole());
                    ncb.addRole(role);
                }
            }
        }
        catch (RemoteException rmiex) {
            throw new TmsBillingException("SettlementReport:createNcb: RemoteException. Finding NCB Roles. NCB ID :" + ncbData.getNcbId() + ": Details :" + rmiex.toString());
        }
        catch (TmsBillingException tmsblngex) {
            throw new TmsBillingException("SettlementReport:createNcb: TmsBillingException. Finding NCB Roles. NCB ID :" + ncbData.getNcbId() + ": Details :" + tmsblngex.toString());
        }
        catch (TmsGeneralException tmsgenex) {
            throw new TmsBillingException("SettlementReport:createNcb: TmsGeneralException. Finding NCB Roles. NCB ID :" + ncbData.getNcbId() + ": Details :" + tmsgenex.toString());
        }
        catch (FinderException fndex) {
            LogHelper.getBillingLogger().log(Level.DEBUG, (Object)("SettlementReport:createNcb: FinderException. Finding NCB Roles. NCB ID :" + ncbData.getNcbId() + ": Details :" + fndex.toString()));
        }
        if (NcbAddressTypeType.enumerate() != null) {
            Enumeration ncbAddressTypeEnumeration = NcbAddressTypeType.enumerate();
            while (ncbAddressTypeEnumeration.hasMoreElements()) {
                NcbAddressTypeType currentNcbAddressTypeType = (NcbAddressTypeType)ncbAddressTypeEnumeration.nextElement();
                int addressTypeId = currentNcbAddressTypeType.getType();
                try {
                    NCBAddressData ncbAddressData = EjbHelper.getNCBManager().findNcbAddressByType(ncbId.intValue(), addressTypeId);
                    Address ncbAddress = this.convertAddressTypeDataToReportAddress(ncbAddressData);
                    ncb.addAddress(ncbAddress);
                }
                catch (RemoteException rmiex) {
                    throw new TmsBillingException("SettlementReport:createNcb: RemoteException. Finding NCB Addresses. NCB ID :" + ncbData.getNcbId() + ": Type :" + currentNcbAddressTypeType.toString() + ": Details :" + rmiex.toString());
                }
                catch (TmsBillingException tmsblngex) {
                    throw new TmsBillingException("SettlementReport:createNcb: TmsBillingException. Finding NCB Addresses. NCB ID :" + ncbData.getNcbId() + ": Type :" + currentNcbAddressTypeType.toString() + ": Details :" + tmsblngex.toString());
                }
                catch (TmsGeneralException tmsgenex) {
                    throw new TmsBillingException("SettlementReport:createNcb: TmsGeneralException. Finding NCB Addresses. NCB ID :" + ncbData.getNcbId() + ": Type :" + currentNcbAddressTypeType.toString() + ": Details :" + tmsgenex.toString());
                }
                catch (FinderException fndex) {
                    LogHelper.getBillingLogger().log(Level.DEBUG, (Object)("SettlementReport:createNcb: FinderException. Finding NCB Addresses. NCB ID :" + ncbData.getNcbId() + ": Type :" + currentNcbAddressTypeType.toString() + ": Details :" + fndex.toString()));
                }
            }
        }
        try {
            OrderRequestData orderRequest = EjbHelper.getOrderManager().findCurrentOrderRequestByNcb(ncbId.intValue());
            Order order = this.createOrder(orderRequest);
            if (order != null) {
                ncb.addOrder(order);
            }
        }
        catch (RemoteException rmiex) {
            throw new TmsBillingException("SettlementReport:createNcb: RemoteException. Finding Order requests. NCB ID :" + ncbData.getNcbId() + ": Details :" + rmiex.toString());
        }
        catch (TmsBillingException tmsblngex) {
            throw new TmsBillingException("SettlementReport:createNcb: TmsBillingException. Finding Order requests. NCB ID :" + ncbData.getNcbId() + ": Details :" + tmsblngex.toString());
        }
        catch (TmsGeneralException tmsgenex) {
            throw new TmsBillingException("SettlementReport:createNcb: TmsGeneralException. Finding Order requests. NCB ID :" + ncbData.getNcbId() + ": Details :" + tmsgenex.toString());
        }
        catch (FinderException fndex) {
            LogHelper.getBillingLogger().log(Level.DEBUG, (Object)("SettlementReport:createNcb: FinderException. Finding Order requests. NCB ID :" + ncbData.getNcbId() + ": Details :" + fndex.toString()));
        }
        if (this.dataFilterIncludeChildrenNcb) {
            ArrayList ncbChildren = null;
            try {
                ncbChildren = EjbHelper.getNCBManager().findNcbChildren(ncbId.intValue());
            }
            catch (RemoteException rmiex) {
                throw new TmsBillingException("SettlementReport:createNcb: RemoteException. Finding NCB Chidren. NCB ID :" + ncbData.getNcbId() + ": Details :" + rmiex.toString());
            }
            catch (TmsBillingException tmsblngex) {
                throw new TmsBillingException("SettlementReport:createNcb: TmsBillingException. Finding NCB Chidren. NCB ID :" + ncbData.getNcbId() + ": Details :" + tmsblngex.toString());
            }
            catch (TmsGeneralException tmsgenex) {
                throw new TmsBillingException("SettlementReport:createNcb: TmsGeneralException. Finding NCB Chidren. NCB ID :" + ncbData.getNcbId() + ": Details :" + tmsgenex.toString());
            }
            catch (FinderException fndex) {
                LogHelper.getBillingLogger().log(Level.DEBUG, (Object)("SettlementReport:createNcb: FinderException. Finding NCB Chidren. NCB ID :" + ncbData.getNcbId() + ": Details :" + fndex.toString()));
            }
            if (ncbChildren != null && ncbChildren.size() != 0) {
                Iterator childrenIterator = ncbChildren.iterator();
                while (childrenIterator.hasNext()) {
                    NCBData currentNcbChildData = (NCBData)childrenIterator.next();
                    Ncb childNcbCreated = this.createNcb(currentNcbChildData);
                    ncb.addChildNcb(this.convertNcbtoChildNcb(childNcbCreated));
                }
            }
        }
        return ncb;
    }

    private Order createOrder(OrderRequestData orderRequest) throws TmsBillingException {
        if (orderRequest == null) {
            return null;
        }
        Integer orderRequestId = orderRequest.getOrderRequestId();
        if (this.dataFilterInvoiceDate != null && (orderRequest.getInvoiceDate() == null || orderRequest.getInvoiceDate().compareTo(this.dataFilterInvoiceDate) != 0)) {
            return null;
        }
        Order order = this.convertOrderRequestDataToOrder(orderRequest);
        ArrayList orderRequestItems = null;
        try {
            orderRequestItems = EjbHelper.getOrderManager().findOrderRequestItemByOrderRequestId(orderRequestId.intValue());
        }
        catch (RemoteException rmiex) {
            throw new TmsBillingException("SettlementReport:createOrder: RemoteException while finding order items for Oreder Request ID :" + orderRequestId + ": Details :" + rmiex.toString());
        }
        catch (TmsGeneralException tmsge) {
            throw new TmsBillingException("SettlementReport:createOrder: TmsGeneralException while finding order items for Oreder Request ID :" + orderRequestId + ": Details :" + tmsge.toString());
        }
        catch (FinderException tmsge) {
            // empty catch block
        }
        if (orderRequestItems != null) {
            Iterator orderItemIterator = orderRequestItems.iterator();
            while (orderItemIterator.hasNext()) {
                OrderRequestItemData orderRequestItem = (OrderRequestItemData)orderItemIterator.next();
                if (this.dataFilterStartDate != null && orderRequestItem.getTimestamp().compareTo(this.dataFilterStartDate) < 0 || this.dataFilterEndDate != null && orderRequestItem.getTimestamp().compareTo(this.dataFilterEndDate) > 0 || this.dataFilterDeliveryTrackingRefRef != null && orderRequestItem.getDeliveryTrackingRef().toLowerCase().indexOf(this.dataFilterDeliveryTrackingRefRef.toLowerCase()) == -1) continue;
                OrderItem orderItem = this.convertOrderRequestItemDataToOrderItem(orderRequestItem);
                order.addOrderItem(orderItem);
            }
        }
        ArrayList settlements = null;
        try {
            settlements = EjbHelper.getOrderManager().findSettlementByOrderRequestId(orderRequestId.intValue());
        }
        catch (RemoteException rmiex) {
            throw new TmsBillingException("SettlementReport:createOrder: RemoteException while finding settlements for Order Request ID :" + orderRequestId + ": Details :" + rmiex.toString());
        }
        catch (TmsGeneralException tmsge) {
            throw new TmsBillingException("SettlementReport:createOrder: TmsGeneralException while finding settlements for Order Request ID :" + orderRequestId + ": Details :" + tmsge.toString());
        }
        catch (FinderException tmsge) {
            // empty catch block
        }
        if (settlements != null) {
            Iterator settlementIterator = settlements.iterator();
            while (settlementIterator.hasNext()) {
                SettlementData settlementData = (SettlementData)settlementIterator.next();
                Settlement settlement = this.convertSettlementDataToSettlement(settlementData);
                order.addSettlement(settlement);
            }
        }
        return order;
    }

    private ChildNcb convertNcbtoChildNcb(Ncb ncbToConvert) {
        ChildNcb childNcbToReturn = new ChildNcb();
        childNcbToReturn.setNcbType(ncbToConvert.getNcbType());
        childNcbToReturn.setNamePrefix(ncbToConvert.getNamePrefix());
        childNcbToReturn.setName(ncbToConvert.getName());
        childNcbToReturn.setNameLast(ncbToConvert.getNameLast());
        childNcbToReturn.setNameSuffix(ncbToConvert.getNameSuffix());
        childNcbToReturn.setLoginName(ncbToConvert.getLoginName());
        childNcbToReturn.setOneOff(ncbToConvert.getOneOff());
        childNcbToReturn.setRole(ncbToConvert.getRole());
        childNcbToReturn.setAddress(ncbToConvert.getAddress());
        childNcbToReturn.setOrder(ncbToConvert.getOrder());
        childNcbToReturn.setChildNcb(ncbToConvert.getChildNcb());
        return childNcbToReturn;
    }

    private Address convertAddressTypeDataToReportAddress(NCBAddressData ncbAddressDataToConvert) {
        Address addressToReturn = new Address();
        addressToReturn.setAddressType(TmsConst.NCB_ADDRESS_TYPE[ncbAddressDataToConvert.getAddressTypeId()]);
        addressToReturn.setStreetLine1(ncbAddressDataToConvert.getStreetLine1());
        addressToReturn.setStreetLine2(ncbAddressDataToConvert.getStreetLine2());
        addressToReturn.setStreetLine3(ncbAddressDataToConvert.getStreetLine3());
        addressToReturn.setCity(ncbAddressDataToConvert.getCity());
        addressToReturn.setStateProv(ncbAddressDataToConvert.getStateProv());
        addressToReturn.setPostalCode(ncbAddressDataToConvert.getPostalCode());
        addressToReturn.setCountryCode(ncbAddressDataToConvert.getCountryCode());
        addressToReturn.setPhoneNumber(ncbAddressDataToConvert.getPhoneNumber());
        addressToReturn.setFaxNumber(ncbAddressDataToConvert.getFaxNumber());
        addressToReturn.setEmail(ncbAddressDataToConvert.getEmail());
        return addressToReturn;
    }

    private Order convertOrderRequestDataToOrder(OrderRequestData orderRequestDataToConvert) {
        Order order = new Order();
        order.setStartDate(orderRequestDataToConvert.getStartDate());
        order.setEndDate(orderRequestDataToConvert.getEndDate());
        order.setInvoiceDate(orderRequestDataToConvert.getInvoiceDate());
        return order;
    }

    private OrderItem convertOrderRequestItemDataToOrderItem(OrderRequestItemData orderRequestItemDataToConvert) throws TmsBillingException {
        OrderItem orderItem = new OrderItem();
        Integer itemId = orderRequestItemDataToConvert.getItemId();
        String itemName = "";
        String itemCode = "";
        String itemServiceCode = "";
        try {
            ItemData itemData = EjbHelper.getServiceManager().findItemById(itemId);
            itemName = itemData.getName();
            itemCode = itemData.getCode();
            itemServiceCode = itemData.getServiceCode();
        }
        catch (RemoteException rmiex) {
            throw new TmsBillingException("SettlementReport:convertOrderRequestItemDataToOrderItem: RemoteException while finding Item ID :" + itemId + ": Details :" + rmiex.toString());
        }
        catch (TmsBillingException tmsbex) {
            throw new TmsBillingException("SettlementReport:convertOrderRequestItemDataToOrderItem: TmsBillingException while finding Item ID :" + itemId + ": Details :" + tmsbex.toString());
        }
        catch (TmsGeneralException tmsgex) {
            throw new TmsBillingException("SettlementReport:convertOrderRequestItemDataToOrderItem: TmsGeneralException while finding Item ID :" + itemId + ": Details :" + tmsgex.toString());
        }
        catch (FinderException fndex) {
            throw new TmsBillingException("SettlementReport:convertOrderRequestItemDataToOrderItem: TmsGeneralException while finding Item ID :" + itemId + ": Details :" + fndex.toString());
        }
        String serviceName = "";
        try {
            ServiceData serviceData = EjbHelper.getServiceManager().findServiceByCode(itemServiceCode);
            serviceName = serviceData.getName();
        }
        catch (RemoteException rmiex) {
            throw new TmsBillingException("SettlementReport:convertOrderRequestItemDataToOrderItem: RemoteException while finding Service Code :" + itemServiceCode + ": Details :" + rmiex.toString());
        }
        catch (TmsBillingException tmsbex) {
            throw new TmsBillingException("SettlementReport:convertOrderRequestItemDataToOrderItem: TmsBillingException while finding Service Code :" + itemServiceCode + ": Details :" + tmsbex.toString());
        }
        catch (TmsGeneralException tmsgex) {
            throw new TmsBillingException("SettlementReport:convertOrderRequestItemDataToOrderItem: TmsGeneralException while finding Service Code :" + itemServiceCode + ": Details :" + tmsgex.toString());
        }
        catch (FinderException fndex) {
            throw new TmsBillingException("SettlementReport:convertOrderRequestItemDataToOrderItem: TmsGeneralException while finding Service Code :" + itemServiceCode + ": Details :" + fndex.toString());
        }
        int itemQuantity = orderRequestItemDataToConvert.getQuantity();
        double ratingCost = orderRequestItemDataToConvert.getCost();
        double invoicedCost = ratingCost * (double)itemQuantity;
        orderItem.setName(itemName);
        orderItem.setCode(itemCode);
        orderItem.setServiceCode(itemServiceCode);
        orderItem.setServiceName(serviceName);
        orderItem.setQuantity(new Integer(itemQuantity));
        orderItem.setTransactionDateTime(orderRequestItemDataToConvert.getTimestamp());
        orderItem.setInvoiceCost(FormatHelper.moneyFormat(invoicedCost));
        orderItem.setRatingCost(FormatHelper.moneyFormat(ratingCost));
        orderItem.setServiceRequest(orderRequestItemDataToConvert.getServiceRequest());
        orderItem.setServiceResponse(orderRequestItemDataToConvert.getServiceResponse());
        orderItem.setServiceSessionId(orderRequestItemDataToConvert.getServiceSessionId());
        orderItem.setCustomerOnChargeRef(orderRequestItemDataToConvert.getCustomerOnChargeRef());
        orderItem.setDeliveryMethod(orderRequestItemDataToConvert.getDeliveryMethod());
        orderItem.setDeliveryTrackingRef(orderRequestItemDataToConvert.getDeliveryTrackingRef());
        orderItem.setVoucherPresented(orderRequestItemDataToConvert.getVoucherPresented());
        return orderItem;
    }

    private Settlement convertSettlementDataToSettlement(SettlementData settlementDataToConvert) throws TmsBillingException {
        Settlement settlement = new Settlement();
        Integer settlementId = settlementDataToConvert.getSettlementId();
        String settlementBrandName = "";
        try {
            ArrayList settlementBrands = EjbHelper.getOrderManager().findSettelmentBrands(settlementId);
            if (settlementBrands != null) {
                Iterator settlementBrandsIterator = settlementBrands.iterator();
                while (settlementBrandsIterator.hasNext()) {
                    SettlementBrandData currentSettlementBrandData = (SettlementBrandData)settlementBrandsIterator.next();
                    BrandData brandData = EjbHelper.getGeneralManager().findBrandById(currentSettlementBrandData.getBrandId());
                    if (!settlementBrandName.equals("")) {
                        settlementBrandName = String.valueOf(settlementBrandName) + " ";
                    }
                    settlementBrandName = String.valueOf(settlementBrandName) + brandData.getName();
                }
            }
        }
        catch (RemoteException rmiex) {
            throw new TmsBillingException("SettlementReport:convertSettlementDataToSettlement: RemoteException while finding settlement brand name. Settlement ID :" + settlementId + ": Details :" + rmiex.toString());
        }
        catch (TmsBillingException tmsbex) {
            throw new TmsBillingException("SettlementReport:convertSettlementDataToSettlement: TmsBillingException while finding settlement brand name. Settlement ID :" + settlementId + ": Details :" + tmsbex.toString());
        }
        catch (TmsGeneralException tmsgex) {
            throw new TmsBillingException("SettlementReport:convertSettlementDataToSettlement: TmsGeneralException while finding settlement brand name. Settlement ID :" + settlementId + ": Details :" + tmsgex.toString());
        }
        catch (FinderException fndex) {
            throw new TmsBillingException("SettlementReport:convertSettlementDataToSettlement: TmsGeneralException while finding settlement brand name. Settlement ID :" + settlementId + ": Details :" + fndex.toString());
        }
        settlement.setAmount(FormatHelper.moneyFormat(settlementDataToConvert.getAmount()));
        settlement.setBrandName(settlementBrandName);
        settlement.setCurrencyCode(settlementDataToConvert.getCurrencyCode());
        settlement.setTransactionDateTime(settlementDataToConvert.getTimeStamp());
        settlement.setReceipt(settlementDataToConvert.getReceipt());
        settlement.setSignature(settlementDataToConvert.getSignature());
        settlement.setCompletionRef(settlementDataToConvert.getCompletionRef());
        return settlement;
    }

    private Ncb convertNCBDataToNcb(NCBData ncbDataToConvert) {
        Ncb ncb = new Ncb();
        if (ncbDataToConvert.getNcbTypeId() != null) {
            ncb.setNcbType(NcbTypeType.valueOf(TmsConst.NCB_TYPE[ncbDataToConvert.getNcbTypeId()]).toString());
        } else {
            ncb.setNcbType(NcbTypeType.valueOf(TmsConst.NCB_TYPE[2]).toString());
        }
        ncb.setNamePrefix(ncbDataToConvert.getNamePrefix());
        ncb.setName(ncbDataToConvert.getName());
        ncb.setNameLast(ncbDataToConvert.getNameLast());
        ncb.setNameSuffix(ncbDataToConvert.getNameSuffix());
        ncb.setActive(new Boolean(ncbDataToConvert.getActive()));
        ncb.setLoginName(ncbDataToConvert.getLoginName());
        ncb.setOneOff(new Boolean(ncbDataToConvert.getOneOff()));
        return ncb;
    }

    private ChildNcb convertNCBDataToChildNcb(NCBData ncbDataToConvert) {
        ChildNcb ncb = new ChildNcb();
        if (ncbDataToConvert.getNcbTypeId() != null) {
            ncb.setNcbType(NcbTypeType.valueOf(TmsConst.NCB_TYPE[ncbDataToConvert.getNcbTypeId()]).toString());
        } else {
            ncb.setNcbType(NcbTypeType.valueOf(TmsConst.NCB_TYPE[2]).toString());
        }
        ncb.setNamePrefix(ncbDataToConvert.getNamePrefix());
        ncb.setName(ncbDataToConvert.getName());
        ncb.setNameLast(ncbDataToConvert.getNameLast());
        ncb.setNameSuffix(ncbDataToConvert.getNameSuffix());
        ncb.setActive(new Boolean(ncbDataToConvert.getActive()));
        ncb.setLoginName(ncbDataToConvert.getLoginName());
        ncb.setOneOff(new Boolean(ncbDataToConvert.getOneOff()));
        return ncb;
    }
}

