/*
 * Decompiled with CFR 0.152.
 */
package nz.co.k.tms.billing.report;

import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import javax.ejb.FinderException;
import nz.co.k.tms.billing.ejb.ItemData;
import nz.co.k.tms.billing.ejb.OrderRequestItemData;
import nz.co.k.tms.billing.ejb.ServiceData;
import nz.co.k.tms.exception.TmsBillingException;
import nz.co.k.tms.exception.TmsGeneralException;
import nz.co.k.tms.exception.TmsNoResultException;
import nz.co.k.tms.utility.EjbHelper;
import nz.co.k.tms.utility.FormatHelper;
import nz.co.k.tms.utility.LogHelper;
import nz.co.k.tms.utility.XmlHelper;
import nz.co.k.tms.xml.report.royalty.OrderItem;
import nz.co.k.tms.xml.report.royalty.TmsRoyaltyReport;
import org.apache.log4j.Level;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.ValidationException;

public class RoyaltyReport {
    private String dataFilterServiceCode;
    private String dataFilterItemCode;
    private String dataFilterServiceRequest;
    private Date dataFilterStartDate;
    private Date dataFilterEndDate;

    public RoyaltyReport(String serviceCode, String itemCode, String serviceRequest, Date startDateTime, Date endDateTime) {
        this.dataFilterServiceCode = serviceCode;
        this.dataFilterItemCode = itemCode;
        this.dataFilterServiceRequest = serviceRequest;
        this.dataFilterStartDate = startDateTime;
        this.dataFilterEndDate = endDateTime;
    }

    public String getReportXmlString() throws TmsBillingException, TmsNoResultException {
        if (this.dataFilterServiceCode == null && this.dataFilterItemCode == null && this.dataFilterServiceRequest == null) {
            throw new TmsBillingException("RoyaltyReport:getReportXmlString: Royalty report failed. Could not find the Royalty details as the required filters are all null.");
        }
        TmsRoyaltyReport tmsRoyaltyReport = new TmsRoyaltyReport();
        if ((tmsRoyaltyReport = this.getOrderItems(tmsRoyaltyReport)).getOrderItemCount() == 0) {
            throw new TmsNoResultException("Could not find any royalty report details.");
        }
        try {
            return XmlHelper.marshalTmsRoyaltyReportMessage(tmsRoyaltyReport);
        }
        catch (MarshalException me) {
            LogHelper.getBillingLogger().log(Level.ERROR, (Object)("RoyaltyReport:getReportXmlString: MarshalException. Details :" + me.toString()));
            throw new TmsBillingException("RoyaltyReport:getReportXmlString: MarshalException.Details :" + me.toString());
        }
        catch (ValidationException ve) {
            LogHelper.getBillingLogger().log(Level.ERROR, (Object)("RoyaltyReport:getReportXmlString: ValidationException. Details :" + ve.toString()));
            throw new TmsBillingException("RoyaltyReport:getReportXmlString: ValidationException. Details :" + ve.toString());
        }
    }

    private TmsRoyaltyReport getOrderItems(TmsRoyaltyReport tmsRoyaltyReportToAddTo) throws TmsBillingException, TmsNoResultException {
        ArrayList orderItemsFound = new ArrayList();
        ArrayList itemsFound = new ArrayList();
        try {
            if (this.dataFilterServiceCode != null && this.dataFilterItemCode != null) {
                ItemData itemFound = EjbHelper.getServiceManager().findItemByCodeAndServiceCode(this.dataFilterItemCode, this.dataFilterServiceCode, true);
                itemsFound.add(itemFound);
            } else if (this.dataFilterServiceCode != null && this.dataFilterItemCode == null) {
                itemsFound = EjbHelper.getServiceManager().findItemByServiceCode(this.dataFilterServiceCode, true);
            } else if (this.dataFilterServiceCode == null && this.dataFilterItemCode != null) {
                itemsFound = EjbHelper.getServiceManager().findItemByItemCode(this.dataFilterItemCode, true);
            }
            if (itemsFound.size() > 0) {
                Iterator itemsFoundIterator = itemsFound.iterator();
                while (itemsFoundIterator.hasNext()) {
                    ItemData currentItemData = (ItemData)itemsFoundIterator.next();
                    ArrayList orderRequestItemsFound = EjbHelper.getOrderManager().findOrderRequestItemByItemId(currentItemData.getItemId().intValue());
                    if (orderRequestItemsFound == null) continue;
                    orderItemsFound.addAll(orderRequestItemsFound);
                }
                if (orderItemsFound.size() > 0) {
                    Iterator orderItemsFoundIterator = orderItemsFound.iterator();
                    while (orderItemsFoundIterator.hasNext()) {
                        OrderItem currentOrderItem;
                        OrderRequestItemData currentOrderRequestItemData = (OrderRequestItemData)orderItemsFoundIterator.next();
                        if (this.dataFilterStartDate != null && currentOrderRequestItemData.getTimestamp().compareTo(this.dataFilterStartDate) < 0 || this.dataFilterEndDate != null && currentOrderRequestItemData.getTimestamp().compareTo(this.dataFilterEndDate) > 0 || this.dataFilterServiceRequest != null && (currentOrderRequestItemData.getServiceRequest() == null || currentOrderRequestItemData.getServiceRequest().toLowerCase().indexOf(this.dataFilterServiceRequest.toLowerCase()) == -1) || (currentOrderItem = this.convertOrderRequestItemDataToOrderItem(currentOrderRequestItemData)) == null) continue;
                        tmsRoyaltyReportToAddTo.addOrderItem(currentOrderItem);
                    }
                }
            }
        }
        catch (RemoteException rmiex) {
            throw new TmsBillingException("RoyaltyReport:getOrderItems: RemoteException while finding order request items ItemCode :" + this.dataFilterItemCode + " ServiceCode " + this.dataFilterServiceCode + ": Details :" + rmiex.toString());
        }
        catch (TmsBillingException tmsbex) {
            throw new TmsBillingException("RoyaltyReport:getOrderItems: TmsBillingException while finding order request items ItemCode :" + this.dataFilterItemCode + " ServiceCode " + this.dataFilterServiceCode + ": Details :" + tmsbex.toString());
        }
        catch (TmsGeneralException tmsgex) {
            throw new TmsBillingException("RoyaltyReport:getOrderItems: TmsGeneralException while finding order request items ItemCode :" + this.dataFilterItemCode + " ServiceCode " + this.dataFilterServiceCode + ": Details :" + tmsgex.toString());
        }
        catch (FinderException fndex) {
            String errorDescription = "Could not find any order items for the filters.";
            if (this.dataFilterServiceCode != null) {
                errorDescription = String.valueOf(errorDescription) + " Serivce Code :" + this.dataFilterServiceCode;
            }
            if (this.dataFilterItemCode != null) {
                errorDescription = String.valueOf(errorDescription) + " Item Code :" + this.dataFilterItemCode;
            }
            throw new TmsNoResultException(errorDescription);
        }
        return tmsRoyaltyReportToAddTo;
    }

    private OrderItem convertOrderRequestItemDataToOrderItem(OrderRequestItemData orderRequestItemDataToConvert) throws TmsBillingException {
        OrderItem orderItem = new OrderItem();
        Integer itemId = orderRequestItemDataToConvert.getItemId();
        String itemName = "";
        String itemCode = "";
        String itemServiceCode = "";
        try {
            ItemData itemData = EjbHelper.getServiceManager().findItemById(itemId);
            itemName = itemData.getName();
            itemCode = itemData.getCode();
            itemServiceCode = itemData.getServiceCode();
        }
        catch (RemoteException rmiex) {
            throw new TmsBillingException("RoyaltyReport:convertOrderRequestItemDataToOrderItem: RemoteException while finding Item ID :" + itemId + ": Details :" + rmiex.toString());
        }
        catch (TmsBillingException tmsbex) {
            throw new TmsBillingException("RoyaltyReport:convertOrderRequestItemDataToOrderItem: TmsBillingException while finding Item ID :" + itemId + ": Details :" + tmsbex.toString());
        }
        catch (TmsGeneralException tmsgex) {
            throw new TmsBillingException("RoyaltyReport:convertOrderRequestItemDataToOrderItem: TmsGeneralException while finding Item ID :" + itemId + ": Details :" + tmsgex.toString());
        }
        catch (FinderException fndex) {
            throw new TmsBillingException("RoyaltyReport:convertOrderRequestItemDataToOrderItem: TmsGeneralException while finding Item ID :" + itemId + ": Details :" + fndex.toString());
        }
        String serviceName = "";
        try {
            ServiceData serviceData = EjbHelper.getServiceManager().findServiceByCode(itemServiceCode);
            serviceName = serviceData.getName();
        }
        catch (RemoteException rmiex) {
            throw new TmsBillingException("RoyaltyReport:convertOrderRequestItemDataToOrderItem: RemoteException while finding Service Code :" + itemServiceCode + ": Details :" + rmiex.toString());
        }
        catch (TmsBillingException tmsbex) {
            throw new TmsBillingException("RoyaltyReport:convertOrderRequestItemDataToOrderItem: TmsBillingException while finding Service Code :" + itemServiceCode + ": Details :" + tmsbex.toString());
        }
        catch (TmsGeneralException tmsgex) {
            throw new TmsBillingException("RoyaltyReport:convertOrderRequestItemDataToOrderItem: TmsGeneralException while finding Service Code :" + itemServiceCode + ": Details :" + tmsgex.toString());
        }
        catch (FinderException fndex) {
            throw new TmsBillingException("RoyaltyReport:convertOrderRequestItemDataToOrderItem: TmsGeneralException while finding Service Code :" + itemServiceCode + ": Details :" + fndex.toString());
        }
        int itemQuantity = orderRequestItemDataToConvert.getQuantity();
        double ratingCost = orderRequestItemDataToConvert.getCost();
        double invoicedCost = ratingCost * (double)itemQuantity;
        orderItem.setName(itemName);
        orderItem.setCode(itemCode);
        orderItem.setServiceCode(itemServiceCode);
        orderItem.setServiceName(serviceName);
        orderItem.setQuantity(new Integer(itemQuantity));
        orderItem.setTransactionDateTime(orderRequestItemDataToConvert.getTimestamp());
        orderItem.setInvoiceCost(FormatHelper.moneyFormat(invoicedCost));
        orderItem.setRatingCost(FormatHelper.moneyFormat(ratingCost));
        orderItem.setServiceRequest(orderRequestItemDataToConvert.getServiceRequest());
        orderItem.setServiceResponse(orderRequestItemDataToConvert.getServiceResponse());
        orderItem.setVoucherPresented(orderRequestItemDataToConvert.getVoucherPresented());
        return orderItem;
    }
}

