/*
 * Decompiled with CFR 0.152.
 */
package nz.co.k.tms.billing.report;

import java.io.UnsupportedEncodingException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.Iterator;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;
import javax.ejb.FinderException;
import nz.co.k.tms.billing.ejb.AccountData;
import nz.co.k.tms.billing.ejb.BrandData;
import nz.co.k.tms.billing.ejb.ItemData;
import nz.co.k.tms.billing.ejb.NCBAddressData;
import nz.co.k.tms.billing.ejb.NCBData;
import nz.co.k.tms.billing.ejb.NCBRoleData;
import nz.co.k.tms.billing.ejb.OrderRequestData;
import nz.co.k.tms.billing.ejb.OrderRequestItemData;
import nz.co.k.tms.billing.ejb.ServiceData;
import nz.co.k.tms.billing.ejb.SettlementBrandData;
import nz.co.k.tms.billing.ejb.SettlementData;
import nz.co.k.tms.exception.TmsBillingException;
import nz.co.k.tms.exception.TmsGeneralException;
import nz.co.k.tms.exception.TmsNoResultException;
import nz.co.k.tms.utility.EjbHelper;
import nz.co.k.tms.utility.FormatHelper;
import nz.co.k.tms.utility.LogHelper;
import nz.co.k.tms.utility.TmsConst;
import nz.co.k.tms.utility.XmlHelper;
import nz.co.k.tms.utility.security.SecurityHelper;
import nz.co.k.tms.xml.report.fraud.Address;
import nz.co.k.tms.xml.report.fraud.Ncb;
import nz.co.k.tms.xml.report.fraud.Order;
import nz.co.k.tms.xml.report.fraud.OrderItem;
import nz.co.k.tms.xml.report.fraud.Role;
import nz.co.k.tms.xml.report.fraud.Settlement;
import nz.co.k.tms.xml.report.fraud.TmsFraudReport;
import nz.co.k.tms.xml.types.NcbAddressTypeType;
import nz.co.k.tms.xml.types.NcbTypeType;
import org.apache.log4j.Level;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.ValidationException;

public class FraudReport {
    private Integer dataFilterNcbId;
    private String dataFilterName;
    private String dataFilterCreditCard;
    private Date dataFilterStartDate;
    private Date dataFilterEndDate;

    public FraudReport(Integer reportNcbId, String ncbName, String creditCard, Date startDateTime, Date endDateTime) {
        this.dataFilterNcbId = reportNcbId;
        this.dataFilterName = ncbName;
        this.dataFilterCreditCard = creditCard;
        this.dataFilterStartDate = startDateTime;
        this.dataFilterEndDate = endDateTime;
    }

    public String getReportXmlString() throws TmsBillingException, TmsNoResultException {
        TmsFraudReport tmsFraudReport = new TmsFraudReport();
        if (this.dataFilterNcbId == null) {
            ArrayList ncbsFound = null;
            try {
                ncbsFound = EjbHelper.getNCBManager().findAllNcb(true);
            }
            catch (FinderException fndex) {
                throw new TmsNoResultException("Could not find any NCBs.");
            }
            catch (RemoteException rmiex) {
                throw new TmsBillingException("FraudReport:findAllNcb: RemoteException. Finding all NCB. Details :" + rmiex.toString());
            }
            catch (TmsGeneralException tmsgenex) {
                throw new TmsBillingException("FraudReport:findAllNcb: TmsGeneralException. Finding all NCB.  Details :" + tmsgenex.toString());
            }
            if (ncbsFound != null) {
                Iterator ncbsFoundIterator = ncbsFound.iterator();
                while (ncbsFoundIterator.hasNext()) {
                    Ncb ncb;
                    NCBData currentNcbData = (NCBData)ncbsFoundIterator.next();
                    if (this.dataFilterName != null) {
                        String ncbFullName = "";
                        if (currentNcbData.getNamePrefix() != null) {
                            ncbFullName = String.valueOf(ncbFullName) + currentNcbData.getNamePrefix();
                        }
                        if (currentNcbData.getName() != null) {
                            ncbFullName = String.valueOf(ncbFullName) + " " + currentNcbData.getName();
                        }
                        if (currentNcbData.getNameLast() != null) {
                            ncbFullName = String.valueOf(ncbFullName) + " " + currentNcbData.getNameLast();
                        }
                        if (currentNcbData.getNameSuffix() != null) {
                            ncbFullName = String.valueOf(ncbFullName) + " " + currentNcbData.getNameSuffix();
                        }
                        if ((ncbFullName = ncbFullName.trim()).equals("") || ncbFullName.toLowerCase().indexOf(this.dataFilterName.toLowerCase()) == -1) continue;
                    }
                    if ((ncb = this.createNcb(currentNcbData)) == null) continue;
                    tmsFraudReport.addNcb(ncb);
                }
            }
        } else {
            Ncb ncb = this.findNcb(this.dataFilterNcbId);
            if (ncb == null) {
                throw new TmsNoResultException("Could not find a NCB with the ID :" + this.dataFilterNcbId);
            }
            tmsFraudReport.addNcb(ncb);
        }
        if (tmsFraudReport.getNcbCount() <= 0) {
            throw new TmsNoResultException("Could not find any fraud report details.");
        }
        try {
            return XmlHelper.marshalTmsFraudReportMessage(tmsFraudReport);
        }
        catch (MarshalException me) {
            LogHelper.getBillingLogger().log(Level.ERROR, (Object)("FraudReport:getReportXmlString: MarshalException. Details :" + me.toString()));
            throw new TmsBillingException("FraudReport:getReportXmlString: MarshalException.Details :" + me.toString());
        }
        catch (ValidationException ve) {
            LogHelper.getBillingLogger().log(Level.ERROR, (Object)("FraudReport:getReportXmlString: ValidationException. Details :" + ve.toString()));
            throw new TmsBillingException("FraudReport:getReportXmlString: ValidationException. Details :" + ve.toString());
        }
    }

    private Ncb findNcb(Integer filterNcbId) throws TmsBillingException, TmsNoResultException {
        NCBData currentNcbData = null;
        try {
            if (filterNcbId != null) {
                currentNcbData = EjbHelper.getNCBManager().findNcbById(filterNcbId.intValue(), true);
            }
        }
        catch (FinderException fndex) {
            throw new TmsNoResultException("Could not find a NCB with the ID :" + filterNcbId);
        }
        catch (RemoteException rmiex) {
            throw new TmsBillingException("FraudReport:findNcb: RemoteException. Finding NCB NCB ID :" + filterNcbId + ": Details :" + rmiex.toString());
        }
        catch (TmsGeneralException tmsgenex) {
            throw new TmsBillingException("FraudReport:findNcb: TmsGeneralException. Finding NCB NCB ID :" + filterNcbId + ": Details :" + tmsgenex.toString());
        }
        if (currentNcbData == null) {
            return null;
        }
        if (this.dataFilterName != null) {
            String ncbFullName = "";
            if (currentNcbData.getNamePrefix() != null) {
                ncbFullName = String.valueOf(ncbFullName) + currentNcbData.getNamePrefix();
            }
            if (currentNcbData.getName() != null) {
                ncbFullName = String.valueOf(ncbFullName) + " " + currentNcbData.getName();
            }
            if (currentNcbData.getNameLast() != null) {
                ncbFullName = String.valueOf(ncbFullName) + " " + currentNcbData.getNameLast();
            }
            if (currentNcbData.getNameSuffix() != null) {
                ncbFullName = String.valueOf(ncbFullName) + " " + currentNcbData.getNameSuffix();
            }
            if ((ncbFullName = ncbFullName.trim()).equals("") || ncbFullName.toLowerCase().indexOf(this.dataFilterName.toLowerCase()) == -1) {
                return null;
            }
        }
        return this.createNcb(currentNcbData);
    }

    private Ncb createNcb(NCBData ncbData) throws TmsBillingException {
        Ncb ncb;
        Integer ncbId;
        block20: {
            ncbId = ncbData.getNcbId();
            ncb = this.convertNCBDataToNcb(ncbData);
            try {
                OrderRequestData orderRequest = EjbHelper.getOrderManager().findCurrentOrderRequestByNcb(ncbId.intValue());
                Order order = this.createOrder(orderRequest);
                if (order != null) {
                    ncb.addOrder(order);
                    break block20;
                }
                return null;
            }
            catch (RemoteException rmiex) {
                throw new TmsBillingException("FraudReport:createNcb: RemoteException. Finding Order requests. NCB ID :" + ncbData.getNcbId() + ": Details :" + rmiex.toString());
            }
            catch (TmsBillingException tmsblngex) {
                throw new TmsBillingException("FraudReport:createNcb: TmsBillingException. Finding Order requests. NCB ID :" + ncbData.getNcbId() + ": Details :" + tmsblngex.toString());
            }
            catch (TmsGeneralException tmsgenex) {
                throw new TmsBillingException("FraudReport:createNcb: TmsGeneralException. Finding Order requests. NCB ID :" + ncbData.getNcbId() + ": Details :" + tmsgenex.toString());
            }
            catch (FinderException fndex) {
                LogHelper.getBillingLogger().log(Level.DEBUG, (Object)("FraudReport:createNcb: FinderException. Finding Order requests. NCB ID :" + ncbData.getNcbId() + ": Details :" + fndex.toString()));
            }
        }
        try {
            Iterator rolesForNcbIterator;
            ArrayList rolesForNcb = EjbHelper.getNCBManager().findNcbRoleByNcb(ncbId.intValue());
            if (rolesForNcb != null && (rolesForNcbIterator = rolesForNcb.iterator()) != null) {
                while (rolesForNcbIterator.hasNext()) {
                    NCBRoleData roleData = (NCBRoleData)rolesForNcbIterator.next();
                    Role role = new Role();
                    role.setDescription(roleData.getRole());
                    ncb.addRole(role);
                }
            }
        }
        catch (RemoteException rmiex) {
            throw new TmsBillingException("FraudReport:createNcb: RemoteException. Finding NCB Roles. NCB ID :" + ncbData.getNcbId() + ": Details :" + rmiex.toString());
        }
        catch (TmsBillingException tmsblngex) {
            throw new TmsBillingException("FraudReport:createNcb: TmsBillingException. Finding NCB Roles. NCB ID :" + ncbData.getNcbId() + ": Details :" + tmsblngex.toString());
        }
        catch (TmsGeneralException tmsgenex) {
            throw new TmsBillingException("FraudReport:createNcb: TmsGeneralException. Finding NCB Roles. NCB ID :" + ncbData.getNcbId() + ": Details :" + tmsgenex.toString());
        }
        catch (FinderException fndex) {
            LogHelper.getBillingLogger().log(Level.DEBUG, (Object)("FraudReport:createNcb: FinderException. Finding NCB Roles. NCB ID :" + ncbData.getNcbId() + ": Details :" + fndex.toString()));
        }
        if (NcbAddressTypeType.enumerate() != null) {
            Enumeration ncbAddressTypeEnumeration = NcbAddressTypeType.enumerate();
            while (ncbAddressTypeEnumeration.hasMoreElements()) {
                NcbAddressTypeType currentNcbAddressTypeType = (NcbAddressTypeType)ncbAddressTypeEnumeration.nextElement();
                int addressTypeId = currentNcbAddressTypeType.getType();
                try {
                    NCBAddressData ncbAddressData = EjbHelper.getNCBManager().findNcbAddressByType(ncbId.intValue(), addressTypeId);
                    Address ncbAddress = this.convertAddressTypeDataToReportAddress(ncbAddressData);
                    ncb.addAddress(ncbAddress);
                }
                catch (RemoteException rmiex) {
                    throw new TmsBillingException("FraudReport:createNcb: RemoteException. Finding NCB Addresses. NCB ID :" + ncbData.getNcbId() + ": Type :" + currentNcbAddressTypeType.toString() + ": Details :" + rmiex.toString());
                }
                catch (TmsBillingException tmsblngex) {
                    throw new TmsBillingException("FraudReport:createNcb: TmsBillingException. Finding NCB Addresses. NCB ID :" + ncbData.getNcbId() + ": Type :" + currentNcbAddressTypeType.toString() + ": Details :" + tmsblngex.toString());
                }
                catch (TmsGeneralException tmsgenex) {
                    throw new TmsBillingException("FraudReport:createNcb: TmsGeneralException. Finding NCB Addresses. NCB ID :" + ncbData.getNcbId() + ": Type :" + currentNcbAddressTypeType.toString() + ": Details :" + tmsgenex.toString());
                }
                catch (FinderException fndex) {
                    LogHelper.getBillingLogger().log(Level.DEBUG, (Object)("FraudReport:createNcb: FinderException. Finding NCB Addresses. NCB ID :" + ncbData.getNcbId() + ": Type :" + currentNcbAddressTypeType.toString() + ": Details :" + fndex.toString()));
                }
            }
        }
        return ncb;
    }

    private Order createOrder(OrderRequestData orderRequest) throws TmsBillingException {
        Integer orderRequestId;
        block23: {
            if (orderRequest == null) {
                return null;
            }
            orderRequestId = orderRequest.getOrderRequestId();
            if (this.dataFilterCreditCard != null) {
                try {
                    AccountData orderRequestAccount = EjbHelper.getAccountManager().findAccountById(orderRequest.getAccountId());
                    if (orderRequestAccount == null) break block23;
                    String authCardNumber = null;
                    try {
                        authCardNumber = SecurityHelper.decrypt(orderRequestAccount.getAuthorizationCardNumber());
                    }
                    catch (BadPaddingException bpex) {
                        LogHelper.getBuyLineLogger().log(Level.ERROR, (Object)("ProcessTransactionSettlement: BadPaddingException " + bpex.getMessage()));
                    }
                    catch (IllegalBlockSizeException ibsex) {
                        LogHelper.getBuyLineLogger().log(Level.ERROR, (Object)("ProcessTransactionSettlement: IllegalBlockSizeException " + ibsex.getMessage()));
                    }
                    catch (UnsupportedEncodingException ueex) {
                        LogHelper.getBuyLineLogger().log(Level.ERROR, (Object)("ProcessTransactionSettlement: UnsupportedEncodingException " + ueex.getMessage()));
                    }
                    if (authCardNumber.toLowerCase().indexOf(this.dataFilterCreditCard.toLowerCase()) == -1) {
                        return null;
                    }
                }
                catch (RemoteException rmiex) {
                    throw new TmsBillingException("UsageReport:createOrder: RemoteException while finding order items for Order Request ID :" + orderRequestId + ": Details :" + rmiex.toString());
                }
                catch (TmsGeneralException tmsge) {
                    throw new TmsBillingException("UsageReport:createOrder: TmsGeneralException while finding order items for Oreder Request ID :" + orderRequestId + ": Details :" + tmsge.toString());
                }
                catch (FinderException tmsge) {
                    // empty catch block
                }
            }
        }
        Order order = this.convertOrderRequestDataToOrder(orderRequest);
        ArrayList orderRequestItems = null;
        try {
            orderRequestItems = EjbHelper.getOrderManager().findOrderRequestItemByOrderRequestId(orderRequestId.intValue());
        }
        catch (RemoteException rmiex) {
            throw new TmsBillingException("UsageReport:createOrder: RemoteException while finding order items for Oreder Request ID :" + orderRequestId + ": Details :" + rmiex.toString());
        }
        catch (TmsGeneralException tmsge) {
            throw new TmsBillingException("UsageReport:createOrder: TmsGeneralException while finding order items for Oreder Request ID :" + orderRequestId + ": Details :" + tmsge.toString());
        }
        catch (FinderException tmsge) {
            // empty catch block
        }
        if (orderRequestItems != null) {
            Iterator orderItemIterator = orderRequestItems.iterator();
            while (orderItemIterator.hasNext()) {
                OrderRequestItemData orderRequestItem = (OrderRequestItemData)orderItemIterator.next();
                if (this.dataFilterStartDate != null && orderRequestItem.getTimestamp().compareTo(this.dataFilterStartDate) < 0 || this.dataFilterEndDate != null && orderRequestItem.getTimestamp().compareTo(this.dataFilterEndDate) > 0) continue;
                OrderItem orderItem = this.convertOrderRequestItemDataToOrderItem(orderRequestItem);
                order.addOrderItem(orderItem);
            }
        }
        ArrayList settlements = null;
        try {
            settlements = EjbHelper.getOrderManager().findSettlementByOrderRequestId(orderRequestId.intValue());
        }
        catch (RemoteException rmiex) {
            throw new TmsBillingException("UsageReport:createOrder: RemoteException while finding settlements for Order Request ID :" + orderRequestId + ": Details :" + rmiex.toString());
        }
        catch (TmsGeneralException tmsge) {
            throw new TmsBillingException("UsageReport:createOrder: TmsGeneralException while finding settlements for Order Request ID :" + orderRequestId + ": Details :" + tmsge.toString());
        }
        catch (FinderException tmsge) {
            // empty catch block
        }
        if (settlements != null) {
            Iterator settlementIterator = settlements.iterator();
            while (settlementIterator.hasNext()) {
                SettlementData settlementData = (SettlementData)settlementIterator.next();
                Settlement settlement = this.convertSettlementDataToSettlement(settlementData);
                order.addSettlement(settlement);
            }
        }
        return order;
    }

    private Address convertAddressTypeDataToReportAddress(NCBAddressData ncbAddressDataToConvert) {
        Address addressToReturn = new Address();
        addressToReturn.setAddressType(TmsConst.NCB_ADDRESS_TYPE[ncbAddressDataToConvert.getAddressTypeId()]);
        addressToReturn.setStreetLine1(ncbAddressDataToConvert.getStreetLine1());
        addressToReturn.setStreetLine2(ncbAddressDataToConvert.getStreetLine2());
        addressToReturn.setStreetLine3(ncbAddressDataToConvert.getStreetLine3());
        addressToReturn.setCity(ncbAddressDataToConvert.getCity());
        addressToReturn.setStateProv(ncbAddressDataToConvert.getStateProv());
        addressToReturn.setPostalCode(ncbAddressDataToConvert.getPostalCode());
        addressToReturn.setCountryCode(ncbAddressDataToConvert.getCountryCode());
        addressToReturn.setPhoneNumber(ncbAddressDataToConvert.getPhoneNumber());
        addressToReturn.setFaxNumber(ncbAddressDataToConvert.getFaxNumber());
        addressToReturn.setEmail(ncbAddressDataToConvert.getEmail());
        return addressToReturn;
    }

    private Order convertOrderRequestDataToOrder(OrderRequestData orderRequestDataToConvert) {
        Order order = new Order();
        order.setStartDate(orderRequestDataToConvert.getStartDate());
        order.setEndDate(orderRequestDataToConvert.getEndDate());
        order.setInvoiceDate(orderRequestDataToConvert.getInvoiceDate());
        return order;
    }

    private OrderItem convertOrderRequestItemDataToOrderItem(OrderRequestItemData orderRequestItemDataToConvert) throws TmsBillingException {
        OrderItem orderItem = new OrderItem();
        Integer itemId = orderRequestItemDataToConvert.getItemId();
        String itemName = "";
        String itemCode = "";
        String itemServiceCode = "";
        try {
            ItemData itemData = EjbHelper.getServiceManager().findItemById(itemId);
            itemName = itemData.getName();
            itemCode = itemData.getCode();
            itemServiceCode = itemData.getServiceCode();
        }
        catch (RemoteException rmiex) {
            throw new TmsBillingException("UsageReport:convertOrderRequestItemDataToOrderItem: RemoteException while finding Item ID :" + itemId + ": Details :" + rmiex.toString());
        }
        catch (TmsBillingException tmsbex) {
            throw new TmsBillingException("UsageReport:convertOrderRequestItemDataToOrderItem: TmsBillingException while finding Item ID :" + itemId + ": Details :" + tmsbex.toString());
        }
        catch (TmsGeneralException tmsgex) {
            throw new TmsBillingException("UsageReport:convertOrderRequestItemDataToOrderItem: TmsGeneralException while finding Item ID :" + itemId + ": Details :" + tmsgex.toString());
        }
        catch (FinderException fndex) {
            throw new TmsBillingException("UsageReport:convertOrderRequestItemDataToOrderItem: TmsGeneralException while finding Item ID :" + itemId + ": Details :" + fndex.toString());
        }
        String serviceName = "";
        try {
            ServiceData serviceData = EjbHelper.getServiceManager().findServiceByCode(itemServiceCode);
            serviceName = serviceData.getName();
        }
        catch (RemoteException rmiex) {
            throw new TmsBillingException("UsageReport:convertOrderRequestItemDataToOrderItem: RemoteException while finding Service Code :" + itemServiceCode + ": Details :" + rmiex.toString());
        }
        catch (TmsBillingException tmsbex) {
            throw new TmsBillingException("UsageReport:convertOrderRequestItemDataToOrderItem: TmsBillingException while finding Service Code :" + itemServiceCode + ": Details :" + tmsbex.toString());
        }
        catch (TmsGeneralException tmsgex) {
            throw new TmsBillingException("UsageReport:convertOrderRequestItemDataToOrderItem: TmsGeneralException while finding Service Code :" + itemServiceCode + ": Details :" + tmsgex.toString());
        }
        catch (FinderException fndex) {
            throw new TmsBillingException("UsageReport:convertOrderRequestItemDataToOrderItem: TmsGeneralException while finding Service Code :" + itemServiceCode + ": Details :" + fndex.toString());
        }
        int itemQuantity = orderRequestItemDataToConvert.getQuantity();
        double ratingCost = orderRequestItemDataToConvert.getCost();
        double invoicedCost = ratingCost * (double)itemQuantity;
        orderItem.setName(itemName);
        orderItem.setCode(itemCode);
        orderItem.setServiceCode(itemServiceCode);
        orderItem.setServiceName(serviceName);
        orderItem.setQuantity(new Integer(itemQuantity));
        orderItem.setTransactionDateTime(orderRequestItemDataToConvert.getTimestamp());
        orderItem.setInvoiceCost(FormatHelper.moneyFormat(invoicedCost));
        orderItem.setRatingCost(FormatHelper.moneyFormat(ratingCost));
        orderItem.setServiceRequest(orderRequestItemDataToConvert.getServiceRequest());
        orderItem.setServiceResponse(orderRequestItemDataToConvert.getServiceResponse());
        orderItem.setServiceSessionId(orderRequestItemDataToConvert.getServiceSessionId());
        orderItem.setCustomerOnChargeRef(orderRequestItemDataToConvert.getCustomerOnChargeRef());
        orderItem.setDeliveryMethod(orderRequestItemDataToConvert.getDeliveryMethod());
        orderItem.setDeliveryTrackingRef(orderRequestItemDataToConvert.getDeliveryTrackingRef());
        orderItem.setVoucherPresented(orderRequestItemDataToConvert.getVoucherPresented());
        return orderItem;
    }

    private Settlement convertSettlementDataToSettlement(SettlementData settlementDataToConvert) throws TmsBillingException {
        Settlement settlement = new Settlement();
        Integer settlementId = settlementDataToConvert.getSettlementId();
        String settlementBrandName = "";
        try {
            ArrayList settlementBrands = EjbHelper.getOrderManager().findSettelmentBrands(settlementId);
            if (settlementBrands != null) {
                Iterator settlementBrandsIterator = settlementBrands.iterator();
                while (settlementBrandsIterator.hasNext()) {
                    SettlementBrandData currentSettlementBrandData = (SettlementBrandData)settlementBrandsIterator.next();
                    BrandData brandData = EjbHelper.getGeneralManager().findBrandById(currentSettlementBrandData.getBrandId());
                    if (!settlementBrandName.equals("")) {
                        settlementBrandName = String.valueOf(settlementBrandName) + " ";
                    }
                    settlementBrandName = String.valueOf(settlementBrandName) + brandData.getName();
                }
            }
        }
        catch (RemoteException rmiex) {
            throw new TmsBillingException("UsageReport:convertSettlementDataToSettlement: RemoteException while finding settlement brand name. Settlement ID :" + settlementId + ": Details :" + rmiex.toString());
        }
        catch (TmsBillingException tmsbex) {
            throw new TmsBillingException("UsageReport:convertSettlementDataToSettlement: TmsBillingException while finding settlement brand name. Settlement ID :" + settlementId + ": Details :" + tmsbex.toString());
        }
        catch (TmsGeneralException tmsgex) {
            throw new TmsBillingException("UsageReport:convertSettlementDataToSettlement: TmsGeneralException while finding settlement brand name. Settlement ID :" + settlementId + ": Details :" + tmsgex.toString());
        }
        catch (FinderException fndex) {
            throw new TmsBillingException("UsageReport:convertSettlementDataToSettlement: TmsGeneralException while finding settlement brand name. Settlement ID :" + settlementId + ": Details :" + fndex.toString());
        }
        settlement.setAmount(FormatHelper.moneyFormat(settlementDataToConvert.getAmount()));
        settlement.setBrandName(settlementBrandName);
        settlement.setCurrencyCode(settlementDataToConvert.getCurrencyCode());
        settlement.setTransactionDateTime(settlementDataToConvert.getTimeStamp());
        settlement.setReceipt(settlementDataToConvert.getReceipt());
        settlement.setSignature(settlementDataToConvert.getSignature());
        settlement.setCompletionRef(settlementDataToConvert.getCompletionRef());
        return settlement;
    }

    private Ncb convertNCBDataToNcb(NCBData ncbDataToConvert) {
        Ncb ncb = new Ncb();
        if (ncbDataToConvert.getNcbTypeId() != null) {
            ncb.setNcbType(NcbTypeType.valueOf(TmsConst.NCB_TYPE[ncbDataToConvert.getNcbTypeId()]).toString());
        } else {
            ncb.setNcbType(NcbTypeType.valueOf(TmsConst.NCB_TYPE[2]).toString());
        }
        ncb.setNamePrefix(ncbDataToConvert.getNamePrefix());
        ncb.setName(ncbDataToConvert.getName());
        ncb.setNameLast(ncbDataToConvert.getNameLast());
        ncb.setNameSuffix(ncbDataToConvert.getNameSuffix());
        ncb.setActive(new Boolean(ncbDataToConvert.getActive()));
        ncb.setLoginName(ncbDataToConvert.getLoginName());
        ncb.setOneOff(new Boolean(ncbDataToConvert.getOneOff()));
        return ncb;
    }
}

