/*
 * Decompiled with CFR 0.152.
 */
package nz.co.k.tms.billing.report;

import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.Iterator;
import javax.ejb.FinderException;
import nz.co.k.tms.billing.ejb.BrandData;
import nz.co.k.tms.billing.ejb.ItemData;
import nz.co.k.tms.billing.ejb.NCBAddressData;
import nz.co.k.tms.billing.ejb.NCBData;
import nz.co.k.tms.billing.ejb.NCBRoleData;
import nz.co.k.tms.billing.ejb.OrderRequestData;
import nz.co.k.tms.billing.ejb.OrderRequestItemData;
import nz.co.k.tms.billing.ejb.ServiceData;
import nz.co.k.tms.billing.ejb.SettlementBrandData;
import nz.co.k.tms.billing.ejb.SettlementData;
import nz.co.k.tms.exception.TmsBillingException;
import nz.co.k.tms.exception.TmsGeneralException;
import nz.co.k.tms.exception.TmsNoResultException;
import nz.co.k.tms.utility.EjbHelper;
import nz.co.k.tms.utility.FormatHelper;
import nz.co.k.tms.utility.LogHelper;
import nz.co.k.tms.utility.TmsConst;
import nz.co.k.tms.utility.XmlHelper;
import nz.co.k.tms.xml.report.billing.Address;
import nz.co.k.tms.xml.report.billing.ChildNcb;
import nz.co.k.tms.xml.report.billing.Ncb;
import nz.co.k.tms.xml.report.billing.Order;
import nz.co.k.tms.xml.report.billing.OrderItem;
import nz.co.k.tms.xml.report.billing.Role;
import nz.co.k.tms.xml.report.billing.Settlement;
import nz.co.k.tms.xml.report.billing.TmsBillingReport;
import nz.co.k.tms.xml.types.NcbAddressTypeType;
import nz.co.k.tms.xml.types.NcbTypeType;
import org.apache.log4j.Level;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.ValidationException;

public class BillingReport {
    private Integer dataFilterNcbId;
    private String dataFilterLoginName;
    private String dataFilterCustomerOnChargeRef;
    private String dataFilterServiceCode;
    private Date dataFilterInvoiceDate;
    private Date dataFilterStartDate;
    private Date dataFilterEndDate;
    private boolean dataFilterIncludeChildrenNcb;

    public BillingReport(Integer reportNcbId, String loginName, String customerOnChargeRef, String serviceCode, Date invoiceDate, Date startDateTime, Date endDateTime, boolean includeChildrenNcb) {
        this.dataFilterNcbId = reportNcbId;
        this.dataFilterLoginName = loginName;
        this.dataFilterCustomerOnChargeRef = customerOnChargeRef;
        this.dataFilterServiceCode = serviceCode;
        this.dataFilterInvoiceDate = invoiceDate;
        this.dataFilterStartDate = startDateTime;
        this.dataFilterEndDate = endDateTime;
        this.dataFilterIncludeChildrenNcb = includeChildrenNcb;
    }

    public String getReportXmlString() throws TmsBillingException, TmsNoResultException {
        if (this.dataFilterNcbId == null && this.dataFilterLoginName == null) {
            throw new TmsBillingException("Billing report failed. Could not find the NCB details as the required filters are all null.");
        }
        Ncb ncb = this.findNcb(this.dataFilterNcbId, this.dataFilterLoginName);
        if (ncb == null) {
            if (this.dataFilterNcbId == null) {
                throw new TmsNoResultException("Could not find a NCB with the ID :" + this.dataFilterNcbId);
            }
            throw new TmsNoResultException("Could not find a NCB with the Login Name :" + this.dataFilterLoginName);
        }
        TmsBillingReport tmsBillingReport = new TmsBillingReport();
        tmsBillingReport.addNcb(ncb);
        try {
            return XmlHelper.marshalTmsBillingReportMessage(tmsBillingReport);
        }
        catch (MarshalException me) {
            LogHelper.getBillingLogger().log(Level.ERROR, (Object)("BillingReport:getReportXmlString: MarshalException. Details :" + me.toString()));
            throw new TmsBillingException("BillingReport:getReportXmlString: MarshalException.Details :" + me.toString());
        }
        catch (ValidationException ve) {
            LogHelper.getBillingLogger().log(Level.ERROR, (Object)("BillingReport:getReportXmlString: ValidationException. Details :" + ve.toString()));
            throw new TmsBillingException("BillingReport:getReportXmlString: ValidationException. Details :" + ve.toString());
        }
    }

    private Ncb findNcb(Integer filterNcbId, String filterLoginName) throws TmsBillingException, TmsNoResultException {
        NCBData ncbData = null;
        try {
            if (filterNcbId != null) {
                ncbData = EjbHelper.getNCBManager().findNcbById(filterNcbId.intValue());
            } else if (filterLoginName != null) {
                ncbData = EjbHelper.getNCBManager().findNcbByLoginName(filterLoginName, true);
            }
        }
        catch (FinderException fndex) {
            if (this.dataFilterNcbId == null) {
                throw new TmsNoResultException("Could not find a NCB with the ID :" + filterNcbId);
            }
            throw new TmsNoResultException("Could not find a NCB with the Login Name :" + filterLoginName);
        }
        catch (RemoteException rmiex) {
            throw new TmsBillingException("BillingReport:findNcb: RemoteException. Finding NCB NCB ID :" + filterNcbId + ": Login :" + filterLoginName + ": Details :" + rmiex.toString());
        }
        catch (TmsGeneralException tmsgenex) {
            throw new TmsBillingException("BillingReport:findNcb: TmsGeneralException. Finding NCB NCB ID :" + filterNcbId + ": Login :" + filterLoginName + ": Details :" + tmsgenex.toString());
        }
        if (ncbData == null) {
            return null;
        }
        return this.createNcb(ncbData);
    }

    private Ncb createNcb(NCBData ncbData) throws TmsBillingException {
        Integer ncbId = ncbData.getNcbId();
        Ncb ncb = this.convertNCBDataToNcb(ncbData);
        try {
            Iterator rolesForNcbIterator;
            ArrayList rolesForNcb = EjbHelper.getNCBManager().findNcbRoleByNcb(ncbId.intValue());
            if (rolesForNcb != null && (rolesForNcbIterator = rolesForNcb.iterator()) != null) {
                while (rolesForNcbIterator.hasNext()) {
                    NCBRoleData roleData = (NCBRoleData)rolesForNcbIterator.next();
                    Role role = new Role();
                    role.setDescription(roleData.getRole());
                    ncb.addRole(role);
                }
            }
        }
        catch (RemoteException rmiex) {
            throw new TmsBillingException("BillingReport:createNcb: RemoteException. Finding NCB Roles. NCB ID :" + ncbData.getNcbId() + ": Details :" + rmiex.toString());
        }
        catch (TmsBillingException tmsblngex) {
            throw new TmsBillingException("BillingReport:createNcb: TmsBillingException. Finding NCB Roles. NCB ID :" + ncbData.getNcbId() + ": Details :" + tmsblngex.toString());
        }
        catch (TmsGeneralException tmsgenex) {
            throw new TmsBillingException("BillingReport:createNcb: TmsGeneralException. Finding NCB Roles. NCB ID :" + ncbData.getNcbId() + ": Details :" + tmsgenex.toString());
        }
        catch (FinderException fndex) {
            LogHelper.getBillingLogger().log(Level.DEBUG, (Object)("BillingReport:createNcb: FinderException. Finding NCB Roles. NCB ID :" + ncbData.getNcbId() + ": Details :" + fndex.toString()));
        }
        if (NcbAddressTypeType.enumerate() != null) {
            Enumeration ncbAddressTypeEnumeration = NcbAddressTypeType.enumerate();
            while (ncbAddressTypeEnumeration.hasMoreElements()) {
                NcbAddressTypeType currentNcbAddressTypeType = (NcbAddressTypeType)ncbAddressTypeEnumeration.nextElement();
                int addressTypeId = currentNcbAddressTypeType.getType();
                try {
                    NCBAddressData ncbAddressData = EjbHelper.getNCBManager().findNcbAddressByType(ncbId.intValue(), addressTypeId);
                    Address ncbAddress = this.convertAddressTypeDataToReportAddress(ncbAddressData);
                    ncb.addAddress(ncbAddress);
                }
                catch (RemoteException rmiex) {
                    throw new TmsBillingException("BillingReport:createNcb: RemoteException. Finding NCB Addresses. NCB ID :" + ncbData.getNcbId() + ": Type :" + currentNcbAddressTypeType.toString() + ": Details :" + rmiex.toString());
                }
                catch (TmsBillingException tmsblngex) {
                    throw new TmsBillingException("BillingReport:createNcb: TmsBillingException. Finding NCB Addresses. NCB ID :" + ncbData.getNcbId() + ": Type :" + currentNcbAddressTypeType.toString() + ": Details :" + tmsblngex.toString());
                }
                catch (TmsGeneralException tmsgenex) {
                    throw new TmsBillingException("BillingReport:createNcb: TmsGeneralException. Finding NCB Addresses. NCB ID :" + ncbData.getNcbId() + ": Type :" + currentNcbAddressTypeType.toString() + ": Details :" + tmsgenex.toString());
                }
                catch (FinderException fndex) {
                    LogHelper.getBillingLogger().log(Level.DEBUG, (Object)("BillingReport:createNcb: FinderException. Finding NCB Addresses. NCB ID :" + ncbData.getNcbId() + ": Type :" + currentNcbAddressTypeType.toString() + ": Details :" + fndex.toString()));
                }
            }
        }
        try {
            OrderRequestData orderRequest = EjbHelper.getOrderManager().findCurrentOrderRequestByNcb(ncbId.intValue());
            Order order = this.createOrder(orderRequest);
            if (order != null) {
                ncb.addOrder(order);
            }
        }
        catch (RemoteException rmiex) {
            throw new TmsBillingException("BillingReport:createNcb: RemoteException. Finding Order requests. NCB ID :" + ncbData.getNcbId() + ": Details :" + rmiex.toString());
        }
        catch (TmsBillingException tmsblngex) {
            throw new TmsBillingException("BillingReport:createNcb: TmsBillingException. Finding Order requests. NCB ID :" + ncbData.getNcbId() + ": Details :" + tmsblngex.toString());
        }
        catch (TmsGeneralException tmsgenex) {
            throw new TmsBillingException("BillingReport:createNcb: TmsGeneralException. Finding Order requests. NCB ID :" + ncbData.getNcbId() + ": Details :" + tmsgenex.toString());
        }
        catch (FinderException fndex) {
            LogHelper.getBillingLogger().log(Level.DEBUG, (Object)("BillingReport:createNcb: FinderException. Finding Order requests. NCB ID :" + ncbData.getNcbId() + ": Details :" + fndex.toString()));
        }
        if (this.dataFilterIncludeChildrenNcb) {
            ArrayList ncbChildren = null;
            try {
                ncbChildren = EjbHelper.getNCBManager().findNcbChildren(ncbId.intValue(), true);
            }
            catch (RemoteException rmiex) {
                throw new TmsBillingException("BillingReport:createNcb: RemoteException. Finding NCB Chidren. NCB ID :" + ncbData.getNcbId() + ": Details :" + rmiex.toString());
            }
            catch (TmsBillingException tmsblngex) {
                throw new TmsBillingException("BillingReport:createNcb: TmsBillingException. Finding NCB Chidren. NCB ID :" + ncbData.getNcbId() + ": Details :" + tmsblngex.toString());
            }
            catch (TmsGeneralException tmsgenex) {
                throw new TmsBillingException("BillingReport:createNcb: TmsGeneralException. Finding NCB Chidren. NCB ID :" + ncbData.getNcbId() + ": Details :" + tmsgenex.toString());
            }
            catch (FinderException fndex) {
                LogHelper.getBillingLogger().log(Level.DEBUG, (Object)("BillingReport:createNcb: FinderException. Finding NCB Chidren. NCB ID :" + ncbData.getNcbId() + ": Details :" + fndex.toString()));
            }
            if (ncbChildren != null && ncbChildren.size() != 0) {
                Iterator childrenIterator = ncbChildren.iterator();
                while (childrenIterator.hasNext()) {
                    NCBData currentNcbChildData = (NCBData)childrenIterator.next();
                    Ncb childNcbCreated = this.createNcb(currentNcbChildData);
                    ncb.addChildNcb(this.convertNcbtoChildNcb(childNcbCreated));
                }
            }
        }
        return ncb;
    }

    private Order createOrder(OrderRequestData orderRequest) throws TmsBillingException {
        if (orderRequest == null) {
            return null;
        }
        Integer orderRequestId = orderRequest.getOrderRequestId();
        if (this.dataFilterInvoiceDate != null && (orderRequest.getInvoiceDate() == null || orderRequest.getInvoiceDate().compareTo(this.dataFilterInvoiceDate) != 0)) {
            return null;
        }
        Order order = this.convertOrderRequestDataToOrder(orderRequest);
        ArrayList orderRequestItems = null;
        try {
            orderRequestItems = EjbHelper.getOrderManager().findOrderRequestItemByOrderRequestId(orderRequestId.intValue());
        }
        catch (RemoteException rmiex) {
            throw new TmsBillingException("BillingReport:createOrder: RemoteException while finding order items for Oreder Request ID :" + orderRequestId + ": Details :" + rmiex.toString());
        }
        catch (TmsGeneralException tmsge) {
            throw new TmsBillingException("BillingReport:createOrder: TmsGeneralException while finding order items for Oreder Request ID :" + orderRequestId + ": Details :" + tmsge.toString());
        }
        catch (FinderException tmsge) {
            // empty catch block
        }
        if (orderRequestItems != null) {
            Iterator orderItemIterator = orderRequestItems.iterator();
            while (orderItemIterator.hasNext()) {
                OrderRequestItemData orderRequestItem = (OrderRequestItemData)orderItemIterator.next();
                if (this.dataFilterStartDate != null && orderRequestItem.getTimestamp().compareTo(this.dataFilterStartDate) < 0 || this.dataFilterEndDate != null && orderRequestItem.getTimestamp().compareTo(this.dataFilterEndDate) > 0 || this.dataFilterCustomerOnChargeRef != null && (orderRequestItem.getCustomerOnChargeRef() == null || orderRequestItem.getCustomerOnChargeRef().toLowerCase().indexOf(this.dataFilterCustomerOnChargeRef.toLowerCase()) == -1)) continue;
                OrderItem orderItem = this.convertOrderRequestItemDataToOrderItem(orderRequestItem);
                if (this.dataFilterServiceCode != null && (orderItem.getServiceCode() == null || orderItem.getServiceCode().toLowerCase().indexOf(this.dataFilterServiceCode.toLowerCase()) == -1)) continue;
                order.addOrderItem(orderItem);
            }
        }
        ArrayList settlements = null;
        try {
            settlements = EjbHelper.getOrderManager().findSettlementByOrderRequestId(orderRequestId.intValue());
        }
        catch (RemoteException rmiex) {
            throw new TmsBillingException("BillingReport:createOrder: RemoteException while finding settlements for Order Request ID :" + orderRequestId + ": Details :" + rmiex.toString());
        }
        catch (TmsGeneralException tmsge) {
            throw new TmsBillingException("BillingReport:createOrder: TmsGeneralException while finding settlements for Order Request ID :" + orderRequestId + ": Details :" + tmsge.toString());
        }
        catch (FinderException tmsge) {
            // empty catch block
        }
        if (settlements != null) {
            Iterator settlementIterator = settlements.iterator();
            while (settlementIterator.hasNext()) {
                SettlementData settlementData = (SettlementData)settlementIterator.next();
                Settlement settlement = this.convertSettlementDataToSettlement(settlementData);
                order.addSettlement(settlement);
            }
        }
        return order;
    }

    private ChildNcb convertNcbtoChildNcb(Ncb ncbToConvert) {
        ChildNcb childNcbToReturn = new ChildNcb();
        childNcbToReturn.setNcbType(ncbToConvert.getNcbType());
        childNcbToReturn.setNamePrefix(ncbToConvert.getNamePrefix());
        childNcbToReturn.setName(ncbToConvert.getName());
        childNcbToReturn.setNameLast(ncbToConvert.getNameLast());
        childNcbToReturn.setNameSuffix(ncbToConvert.getNameSuffix());
        childNcbToReturn.setLoginName(ncbToConvert.getLoginName());
        childNcbToReturn.setOneOff(ncbToConvert.getOneOff());
        childNcbToReturn.setRole(ncbToConvert.getRole());
        childNcbToReturn.setAddress(ncbToConvert.getAddress());
        childNcbToReturn.setOrder(ncbToConvert.getOrder());
        childNcbToReturn.setChildNcb(ncbToConvert.getChildNcb());
        return childNcbToReturn;
    }

    private Address convertAddressTypeDataToReportAddress(NCBAddressData ncbAddressDataToConvert) {
        Address addressToReturn = new Address();
        addressToReturn.setAddressType(TmsConst.NCB_ADDRESS_TYPE[ncbAddressDataToConvert.getAddressTypeId()]);
        addressToReturn.setStreetLine1(ncbAddressDataToConvert.getStreetLine1());
        addressToReturn.setStreetLine2(ncbAddressDataToConvert.getStreetLine2());
        addressToReturn.setStreetLine3(ncbAddressDataToConvert.getStreetLine3());
        addressToReturn.setCity(ncbAddressDataToConvert.getCity());
        addressToReturn.setStateProv(ncbAddressDataToConvert.getStateProv());
        addressToReturn.setPostalCode(ncbAddressDataToConvert.getPostalCode());
        addressToReturn.setCountryCode(ncbAddressDataToConvert.getCountryCode());
        addressToReturn.setPhoneNumber(ncbAddressDataToConvert.getPhoneNumber());
        addressToReturn.setFaxNumber(ncbAddressDataToConvert.getFaxNumber());
        addressToReturn.setEmail(ncbAddressDataToConvert.getEmail());
        return addressToReturn;
    }

    private Order convertOrderRequestDataToOrder(OrderRequestData orderRequestDataToConvert) {
        Order order = new Order();
        order.setStartDate(orderRequestDataToConvert.getStartDate());
        order.setEndDate(orderRequestDataToConvert.getEndDate());
        order.setInvoiceDate(orderRequestDataToConvert.getInvoiceDate());
        return order;
    }

    private OrderItem convertOrderRequestItemDataToOrderItem(OrderRequestItemData orderRequestItemDataToConvert) throws TmsBillingException {
        OrderItem orderItem = new OrderItem();
        Integer itemId = orderRequestItemDataToConvert.getItemId();
        String itemName = "";
        String itemCode = "";
        String itemServiceCode = "";
        try {
            ItemData itemData = EjbHelper.getServiceManager().findItemById(itemId);
            itemName = itemData.getName();
            itemCode = itemData.getCode();
            itemServiceCode = itemData.getServiceCode();
        }
        catch (RemoteException rmiex) {
            throw new TmsBillingException("BillingReport:convertOrderRequestItemDataToOrderItem: RemoteException while finding Item ID :" + itemId + ": Details :" + rmiex.toString());
        }
        catch (TmsBillingException tmsbex) {
            throw new TmsBillingException("BillingReport:convertOrderRequestItemDataToOrderItem: TmsBillingException while finding Item ID :" + itemId + ": Details :" + tmsbex.toString());
        }
        catch (TmsGeneralException tmsgex) {
            throw new TmsBillingException("BillingReport:convertOrderRequestItemDataToOrderItem: TmsGeneralException while finding Item ID :" + itemId + ": Details :" + tmsgex.toString());
        }
        catch (FinderException fndex) {
            throw new TmsBillingException("BillingReport:convertOrderRequestItemDataToOrderItem: TmsGeneralException while finding Item ID :" + itemId + ": Details :" + fndex.toString());
        }
        String serviceName = "";
        try {
            ServiceData serviceData = EjbHelper.getServiceManager().findServiceByCode(itemServiceCode);
            serviceName = serviceData.getName();
        }
        catch (RemoteException rmiex) {
            throw new TmsBillingException("BillingReport:convertOrderRequestItemDataToOrderItem: RemoteException while finding Service Code :" + itemServiceCode + ": Details :" + rmiex.toString());
        }
        catch (TmsBillingException tmsbex) {
            throw new TmsBillingException("BillingReport:convertOrderRequestItemDataToOrderItem: TmsBillingException while finding Service Code :" + itemServiceCode + ": Details :" + tmsbex.toString());
        }
        catch (TmsGeneralException tmsgex) {
            throw new TmsBillingException("BillingReport:convertOrderRequestItemDataToOrderItem: TmsGeneralException while finding Service Code :" + itemServiceCode + ": Details :" + tmsgex.toString());
        }
        catch (FinderException fndex) {
            throw new TmsBillingException("BillingReport:convertOrderRequestItemDataToOrderItem: TmsGeneralException while finding Service Code :" + itemServiceCode + ": Details :" + fndex.toString());
        }
        int itemQuantity = orderRequestItemDataToConvert.getQuantity();
        double ratingCost = orderRequestItemDataToConvert.getCost();
        double invoicedCost = ratingCost * (double)itemQuantity;
        orderItem.setName(itemName);
        orderItem.setCode(itemCode);
        orderItem.setServiceCode(itemServiceCode);
        orderItem.setServiceName(serviceName);
        orderItem.setQuantity(new Integer(itemQuantity));
        orderItem.setTransactionDateTime(orderRequestItemDataToConvert.getTimestamp());
        orderItem.setInvoiceCost(FormatHelper.moneyFormat(invoicedCost));
        orderItem.setRatingCost(FormatHelper.moneyFormat(ratingCost));
        orderItem.setServiceRequest(orderRequestItemDataToConvert.getServiceRequest());
        orderItem.setServiceResponse(orderRequestItemDataToConvert.getServiceResponse());
        orderItem.setServiceSessionId(orderRequestItemDataToConvert.getServiceSessionId());
        orderItem.setCustomerOnChargeRef(orderRequestItemDataToConvert.getCustomerOnChargeRef());
        orderItem.setDeliveryMethod(orderRequestItemDataToConvert.getDeliveryMethod());
        orderItem.setDeliveryTrackingRef(orderRequestItemDataToConvert.getDeliveryTrackingRef());
        orderItem.setVoucherPresented(orderRequestItemDataToConvert.getVoucherPresented());
        return orderItem;
    }

    private Settlement convertSettlementDataToSettlement(SettlementData settlementDataToConvert) throws TmsBillingException {
        Settlement settlement = new Settlement();
        Integer settlementId = settlementDataToConvert.getSettlementId();
        String settlementBrandName = "";
        try {
            ArrayList settlementBrands = EjbHelper.getOrderManager().findSettelmentBrands(settlementId);
            if (settlementBrands != null) {
                Iterator settlementBrandsIterator = settlementBrands.iterator();
                while (settlementBrandsIterator.hasNext()) {
                    SettlementBrandData currentSettlementBrandData = (SettlementBrandData)settlementBrandsIterator.next();
                    BrandData brandData = EjbHelper.getGeneralManager().findBrandById(currentSettlementBrandData.getBrandId());
                    if (!settlementBrandName.equals("")) {
                        settlementBrandName = String.valueOf(settlementBrandName) + " ";
                    }
                    settlementBrandName = String.valueOf(settlementBrandName) + brandData.getName();
                }
            }
        }
        catch (RemoteException rmiex) {
            throw new TmsBillingException("BillingReport:convertSettlementDataToSettlement: RemoteException while finding settlement brand name. Settlement ID :" + settlementId + ": Details :" + rmiex.toString());
        }
        catch (TmsBillingException tmsbex) {
            throw new TmsBillingException("BillingReport:convertSettlementDataToSettlement: TmsBillingException while finding settlement brand name. Settlement ID :" + settlementId + ": Details :" + tmsbex.toString());
        }
        catch (TmsGeneralException tmsgex) {
            throw new TmsBillingException("BillingReport:convertSettlementDataToSettlement: TmsGeneralException while finding settlement brand name. Settlement ID :" + settlementId + ": Details :" + tmsgex.toString());
        }
        catch (FinderException fndex) {
            throw new TmsBillingException("BillingReport:convertSettlementDataToSettlement: TmsGeneralException while finding settlement brand name. Settlement ID :" + settlementId + ": Details :" + fndex.toString());
        }
        settlement.setAmount(FormatHelper.moneyFormat(settlementDataToConvert.getAmount()));
        settlement.setBrandName(settlementBrandName);
        settlement.setCurrencyCode(settlementDataToConvert.getCurrencyCode());
        settlement.setTransactionDateTime(settlementDataToConvert.getTimeStamp());
        settlement.setReceipt(settlementDataToConvert.getReceipt());
        settlement.setSignature(settlementDataToConvert.getSignature());
        settlement.setCompletionRef(settlementDataToConvert.getCompletionRef());
        return settlement;
    }

    private Ncb convertNCBDataToNcb(NCBData ncbDataToConvert) {
        Ncb ncb = new Ncb();
        if (ncbDataToConvert.getNcbTypeId() != null) {
            ncb.setNcbType(NcbTypeType.valueOf(TmsConst.NCB_TYPE[ncbDataToConvert.getNcbTypeId()]).toString());
        } else {
            ncb.setNcbType(NcbTypeType.valueOf(TmsConst.NCB_TYPE[2]).toString());
        }
        ncb.setNamePrefix(ncbDataToConvert.getNamePrefix());
        ncb.setName(ncbDataToConvert.getName());
        ncb.setNameLast(ncbDataToConvert.getNameLast());
        ncb.setNameSuffix(ncbDataToConvert.getNameSuffix());
        ncb.setActive(new Boolean(ncbDataToConvert.getActive()));
        ncb.setLoginName(ncbDataToConvert.getLoginName());
        ncb.setOneOff(new Boolean(ncbDataToConvert.getOneOff()));
        return ncb;
    }

    private ChildNcb convertNCBDataToChildNcb(NCBData ncbDataToConvert) {
        ChildNcb ncb = new ChildNcb();
        if (ncbDataToConvert.getNcbTypeId() != null) {
            ncb.setNcbType(NcbTypeType.valueOf(TmsConst.NCB_TYPE[ncbDataToConvert.getNcbTypeId()]).toString());
        } else {
            ncb.setNcbType(NcbTypeType.valueOf(TmsConst.NCB_TYPE[2]).toString());
        }
        ncb.setNamePrefix(ncbDataToConvert.getNamePrefix());
        ncb.setName(ncbDataToConvert.getName());
        ncb.setNameLast(ncbDataToConvert.getNameLast());
        ncb.setNameSuffix(ncbDataToConvert.getNameSuffix());
        ncb.setActive(new Boolean(ncbDataToConvert.getActive()));
        ncb.setLoginName(ncbDataToConvert.getLoginName());
        ncb.setOneOff(new Boolean(ncbDataToConvert.getOneOff()));
        return ncb;
    }
}

