/*
 * Decompiled with CFR 0.152.
 */
package nz.co.k.tms.billing.report;

import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import javax.ejb.FinderException;
import nz.co.k.tms.billing.ejb.AccountData;
import nz.co.k.tms.billing.ejb.BrandData;
import nz.co.k.tms.billing.ejb.ItemData;
import nz.co.k.tms.billing.ejb.NCBAddressData;
import nz.co.k.tms.billing.ejb.NCBData;
import nz.co.k.tms.billing.ejb.NCBRoleData;
import nz.co.k.tms.billing.ejb.OrderRequestData;
import nz.co.k.tms.billing.ejb.OrderRequestItemData;
import nz.co.k.tms.billing.ejb.ServiceData;
import nz.co.k.tms.billing.ejb.SettlementBrandData;
import nz.co.k.tms.billing.ejb.SettlementData;
import nz.co.k.tms.exception.TmsBillingException;
import nz.co.k.tms.exception.TmsGeneralException;
import nz.co.k.tms.exception.TmsNoResultException;
import nz.co.k.tms.utility.EjbHelper;
import nz.co.k.tms.utility.FormatHelper;
import nz.co.k.tms.utility.LogHelper;
import nz.co.k.tms.utility.TmsConst;
import nz.co.k.tms.utility.XmlHelper;
import nz.co.k.tms.xml.report.audit.Address;
import nz.co.k.tms.xml.report.audit.Ncb;
import nz.co.k.tms.xml.report.audit.NcbNoAccount;
import nz.co.k.tms.xml.report.audit.NcbNoBillingAddress;
import nz.co.k.tms.xml.report.audit.NonRatedItem;
import nz.co.k.tms.xml.report.audit.OrderItem;
import nz.co.k.tms.xml.report.audit.PartialSettledOrder;
import nz.co.k.tms.xml.report.audit.Role;
import nz.co.k.tms.xml.report.audit.Settlement;
import nz.co.k.tms.xml.report.audit.TmsAuditReport;
import nz.co.k.tms.xml.types.NcbAddressTypeType;
import nz.co.k.tms.xml.types.NcbTypeType;
import org.apache.log4j.Level;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.ValidationException;

public class AuditReport {
    public String getReportXmlString() throws TmsBillingException, TmsNoResultException {
        TmsAuditReport tmsAuditReport = new TmsAuditReport();
        tmsAuditReport = this.getNcbNoAccount(tmsAuditReport);
        tmsAuditReport = this.getNcbNoBillingAddress(tmsAuditReport);
        tmsAuditReport = this.getPartialSettledOrder(tmsAuditReport);
        if ((tmsAuditReport = this.getNonRatedIems(tmsAuditReport)).getNcbNoAccountCount() == 0 && tmsAuditReport.getNcbNoBillingAddressCount() == 0 && tmsAuditReport.getPartialSettledOrderCount() == 0 && tmsAuditReport.getNonRatedItemCount() == 0) {
            throw new TmsNoResultException("Could not find any Audit details.");
        }
        try {
            return XmlHelper.marshalTmsAuditReportMessage(tmsAuditReport);
        }
        catch (MarshalException me) {
            LogHelper.getBillingLogger().log(Level.ERROR, (Object)("AuditReport:getReportXmlString: MarshalException. Details :" + me.toString()));
            throw new TmsBillingException("AuditReport:getReportXmlString: MarshalException.Details :" + me.toString());
        }
        catch (ValidationException ve) {
            LogHelper.getBillingLogger().log(Level.ERROR, (Object)("AuditReport:getReportXmlString: ValidationException. Details :" + ve.toString()));
            throw new TmsBillingException("AuditReport:getReportXmlString: ValidationException. Details :" + ve.toString());
        }
    }

    private TmsAuditReport getNcbNoAccount(TmsAuditReport tmsAuditReportToAddTo) throws TmsBillingException {
        ArrayList ncbNoAccounts = null;
        try {
            ncbNoAccounts = EjbHelper.getNCBManager().findNcbNoAccount();
        }
        catch (RemoteException rmiex) {
            throw new TmsBillingException("AuditReport:getNcbNoAccount: RemoteException. Finding no accounts. : Details :" + rmiex.toString());
        }
        catch (TmsBillingException tmsblngex) {
            throw new TmsBillingException("AuditReport:getNcbNoAccount: TmsBillingException. Finding no accounts. : Details :" + tmsblngex.toString());
        }
        catch (TmsGeneralException tmsgenex) {
            throw new TmsBillingException("AuditReport:getNcbNoAccount: TmsGeneralException. Finding no accounts. : Details :" + tmsgenex.toString());
        }
        catch (FinderException fndex) {
            LogHelper.getBillingLogger().log(Level.DEBUG, (Object)("AuditReport:getNcbNoAccount: FinderException. Finding no accounts. : Details :" + fndex.toString()));
        }
        if (ncbNoAccounts != null) {
            Iterator ncbNoAccountIterator = ncbNoAccounts.iterator();
            while (ncbNoAccountIterator.hasNext()) {
                NCBData ncbData = (NCBData)ncbNoAccountIterator.next();
                Integer ncbId = ncbData.getNcbId();
                NcbNoAccount ncbNoAccount = this.convertNCBDataToNcbNoAccount(ncbData);
                try {
                    ArrayList roles = EjbHelper.getNCBManager().findNcbRoleByNcb(ncbId.intValue());
                    Iterator rolesForNcbIterator = roles.iterator();
                    while (rolesForNcbIterator.hasNext()) {
                        NCBRoleData roleData = (NCBRoleData)rolesForNcbIterator.next();
                        Role role = new Role();
                        role.setDescription(roleData.getRole());
                        ncbNoAccount.addRole(role);
                    }
                }
                catch (RemoteException rmiex) {
                    throw new TmsBillingException("AuditReport:getNcbNoAccount: RemoteException. Finding NCB Roles. NCB ID :" + ncbData.getNcbId() + ": Details :" + rmiex.toString());
                }
                catch (TmsBillingException tmsblngex) {
                    throw new TmsBillingException("AuditReport:getNcbNoAccount: TmsBillingException. Finding NCB Roles. NCB ID :" + ncbData.getNcbId() + ": Details :" + tmsblngex.toString());
                }
                catch (TmsGeneralException tmsgenex) {
                    throw new TmsBillingException("AuditReport:getNcbNoAccount: TmsGeneralException. Finding NCB Roles. NCB ID :" + ncbData.getNcbId() + ": Details :" + tmsgenex.toString());
                }
                catch (FinderException fndex) {
                    LogHelper.getBillingLogger().log(Level.DEBUG, (Object)("AuditReport:getNcbNoAccount: FinderException. Finding NCB Roles. NCB ID :" + ncbData.getNcbId() + ": Details :" + fndex.toString()));
                }
                if (NcbAddressTypeType.enumerate() != null) {
                    Enumeration ncbAddressTypeEnumeration = NcbAddressTypeType.enumerate();
                    while (ncbAddressTypeEnumeration.hasMoreElements()) {
                        NcbAddressTypeType currentNcbAddressTypeType = (NcbAddressTypeType)ncbAddressTypeEnumeration.nextElement();
                        int addressTypeId = currentNcbAddressTypeType.getType();
                        try {
                            NCBAddressData ncbAddressData = EjbHelper.getNCBManager().findNcbAddressByType(ncbId.intValue(), addressTypeId);
                            Address ncbAddress = this.convertAddressTypeDataToReportAddress(ncbAddressData);
                            ncbNoAccount.addAddress(ncbAddress);
                        }
                        catch (RemoteException rmiex) {
                            throw new TmsBillingException("AuditReport:getNcbNoAccount: RemoteException. Finding NCB Addresses. NCB ID :" + ncbData.getNcbId() + ": Type :" + currentNcbAddressTypeType.toString() + ": Details :" + rmiex.toString());
                        }
                        catch (TmsBillingException tmsblngex) {
                            throw new TmsBillingException("AuditReport:getNcbNoAccount: TmsBillingException. Finding NCB Addresses. NCB ID :" + ncbData.getNcbId() + ": Type :" + currentNcbAddressTypeType.toString() + ": Details :" + tmsblngex.toString());
                        }
                        catch (TmsGeneralException tmsgenex) {
                            throw new TmsBillingException("AuditReport:getNcbNoAccount: TmsGeneralException. Finding NCB Addresses. NCB ID :" + ncbData.getNcbId() + ": Type :" + currentNcbAddressTypeType.toString() + ": Details :" + tmsgenex.toString());
                        }
                        catch (FinderException fndex) {
                            LogHelper.getBillingLogger().log(Level.DEBUG, (Object)("AuditReport:getNcbNoAccount: FinderException. Finding NCB Addresses. NCB ID :" + ncbData.getNcbId() + ": Type :" + currentNcbAddressTypeType.toString() + ": Details :" + fndex.toString()));
                        }
                    }
                }
                if (ncbNoAccount == null) continue;
                tmsAuditReportToAddTo.addNcbNoAccount(ncbNoAccount);
            }
        }
        return tmsAuditReportToAddTo;
    }

    private TmsAuditReport getNcbNoBillingAddress(TmsAuditReport tmsAuditReportToAddTo) throws TmsBillingException {
        ArrayList ncbNoBillingAddresses = null;
        try {
            ncbNoBillingAddresses = EjbHelper.getNCBManager().findNcbNoBillingAddress();
        }
        catch (RemoteException rmiex) {
            throw new TmsBillingException("AuditReport:getNcbNoBillingAddress: RemoteException. Finding NCBs with no billing addresses. : Details :" + rmiex.toString());
        }
        catch (TmsBillingException tmsblngex) {
            throw new TmsBillingException("AuditReport:getNcbNoBillingAddress: TmsBillingException. Finding NCBs with no billing addresses. : Details :" + tmsblngex.toString());
        }
        catch (TmsGeneralException tmsgenex) {
            throw new TmsBillingException("AuditReport:getNcbNoBillingAddress: TmsGeneralException. Finding NCBs with no billing addresses. : Details :" + tmsgenex.toString());
        }
        catch (FinderException fndex) {
            LogHelper.getBillingLogger().log(Level.DEBUG, (Object)("AuditReport:getNcbNoBillingAddress: FinderException. Finding NCBs with no billing addresses. : Details :" + fndex.toString()));
        }
        if (ncbNoBillingAddresses != null) {
            Iterator ncbNoBillingAddressIterator = ncbNoBillingAddresses.iterator();
            while (ncbNoBillingAddressIterator.hasNext()) {
                Address ncbAddress;
                NCBAddressData ncbAddressData;
                NcbAddressTypeType currentNcbAddressTypeType;
                Enumeration ncbAddressTypeEnumeration;
                NCBData ncbData = (NCBData)ncbNoBillingAddressIterator.next();
                Integer ncbId = ncbData.getNcbId();
                NcbNoBillingAddress ncbNoBillingAddress = this.convertNCBDataToNcbNoBillingAddress(ncbData);
                try {
                    ArrayList roles = EjbHelper.getNCBManager().findNcbRoleByNcb(ncbId.intValue());
                    Iterator rolesForNcbIterator = roles.iterator();
                    while (rolesForNcbIterator.hasNext()) {
                        NCBRoleData roleData = (NCBRoleData)rolesForNcbIterator.next();
                        Role role = new Role();
                        role.setDescription(roleData.getRole());
                        ncbNoBillingAddress.addRole(role);
                    }
                }
                catch (RemoteException rmiex) {
                    throw new TmsBillingException("AuditReport:getNcbNoBillingAddress: RemoteException. Finding NCB Roles. NCB ID :" + ncbData.getNcbId() + ": Details :" + rmiex.toString());
                }
                catch (TmsBillingException tmsblngex) {
                    throw new TmsBillingException("AuditReport:getNcbNoBillingAddress: TmsBillingException. Finding NCB Roles. NCB ID :" + ncbData.getNcbId() + ": Details :" + tmsblngex.toString());
                }
                catch (TmsGeneralException tmsgenex) {
                    throw new TmsBillingException("AuditReport:getNcbNoBillingAddress: TmsGeneralException. Finding NCB Roles. NCB ID :" + ncbData.getNcbId() + ": Details :" + tmsgenex.toString());
                }
                catch (FinderException fndex) {
                    LogHelper.getBillingLogger().log(Level.DEBUG, (Object)("AuditReport:getNcbNoBillingAddress: FinderException. Finding NCB Roles. NCB ID :" + ncbData.getNcbId() + ": Details :" + fndex.toString()));
                }
                if (NcbAddressTypeType.enumerate() != null) {
                    ncbAddressTypeEnumeration = NcbAddressTypeType.enumerate();
                    while (ncbAddressTypeEnumeration.hasMoreElements()) {
                        currentNcbAddressTypeType = (NcbAddressTypeType)ncbAddressTypeEnumeration.nextElement();
                        int addressTypeId = currentNcbAddressTypeType.getType();
                        try {
                            ncbAddressData = EjbHelper.getNCBManager().findNcbAddressByType(ncbId.intValue(), addressTypeId);
                            ncbAddress = this.convertAddressTypeDataToReportAddress(ncbAddressData);
                            ncbNoBillingAddress.addAddress(ncbAddress);
                        }
                        catch (RemoteException rmiex) {
                            throw new TmsBillingException("AuditReport:getNcbNoBillingAddress: RemoteException. Finding NCB Addresses. NCB ID :" + ncbData.getNcbId() + ": Type :" + currentNcbAddressTypeType.toString() + ": Details :" + rmiex.toString());
                        }
                        catch (TmsBillingException tmsblngex) {
                            throw new TmsBillingException("AuditReport:getNcbNoBillingAddress: TmsBillingException. Finding NCB Addresses. NCB ID :" + ncbData.getNcbId() + ": Type :" + currentNcbAddressTypeType.toString() + ": Details :" + tmsblngex.toString());
                        }
                        catch (TmsGeneralException tmsgenex) {
                            throw new TmsBillingException("AuditReport:getNcbNoBillingAddress: TmsGeneralException. Finding NCB Addresses. NCB ID :" + ncbData.getNcbId() + ": Type :" + currentNcbAddressTypeType.toString() + ": Details :" + tmsgenex.toString());
                        }
                        catch (FinderException fndex) {
                            LogHelper.getBillingLogger().log(Level.DEBUG, (Object)("AuditReport:getNcbNoBillingAddress: FinderException. Finding NCB Addresses. NCB ID :" + ncbData.getNcbId() + ": Type :" + currentNcbAddressTypeType.toString() + ": Details :" + fndex.toString()));
                        }
                    }
                }
                if (NcbAddressTypeType.enumerate() != null) {
                    ncbAddressTypeEnumeration = NcbAddressTypeType.enumerate();
                    while (ncbAddressTypeEnumeration.hasMoreElements()) {
                        currentNcbAddressTypeType = (NcbAddressTypeType)ncbAddressTypeEnumeration.nextElement();
                        int addressTypeId = currentNcbAddressTypeType.getType();
                        try {
                            ncbAddressData = EjbHelper.getNCBManager().findNcbAddressByType(ncbId.intValue(), addressTypeId);
                            ncbAddress = this.convertAddressTypeDataToReportAddress(ncbAddressData);
                            ncbNoBillingAddress.addAddress(ncbAddress);
                        }
                        catch (RemoteException rmiex) {
                            throw new TmsBillingException("BillingReport:getNcbNoBillingAddress: RemoteException. Finding NCB Addresses. NCB ID :" + ncbData.getNcbId() + ": Details :" + rmiex.toString());
                        }
                        catch (TmsBillingException tmsblngex) {
                            throw new TmsBillingException("BillingReport:getNcbNoBillingAddress: TmsBillingException. Finding NCB Addresses. NCB ID :" + ncbData.getNcbId() + ": Details :" + tmsblngex.toString());
                        }
                        catch (TmsGeneralException tmsgenex) {
                            throw new TmsBillingException("BillingReport:getNcbNoBillingAddress: TmsGeneralException. Finding NCB Addresses. NCB ID :" + ncbData.getNcbId() + ": Details :" + tmsgenex.toString());
                        }
                        catch (FinderException fndex) {
                            LogHelper.getBillingLogger().log(Level.DEBUG, (Object)("BillingReport:getNcbNoBillingAddress: FinderException. Finding NCB Addresses. NCB ID :" + ncbData.getNcbId() + ": Details :" + fndex.toString()));
                        }
                    }
                }
                if (ncbNoBillingAddress == null) continue;
                tmsAuditReportToAddTo.addNcbNoBillingAddress(ncbNoBillingAddress);
            }
        }
        return tmsAuditReportToAddTo;
    }

    private TmsAuditReport getPartialSettledOrder(TmsAuditReport tmsAuditReportToAddTo) throws TmsBillingException {
        ArrayList partialSettledOrders = null;
        try {
            partialSettledOrders = EjbHelper.getOrderManager().findPartialSettledOrder();
        }
        catch (RemoteException rmiex) {
            throw new TmsBillingException("AuditReport:getPartialSettledOrder: RemoteException. Finding partialy settled Order Requests. : Details :" + rmiex.toString());
        }
        catch (TmsBillingException tmsblngex) {
            throw new TmsBillingException("AuditReport:getPartialSettledOrder: TmsBillingException. Finding partialy settled Order Requests. : Details :" + tmsblngex.toString());
        }
        catch (TmsGeneralException tmsgenex) {
            throw new TmsBillingException("AuditReport:getPartialSettledOrder: TmsGeneralException. Finding partialy settled Order Requests. : Details :" + tmsgenex.toString());
        }
        catch (FinderException fndex) {
            LogHelper.getBillingLogger().log(Level.DEBUG, (Object)("AuditReport:getPartialSettledOrder: FinderException. Finding partialy settled Order Requests. : Details :" + fndex.toString()));
        }
        if (partialSettledOrders != null) {
            Iterator partialSettledOrderIterator = partialSettledOrders.iterator();
            while (partialSettledOrderIterator.hasNext()) {
                OrderRequestData orderRequest = (OrderRequestData)partialSettledOrderIterator.next();
                Integer orderRequestId = orderRequest.getOrderRequestId();
                Integer accountId = orderRequest.getAccountId();
                PartialSettledOrder partialSettledOrder = this.convertOrderRequestDataToOrder(orderRequest);
                try {
                    ArrayList orderRequestItems = EjbHelper.getOrderManager().findOrderRequestItemByOrderRequestId(orderRequestId.intValue());
                    if (orderRequestItems != null) {
                        Iterator orderRequestItemsIterator = orderRequestItems.iterator();
                        while (orderRequestItemsIterator.hasNext()) {
                            OrderRequestItemData orderRequestItem = (OrderRequestItemData)orderRequestItemsIterator.next();
                            OrderItem orderItem = this.convertOrderRequestItemDataToOrderItem(orderRequestItem);
                            partialSettledOrder.addOrderItem(orderItem);
                        }
                    }
                }
                catch (RemoteException rmiex) {
                    throw new TmsBillingException("AuditReport:getPartialSettledOrder: RemoteException. Finding Order Request Items. OrderRequest ID :" + orderRequestId + ": Details :" + rmiex.toString());
                }
                catch (TmsBillingException tmsblngex) {
                    throw new TmsBillingException("AuditReport:getPartialSettledOrder: TmsBillingException. Finding Order Request Items. OrderRequest ID :" + orderRequestId + ": Details :" + tmsblngex.toString());
                }
                catch (TmsGeneralException tmsgenex) {
                    throw new TmsBillingException("AuditReport:getPartialSettledOrder: TmsGeneralException. Finding Order Request Items. OrderRequest ID :" + orderRequestId + ": Details :" + tmsgenex.toString());
                }
                catch (FinderException fndex) {
                    LogHelper.getBillingLogger().log(Level.DEBUG, (Object)("AuditReport:getPartialSettledOrder: FinderException. Finding Order Request Items. OrderRequest ID :" + orderRequestId + ": Details :" + fndex.toString()));
                }
                try {
                    ArrayList orderRequestSettlements = EjbHelper.getOrderManager().findSettlementByOrderRequestId(orderRequestId.intValue());
                    if (orderRequestSettlements != null) {
                        Iterator orderRequestSettlementsIterator = orderRequestSettlements.iterator();
                        while (orderRequestSettlementsIterator.hasNext()) {
                            SettlementData settlementData = (SettlementData)orderRequestSettlementsIterator.next();
                            Settlement settlement = this.convertSettlementDataToSettlement(settlementData);
                            partialSettledOrder.addSettlement(settlement);
                        }
                    }
                }
                catch (RemoteException rmiex) {
                    throw new TmsBillingException("AuditReport:getPartialSettledOrder: RemoteException. Finding Order Request Settlements. OrderRequest ID :" + orderRequestId + ": Details :" + rmiex.toString());
                }
                catch (TmsBillingException tmsblngex) {
                    throw new TmsBillingException("AuditReport:getPartialSettledOrder: TmsBillingException. Finding Order Request Settlements. OrderRequest ID :" + orderRequestId + ": Details :" + tmsblngex.toString());
                }
                catch (TmsGeneralException tmsgenex) {
                    throw new TmsBillingException("AuditReport:getPartialSettledOrder: TmsGeneralException. Finding Order Request Settlements. OrderRequest ID :" + orderRequestId + ": Details :" + tmsgenex.toString());
                }
                catch (FinderException fndex) {
                    LogHelper.getBillingLogger().log(Level.DEBUG, (Object)("AuditReport:getPartialSettledOrder: FinderException. Finding Order Request Settlements. OrderRequest ID :" + orderRequestId + ": Details :" + fndex.toString()));
                }
                AccountData accountData = null;
                try {
                    accountData = EjbHelper.getAccountManager().findAccountById(accountId);
                }
                catch (RemoteException rmiex) {
                    throw new TmsBillingException("AuditReport:getPartialSettledOrder: RemoteException. Finding Account. Account ID :" + accountId + ": Details :" + rmiex.toString());
                }
                catch (TmsBillingException tmsblngex) {
                    throw new TmsBillingException("AuditReport:getPartialSettledOrder: TmsBillingException. Finding Account. Account ID :" + accountId + ": Details :" + tmsblngex.toString());
                }
                catch (TmsGeneralException tmsgenex) {
                    throw new TmsBillingException("AuditReport:getPartialSettledOrder: TmsGeneralException. Finding Account. Account ID :" + accountId + ": Details :" + tmsgenex.toString());
                }
                catch (FinderException fndex) {
                    LogHelper.getBillingLogger().log(Level.DEBUG, (Object)("AuditReport:getPartialSettledOrder: FinderException. Finding Account. Account ID :" + accountId + ": Details :" + fndex.toString()));
                }
                if (accountData != null) {
                    Integer ncbId = accountData.getNcbId();
                    NCBData ncbData = null;
                    try {
                        ncbData = EjbHelper.getNCBManager().findNcbById(ncbId.intValue());
                    }
                    catch (RemoteException rmiex) {
                        throw new TmsBillingException("AuditReport:getPartialSettledOrder: RemoteException. Finding NCB. NCB ID :" + ncbId + ": Details :" + rmiex.toString());
                    }
                    catch (TmsBillingException tmsblngex) {
                        throw new TmsBillingException("AuditReport:getPartialSettledOrder: TmsBillingException. Finding NCB. NCB ID :" + ncbId + ": Details :" + tmsblngex.toString());
                    }
                    catch (TmsGeneralException tmsgenex) {
                        throw new TmsBillingException("AuditReport:getPartialSettledOrder: TmsGeneralException. Finding NCB. NCB ID :" + ncbId + ": Details :" + tmsgenex.toString());
                    }
                    catch (FinderException fndex) {
                        LogHelper.getBillingLogger().log(Level.DEBUG, (Object)("AuditReport:getPartialSettledOrder: FinderException. Finding NCB. NCB ID :" + ncbId + ": Details :" + fndex.toString()));
                    }
                    if (ncbData != null) {
                        Ncb partialSettledOrderNcb = this.convertNCBDataToNcb(ncbData);
                        try {
                            ArrayList roles = EjbHelper.getNCBManager().findNcbRoleByNcb(ncbId.intValue());
                            Iterator rolesForNcbIterator = roles.iterator();
                            while (rolesForNcbIterator.hasNext()) {
                                NCBRoleData roleData = (NCBRoleData)rolesForNcbIterator.next();
                                Role role = new Role();
                                role.setDescription(roleData.getRole());
                                partialSettledOrderNcb.addRole(role);
                            }
                        }
                        catch (RemoteException rmiex) {
                            throw new TmsBillingException("AuditReport:getPartialSettledOrder: RemoteException. Finding NCB Roles. NCB ID :" + ncbData.getNcbId() + ": Details :" + rmiex.toString());
                        }
                        catch (TmsBillingException tmsblngex) {
                            throw new TmsBillingException("AuditReport:getPartialSettledOrder: TmsBillingException. Finding NCB Roles. NCB ID :" + ncbData.getNcbId() + ": Details :" + tmsblngex.toString());
                        }
                        catch (TmsGeneralException tmsgenex) {
                            throw new TmsBillingException("AuditReport:getPartialSettledOrder: TmsGeneralException. Finding NCB Roles. NCB ID :" + ncbData.getNcbId() + ": Details :" + tmsgenex.toString());
                        }
                        catch (FinderException fndex) {
                            LogHelper.getBillingLogger().log(Level.DEBUG, (Object)("AuditReport:getPartialSettledOrder: FinderException. Finding NCB Roles. NCB ID :" + ncbData.getNcbId() + ": Details :" + fndex.toString()));
                        }
                        if (NcbAddressTypeType.enumerate() != null) {
                            Enumeration ncbAddressTypeEnumeration = NcbAddressTypeType.enumerate();
                            while (ncbAddressTypeEnumeration.hasMoreElements()) {
                                NcbAddressTypeType currentNcbAddressTypeType = (NcbAddressTypeType)ncbAddressTypeEnumeration.nextElement();
                                int addressTypeId = currentNcbAddressTypeType.getType();
                                try {
                                    NCBAddressData ncbAddressData = EjbHelper.getNCBManager().findNcbAddressByType(ncbId.intValue(), addressTypeId);
                                    Address ncbAddress = this.convertAddressTypeDataToReportAddress(ncbAddressData);
                                    partialSettledOrderNcb.addAddress(ncbAddress);
                                }
                                catch (RemoteException rmiex) {
                                    throw new TmsBillingException("AuditReport:getPartialSettledOrder: RemoteException. Finding NCB Addresses. NCB ID :" + ncbData.getNcbId() + ": Type :" + currentNcbAddressTypeType.toString() + ": Details :" + rmiex.toString());
                                }
                                catch (TmsBillingException tmsblngex) {
                                    throw new TmsBillingException("AuditReport:getPartialSettledOrder: TmsBillingException. Finding NCB Addresses. NCB ID :" + ncbData.getNcbId() + ": Type :" + currentNcbAddressTypeType.toString() + ": Details :" + tmsblngex.toString());
                                }
                                catch (TmsGeneralException tmsgenex) {
                                    throw new TmsBillingException("AuditReport:getPartialSettledOrder: TmsGeneralException. Finding NCB Addresses. NCB ID :" + ncbData.getNcbId() + ": Type :" + currentNcbAddressTypeType.toString() + ": Details :" + tmsgenex.toString());
                                }
                                catch (FinderException fndex) {
                                    LogHelper.getBillingLogger().log(Level.DEBUG, (Object)("AuditReport:getPartialSettledOrder: FinderException. Finding NCB Addresses. NCB ID :" + ncbData.getNcbId() + ": Type :" + currentNcbAddressTypeType.toString() + ": Details :" + fndex.toString()));
                                }
                            }
                        }
                        partialSettledOrder.addNcb(partialSettledOrderNcb);
                    }
                }
                if (partialSettledOrder == null) continue;
                tmsAuditReportToAddTo.addPartialSettledOrder(partialSettledOrder);
            }
        }
        return tmsAuditReportToAddTo;
    }

    private TmsAuditReport getNonRatedIems(TmsAuditReport tmsAuditReportToAddTo) throws TmsBillingException {
        ArrayList nonRatedItems = null;
        try {
            nonRatedItems = EjbHelper.getServiceManager().findNonRatedItems();
        }
        catch (RemoteException rmiex) {
            throw new TmsBillingException("AuditReport:getNonRatedIems: RemoteException. Finding non rated items. : Details :" + rmiex.toString());
        }
        catch (TmsBillingException tmsblngex) {
            throw new TmsBillingException("AuditReport:getNonRatedIems: TmsBillingException. Finding non rated items. : Details :" + tmsblngex.toString());
        }
        catch (TmsGeneralException tmsgenex) {
            throw new TmsBillingException("AuditReport:getNonRatedIems: TmsGeneralException. Finding non rated items. : Details :" + tmsgenex.toString());
        }
        catch (FinderException fndex) {
            LogHelper.getBillingLogger().log(Level.DEBUG, (Object)("AuditReport:getNonRatedIems: FinderException. Finding non rated items. : Details :" + fndex.toString()));
        }
        if (nonRatedItems != null) {
            Iterator itemIter = nonRatedItems.iterator();
            while (itemIter.hasNext()) {
                ItemData itemData = (ItemData)itemIter.next();
                NonRatedItem nonRatedItem = this.convertItemDataToNonRatedItem(itemData);
                tmsAuditReportToAddTo.addNonRatedItem(nonRatedItem);
            }
        }
        return tmsAuditReportToAddTo;
    }

    private NonRatedItem convertItemDataToNonRatedItem(ItemData itemDataToConvert) throws TmsBillingException {
        NonRatedItem nonRatedItem = new NonRatedItem();
        Integer itemId = itemDataToConvert.getItemId();
        String itemName = "";
        String itemCode = "";
        String itemServiceCode = "";
        try {
            ItemData itemData = EjbHelper.getServiceManager().findItemById(itemId);
            itemName = itemData.getName();
            itemCode = itemData.getCode();
            itemServiceCode = itemData.getServiceCode();
        }
        catch (RemoteException rmiex) {
            throw new TmsBillingException("AuditReport:convertItemDataToItem: RemoteException while finding Item ID :" + itemId + ": Details :" + rmiex.toString());
        }
        catch (TmsBillingException tmsbex) {
            throw new TmsBillingException("AuditReport:convertItemDataToItem: TmsBillingException while finding Item ID :" + itemId + ": Details :" + tmsbex.toString());
        }
        catch (TmsGeneralException tmsgex) {
            throw new TmsBillingException("AuditReport:convertItemDataToItem: TmsGeneralException while finding Item ID :" + itemId + ": Details :" + tmsgex.toString());
        }
        catch (FinderException fndex) {
            throw new TmsBillingException("AuditReport:convertItemDataToItem: TmsGeneralException while finding Item ID :" + itemId + ": Details :" + fndex.toString());
        }
        String serviceName = "";
        try {
            ServiceData serviceData = EjbHelper.getServiceManager().findServiceByCode(itemServiceCode);
            serviceName = serviceData.getName();
        }
        catch (RemoteException rmiex) {
            throw new TmsBillingException("AuditReport:convertItemDataToItem: RemoteException while finding Service Code :" + itemServiceCode + ": Details :" + rmiex.toString());
        }
        catch (TmsBillingException tmsbex) {
            throw new TmsBillingException("AuditReport:convertItemDataToItem: TmsBillingException while finding Service Code :" + itemServiceCode + ": Details :" + tmsbex.toString());
        }
        catch (TmsGeneralException tmsgex) {
            throw new TmsBillingException("AuditReport:convertItemDataToItem: TmsGeneralException while finding Service Code :" + itemServiceCode + ": Details :" + tmsgex.toString());
        }
        catch (FinderException fndex) {
            throw new TmsBillingException("AuditReport:convertItemDataToItem: TmsGeneralException while finding Service Code :" + itemServiceCode + ": Details :" + fndex.toString());
        }
        nonRatedItem.setName(itemName);
        nonRatedItem.setCode(itemCode);
        nonRatedItem.setServiceCode(itemServiceCode);
        nonRatedItem.setServiceName(serviceName);
        nonRatedItem.setItemProviderCost(FormatHelper.moneyFormat(itemDataToConvert.getItemProviderCharge()));
        return nonRatedItem;
    }

    private PartialSettledOrder convertOrderRequestDataToOrder(OrderRequestData orderRequestDataToConvert) {
        PartialSettledOrder order = new PartialSettledOrder();
        order.setStartDate(orderRequestDataToConvert.getStartDate());
        order.setEndDate(orderRequestDataToConvert.getEndDate());
        order.setInvoiceDate(orderRequestDataToConvert.getInvoiceDate());
        return order;
    }

    private OrderItem convertOrderRequestItemDataToOrderItem(OrderRequestItemData orderRequestItemDataToConvert) throws TmsBillingException {
        OrderItem orderItem = new OrderItem();
        Integer itemId = orderRequestItemDataToConvert.getItemId();
        String itemName = "";
        String itemCode = "";
        String itemServiceCode = "";
        try {
            ItemData itemData = EjbHelper.getServiceManager().findItemById(itemId);
            itemName = itemData.getName();
            itemCode = itemData.getCode();
            itemServiceCode = itemData.getServiceCode();
        }
        catch (RemoteException rmiex) {
            throw new TmsBillingException("AuditReport:convertOrderRequestItemDataToOrderItem: RemoteException while finding Item ID :" + itemId + ": Details :" + rmiex.toString());
        }
        catch (TmsBillingException tmsbex) {
            throw new TmsBillingException("AuditReport:convertOrderRequestItemDataToOrderItem: TmsBillingException while finding Item ID :" + itemId + ": Details :" + tmsbex.toString());
        }
        catch (TmsGeneralException tmsgex) {
            throw new TmsBillingException("AuditReport:convertOrderRequestItemDataToOrderItem: TmsGeneralException while finding Item ID :" + itemId + ": Details :" + tmsgex.toString());
        }
        catch (FinderException fndex) {
            throw new TmsBillingException("AuditReport:convertOrderRequestItemDataToOrderItem: TmsGeneralException while finding Item ID :" + itemId + ": Details :" + fndex.toString());
        }
        String serviceName = "";
        try {
            ServiceData serviceData = EjbHelper.getServiceManager().findServiceByCode(itemServiceCode);
            serviceName = serviceData.getName();
        }
        catch (RemoteException rmiex) {
            throw new TmsBillingException("AuditReport:convertOrderRequestItemDataToOrderItem: RemoteException while finding Service Code :" + itemServiceCode + ": Details :" + rmiex.toString());
        }
        catch (TmsBillingException tmsbex) {
            throw new TmsBillingException("AuditReport:convertOrderRequestItemDataToOrderItem: TmsBillingException while finding Service Code :" + itemServiceCode + ": Details :" + tmsbex.toString());
        }
        catch (TmsGeneralException tmsgex) {
            throw new TmsBillingException("AuditReport:convertOrderRequestItemDataToOrderItem: TmsGeneralException while finding Service Code :" + itemServiceCode + ": Details :" + tmsgex.toString());
        }
        catch (FinderException fndex) {
            throw new TmsBillingException("AuditReport:convertOrderRequestItemDataToOrderItem: TmsGeneralException while finding Service Code :" + itemServiceCode + ": Details :" + fndex.toString());
        }
        int itemQuantity = orderRequestItemDataToConvert.getQuantity();
        double ratingCost = orderRequestItemDataToConvert.getCost();
        double invoicedCost = ratingCost * (double)itemQuantity;
        orderItem.setName(itemName);
        orderItem.setCode(itemCode);
        orderItem.setServiceCode(itemServiceCode);
        orderItem.setServiceName(serviceName);
        orderItem.setQuantity(new Integer(itemQuantity));
        orderItem.setTransactionDateTime(orderRequestItemDataToConvert.getTimestamp());
        orderItem.setInvoiceCost(FormatHelper.moneyFormat(invoicedCost));
        orderItem.setRatingCost(FormatHelper.moneyFormat(ratingCost));
        orderItem.setServiceRequest(orderRequestItemDataToConvert.getServiceRequest());
        orderItem.setServiceResponse(orderRequestItemDataToConvert.getServiceResponse());
        orderItem.setServiceSessionId(orderRequestItemDataToConvert.getServiceSessionId());
        orderItem.setCustomerOnChargeRef(orderRequestItemDataToConvert.getCustomerOnChargeRef());
        orderItem.setDeliveryMethod(orderRequestItemDataToConvert.getDeliveryMethod());
        orderItem.setDeliveryTrackingRef(orderRequestItemDataToConvert.getDeliveryTrackingRef());
        orderItem.setVoucherPresented(orderRequestItemDataToConvert.getVoucherPresented());
        return orderItem;
    }

    private Settlement convertSettlementDataToSettlement(SettlementData settlementDataToConvert) throws TmsBillingException {
        Settlement settlement = new Settlement();
        Integer settlementId = settlementDataToConvert.getSettlementId();
        String settlementBrandName = "";
        try {
            ArrayList settlementBrands = EjbHelper.getOrderManager().findSettelmentBrands(settlementId);
            if (settlementBrands != null) {
                Iterator settlementBrandsIterator = settlementBrands.iterator();
                while (settlementBrandsIterator.hasNext()) {
                    SettlementBrandData currentSettlementBrandData = (SettlementBrandData)settlementBrandsIterator.next();
                    BrandData brandData = EjbHelper.getGeneralManager().findBrandById(currentSettlementBrandData.getBrandId());
                    if (!settlementBrandName.equals("")) {
                        settlementBrandName = String.valueOf(settlementBrandName) + " ";
                    }
                    settlementBrandName = String.valueOf(settlementBrandName) + brandData.getName();
                }
            }
        }
        catch (RemoteException rmiex) {
            throw new TmsBillingException("AuditReport:convertSettlementDataToSettlement: RemoteException while finding settlement brand name. Settlement ID :" + settlementId + ": Details :" + rmiex.toString());
        }
        catch (TmsBillingException tmsbex) {
            throw new TmsBillingException("AuditReport:convertSettlementDataToSettlement: TmsBillingException while finding settlement brand name. Settlement ID :" + settlementId + ": Details :" + tmsbex.toString());
        }
        catch (TmsGeneralException tmsgex) {
            throw new TmsBillingException("AuditReport:convertSettlementDataToSettlement: TmsGeneralException while finding settlement brand name. Settlement ID :" + settlementId + ": Details :" + tmsgex.toString());
        }
        catch (FinderException fndex) {
            throw new TmsBillingException("AuditReport:convertSettlementDataToSettlement: TmsGeneralException while finding settlement brand name. Settlement ID :" + settlementId + ": Details :" + fndex.toString());
        }
        settlement.setAmount(FormatHelper.moneyFormat(settlementDataToConvert.getAmount()));
        settlement.setBrandName(settlementBrandName);
        settlement.setCurrencyCode(settlementDataToConvert.getCurrencyCode());
        settlement.setTransactionDateTime(settlementDataToConvert.getTimeStamp());
        settlement.setReceipt(settlementDataToConvert.getReceipt());
        settlement.setSignature(settlementDataToConvert.getSignature());
        settlement.setCompletionRef(settlementDataToConvert.getCompletionRef());
        return settlement;
    }

    private NcbNoAccount convertNCBDataToNcbNoAccount(NCBData ncbDataToConvert) {
        NcbNoAccount ncb = new NcbNoAccount();
        if (ncbDataToConvert.getNcbTypeId() != null) {
            ncb.setNcbType(NcbTypeType.valueOf(TmsConst.NCB_TYPE[ncbDataToConvert.getNcbTypeId()]).toString());
        } else {
            ncb.setNcbType(NcbTypeType.valueOf(TmsConst.NCB_TYPE[2]).toString());
        }
        ncb.setNamePrefix(ncbDataToConvert.getNamePrefix());
        ncb.setName(ncbDataToConvert.getName());
        ncb.setNameLast(ncbDataToConvert.getNameLast());
        ncb.setNameSuffix(ncbDataToConvert.getNameSuffix());
        ncb.setActive(new Boolean(ncbDataToConvert.getActive()));
        ncb.setLoginName(ncbDataToConvert.getLoginName());
        ncb.setOneOff(new Boolean(ncbDataToConvert.getOneOff()));
        return ncb;
    }

    private NcbNoBillingAddress convertNCBDataToNcbNoBillingAddress(NCBData ncbDataToConvert) {
        NcbNoBillingAddress ncb = new NcbNoBillingAddress();
        if (ncbDataToConvert.getNcbTypeId() != null) {
            ncb.setNcbType(NcbTypeType.valueOf(TmsConst.NCB_TYPE[ncbDataToConvert.getNcbTypeId()]).toString());
        } else {
            ncb.setNcbType(NcbTypeType.valueOf(TmsConst.NCB_TYPE[2]).toString());
        }
        ncb.setNamePrefix(ncbDataToConvert.getNamePrefix());
        ncb.setName(ncbDataToConvert.getName());
        ncb.setNameLast(ncbDataToConvert.getNameLast());
        ncb.setNameSuffix(ncbDataToConvert.getNameSuffix());
        ncb.setActive(new Boolean(ncbDataToConvert.getActive()));
        ncb.setLoginName(ncbDataToConvert.getLoginName());
        ncb.setOneOff(new Boolean(ncbDataToConvert.getOneOff()));
        return ncb;
    }

    private Address convertAddressTypeDataToReportAddress(NCBAddressData ncbAddressDataToConvert) {
        Address addressToReturn = new Address();
        addressToReturn.setAddressType(TmsConst.NCB_ADDRESS_TYPE[ncbAddressDataToConvert.getAddressTypeId()]);
        addressToReturn.setStreetLine1(ncbAddressDataToConvert.getStreetLine1());
        addressToReturn.setStreetLine2(ncbAddressDataToConvert.getStreetLine2());
        addressToReturn.setStreetLine3(ncbAddressDataToConvert.getStreetLine3());
        addressToReturn.setCity(ncbAddressDataToConvert.getCity());
        addressToReturn.setStateProv(ncbAddressDataToConvert.getStateProv());
        addressToReturn.setPostalCode(ncbAddressDataToConvert.getPostalCode());
        addressToReturn.setCountryCode(ncbAddressDataToConvert.getCountryCode());
        addressToReturn.setPhoneNumber(ncbAddressDataToConvert.getPhoneNumber());
        addressToReturn.setFaxNumber(ncbAddressDataToConvert.getFaxNumber());
        addressToReturn.setEmail(ncbAddressDataToConvert.getEmail());
        return addressToReturn;
    }

    private Ncb convertNCBDataToNcb(NCBData ncbDataToConvert) {
        Ncb ncb = new Ncb();
        if (ncbDataToConvert.getNcbTypeId() != null) {
            ncb.setNcbType(NcbTypeType.valueOf(TmsConst.NCB_TYPE[ncbDataToConvert.getNcbTypeId()]).toString());
        } else {
            ncb.setNcbType(NcbTypeType.valueOf(TmsConst.NCB_TYPE[2]).toString());
        }
        ncb.setNamePrefix(ncbDataToConvert.getNamePrefix());
        ncb.setName(ncbDataToConvert.getName());
        ncb.setNameLast(ncbDataToConvert.getNameLast());
        ncb.setNameSuffix(ncbDataToConvert.getNameSuffix());
        ncb.setActive(new Boolean(ncbDataToConvert.getActive()));
        ncb.setLoginName(ncbDataToConvert.getLoginName());
        ncb.setOneOff(new Boolean(ncbDataToConvert.getOneOff()));
        return ncb;
    }
}

