import java.io.*;
import java.util.*;

/**
 * The class used to test the search algorithms
 * 
 *
 * @author Chang, Mei Yung (TONY)
 * @version 1.2
 */

public class test {

  public static void main(String[] args) {
    
    try {
      // variables for the search
      arpGraph graph_0, graph_1;
      
      Vector path, finalResult;
      
      // deserialize the objects
      
      FileInputStream fis = new FileInputStream("level_0");
      ObjectInputStream ois = new ObjectInputStream(fis);
      
      System.out.println("Reading the objects...");
      graph_0 = (arpGraph)ois.readObject();
      
      fis.close();
      ois.close();
      
      fis = new FileInputStream("level_1");
      ois = new ObjectInputStream(fis);
      
      graph_1 = (arpGraph)ois.readObject();
      
      System.out.println("Finish reading the objects...");
      fis.close();
      ois.close();
      
      // get rid of the south-western motorway
      arpNode temp;
      arpArc[] arcs;
      for (Enumeration e = graph_1.nodes.elements(); e.hasMoreElements();) {
        temp = (arpNode)e.nextElement();
        arcs = temp.getArcs();
        
        for (int i=0; i<arcs.length; i++) {
          if (arcs[i].getRoadName().equals("South-Western")) {
            graph_1.nodes.remove(new Integer(temp.getID()));
            break;
          }
        }
      }
      
      // The search part
      
      BufferedReader input = new BufferedReader( new InputStreamReader (System.in) );
      
      System.out.println("\nType \"q\" to quit the program.\n");
      
      while (true) {
        
        String buf = "";
        
        System.out.print("Pure AStar search '1' , Hierachical Search '2': ");
        buf = input.readLine();
        
        if (buf.equals("q")) {
          System.exit(0);
        }
        
        int boo = Integer.parseInt(buf);
        
        System.out.print("Please enter node number for the START: ");
        buf = input.readLine();
        
        if (buf.equals("q")) {
          System.exit(0);
        }
        
        int startID = Integer.parseInt(buf);
        
        System.out.print("Please enter node number for the GOAL: ");
        buf = input.readLine();
        
        if (buf.equals("q")) {
          System.exit(0);
        }
        
        int goalID = Integer.parseInt(buf);
        
        System.out.println("Searching...");
        System.out.println();
      
        Node start, goal;
      
        finalResult = new Vector();
        path = new Vector();
        
        if (boo == 1) {
          AStar as = new AStar(startID, goalID, graph_0, path, 1);
          as.run();
          Filter f = new Filter();
          path = f.filterResult(path);
          for (int i=0; i<path.size(); i++) {
    	      finalResult.add(path.elementAt(i));
          }
          finalResult.add(null);
        }
        else if (boo == 2) {
          HSearch hs = new HSearch(graph_0, graph_1, 1);
          start = hs.getNode(startID);
          goal = hs.getNode(goalID);
          hs.getPath(start, goal, finalResult);
        }
        
        //prints the path
        /*System.out.println();
        for (int i=path.size()-2; i>=0; i--) {
          tmp = (Node)path.elementAt(i);
          System.out.println("* " + tmp.getRoadName() + " " + tmp.getRoadType() + " suburb: " +  tmp.getSuburb() + " " + tmp.getDistance());
        }*/
        
        //prints the final result
        System.out.println();
        for (int i=0; i<finalResult.size()-1; i++) {
          FinalData fd = (FinalData)finalResult.elementAt(i);
          System.out.println(fd);
        }
        System.out.println();
      
      } //end while
    }
    catch(Exception e) {
      System.err.println("Test: Error: " + e);
    }
  }
}
