
import java.util.*;
import java.io.*;

/**
 * Data Structure uses to store the Graph
 * The object is specially design for the search method
 *
 * @author Mark Chan
 * @version 1.3
 */

public class arpGraph implements Serializable{

	public Hashtable arcs, nodes, islands, suburbs;
	private Vector suburb, island;
	float maxSegment;

	public arpGraph(){
		
		arcs = new Hashtable();
		nodes= new Hashtable();
 		suburbs = new Hashtable();
		islands = new Hashtable();
		island = new Vector();
		suburb = new Vector();
		maxSegment = 0;

	}

	public void putSuburb(Object key, Object value){

		suburbs.put(key,value);
	}

	public Vector getSuburb(String name){

		return (Vector)suburbs.get(name);
	}
		
	public void putArc(Object key, Object value){
		
		arcs.put(key, value);
	}

	public void putNode(Object key, Object value){
		
		nodes.put(key, value);
	}

	public void putIsland(Object key, Object value){
	
		islands.put(key, value);
		island.addElement(value);
	}

	public void putSuburb(String input){

		suburb.addElement(input);
	}

	public void putMaxSegment(float max){

		maxSegment = max;

	}

	public int arcSize(){
		return arcs.size();
	}

	public int nodeSize(){
		return nodes.size();
	}
		
        public int islandSize(){
		return islands.size();
	}
  
        public int suburbSize(){
		return suburbs.size();
	}

	public arpArc getArc(int id){

		return (arpArc)arcs.get(new Integer(id));
	}

	public arpNode getNode(int id){
		
		return (arpNode)nodes.get(new Integer(id));
	}

	public arpNode getIsland(int id){
	
		return (arpNode)islands.get(new Integer(id));

	}

	public Vector getIslands(){
	
		return island;
        }

	public Vector getSuburb(){
		
		return suburb;
	}

	public float getMaxSegment(){

		return maxSegment;

	}
}