
import java.io.*;

/**
 * Data Structure uses to store arc information extract from the database.
 * The object is specially design for the search method
 *
 * @author Mark Chan * @version 1.3
 */

public class arpArc implements Serializable {  

private String roadName, roadType, suburb;
private int id, fnode, tnode, status;
private float distance;

public arpArc(){}

public arpArc(int id, int fnode, int tnode, float distance, String roadName, String roadType, String suburb, int status){    
	
	this.id = id;
	this.fnode = fnode;   
	this.tnode = tnode;   
	this.distance = distance;
	this.roadName = roadName;
	this.roadType = roadType;
	this.suburb = suburb;
	this.status = status;
}


public String getRoadName(){ return roadName;}
public String getRoadType(){ return roadType;}
public String getFullName() { return roadName + " " + roadType;} 
public String getSuburb(){ return suburb;}
public int getId(){ return id;}
public int getFrom(){ return fnode;}
public int getTo(){ return tnode;}
public int getStatus(){ return status;}
public float getDistance(){ return distance;}

}

//end class