import java.lang.Math;

/**
 * This class contain only 1 static method
 * which is to compute the Heuristic estimate.
 * 
 * @author Chang, Mei Yung (TONY)
 * @version 1.0
 */

public class Heuristics {
  
  private static final int NO_HEURISTIC = 0;
  private static final int AIR_DISTANCE = 1;
  private static final int MANHATTAN = 2;
  
  // A static method which takes two node and a type as input.
  // Using the x and y coordinates of the two node to compute
  // the heuristc estimate based on the given type.
  public static double computeH(Node current, Node goal, int type) {
  
    double x = Math.abs( current.getX() - goal.getX() );
    double y = Math.abs( current.getY() - goal.getY() );
    
    if (type == AIR_DISTANCE) {
      return ( Math.sqrt( x*x + y*y ) );
    }
    else if (type == MANHATTAN) {
      return ( x + y );
    }
    else {
      return 0.0;
    }
  }
}
