
import java.util.*;

/**
 * The the Hierarchical search algorithm
 *
 * @author Chang, Mei Yung (TONY)
 * @version 1.2
 */

public class HSearch {
  
  private arpGraph graph_0;
  private arpGraph graph_1;
  private int type;
  
  public HSearch(arpGraph graph_0, arpGraph graph_1, int type) {
    this.graph_0 = graph_0;
    this.graph_1 = graph_1;
    this.type = type;
  }
  
  public Node getNode(int id){
    int level;
    String suburb;
    
    arpNode temp;
    arpArc[] arcs;
    
    Node node;
    
    if ((temp = graph_1.getNode(id)) != null) {
      level = 1;
    }
    else {
      temp = graph_0.getNode(id);
      level = 0;
    }
    
    node = new Node( temp.getID(), temp.getX(), temp.getY() );
    
    arcs = temp.getArcs();
    if (arcs.length != 0)
      suburb  = arcs[0].getSuburb();
    else
      suburb = "???";
    
    node.setSuburb(suburb);
    node.setLevel(level);
    
    return node;
  }
  
  public void getPath(Node start, Node goal, Vector result) {
  	Vector path = new Vector();
  	//Vector finalResult = new Vector();
  	
  	long startTime = System.currentTimeMillis();
  	
    path = HPath(start, goal, 0);
    
    long runTime = System.currentTimeMillis() - startTime;
    //System.out.println("runTime = " + runTime);
    //System.out.println();
    
    int len = 0;
    for (int i=0; i<path.size(); i++) {
    	len += ((Node)path.elementAt(i)).getDistance();
    }
    
    //System.out.println("len = " + len);
    
    /*int mlen = 0;
    int rlen = 0;
    for (int i=0; i<path.size()-1; i++) {
      Node t = (Node)path.elementAt(i);
      if (t.getRoadType().equals("Motorway")) {
        mlen += t.getDistance();
      }
      else {
        rlen += t.getDistance();
      }
    }
    System.out.println(mlen + " " +  rlen);*/
    
    // filtering
    Filter f = new Filter();
    path = f.filterResult(path);
    
    path.add(new Integer(len));
    
    for (int i=0; i<path.size(); i++) {
    	result.add(path.elementAt(i));
    }
  }
  
  private Vector HPath(Node start, Node goal, int level) {
    Vector path = new Vector();
    
    if (checkAdjacency(start, goal) || (level == 1)) {
      if (level == 0) {
        //System.out.println("Level 0 Search");
        //System.out.println("start: " + start.getNodeID() + " goal: " + goal.getNodeID());
        //System.out.println();
        AStar as = new AStar(start.getNodeID(), goal.getNodeID(), graph_0, path, 1);
        as.run();
      }
      else if (level == 1) {
        //System.out.println("Level 1 Search");
        //System.out.println("start: " + start.getNodeID() + " goal: " + goal.getNodeID());
        //System.out.println();
        AStar as = new AStar(start.getNodeID(), goal.getNodeID(), graph_1, path, 1);
        as.run();
      }
    }
    else if (start.getLevel() < goal.getLevel()) {
      // get closest node from next level and pop into the search
      //System.out.println("start < goal");
      Node next = getClosestNode(start, goal);
      path = HPath(next, goal, level+1);
      path = fixupPathToStart(start, path, level);
    }
    else if (start.getLevel() > goal.getLevel()) {
      // get closest node from next level and pop into the search
      //System.out.println("goal > start");
      Node next = getClosestNode(goal, start);
      path = HPath(start, next, level+1);
      path = fixupPathToGoal(goal, path, level);
    }
    else {
      //System.out.println("Both are in Lower level");
      
      Node snext = getClosestNode(start, goal);
      Node gnext = getClosestNode(goal, start);
      
      path = HPath(snext, gnext, level+1);
      
      /*for (int i=path.size()-2; i>=0; i--) {
        Node tmp = (Node)path.elementAt(i);
        System.out.println("* " + tmp.getRoadName() + " " + tmp.getRoadType() + " suburb: " + tmp.getSuburb());
      }*/
      
      path = fixupPathToStart(start, path, level);
      
      /*for (int i=path.size()-2; i>=0; i--) {
        Node tmp = (Node)path.elementAt(i);
        System.out.println("* " + tmp.getRoadName() + " " + tmp.getRoadType() + " suburb: " + tmp.getSuburb());
      }*/
      
      path = fixupPathToGoal(goal, path, level);
      
    }
    return path;
  }
  
  private boolean checkAdjacency(Node x, Node y) {
    //System.out.println("distance = " + Heuristics.computeH(x,y,1));
    if (Heuristics.computeH(x,y,1) > 10000) { // true
      return false;
    }
    else {
      return true;
    }
  }
  
  private Vector fixupPathToStart(Node start, Vector path, int level) {
    
    Vector fpath = new Vector();
    Vector startPath = new Vector();
    
    Node temp = null;
    
    int temPos=path.size()-1;
    
    String startSuburb = start.getSuburb();
    
    //System.out.println("size = " + path.size());
    for (int i=0; i<path.size()-1; i++) {
      temp = (Node)path.elementAt(i);
      String tempSuburb = temp.getSuburb();
      if (tempSuburb.equals(startSuburb)) {
        temPos = i;
        break;
      }
    }
    if (path.size() > 1) {
    if (level == 0) {
      //System.out.println("FixupStart 0");
      //System.out.println("start: " + start.getNodeID() + " goal: " + temp.getNodeID());
      //System.out.println();
      start.getNodeID();
      temp.getNodeID();
      AStar as = new AStar(start.getNodeID(), temp.getNodeID(), graph_0, startPath, 1);
      as.run();
    }
    else if (level == 1) {
      //System.out.println("FixupStart 1");
      //System.out.println("start: " + start.getNodeID() + " goal: " + temp.getNodeID());
      //System.out.println();
      AStar as = new AStar(start.getNodeID(), temp.getNodeID(), graph_1, startPath, 1);
      as.run();
    }
    }
    for (int i=0; i<temPos; i++) {
      fpath.add(path.elementAt(i));
    }
    for (int i=0; i<startPath.size(); i++) {
      fpath.add(startPath.elementAt(i));
    }
    
    return fpath;
  }
  
  private Vector fixupPathToGoal(Node goal, Vector path, int level) {
    
    Vector fpath = new Vector();
    Vector goalPath = new Vector();
    
    Node temp = null;
    
    int temPos=0;
    
    String goalSuburb = goal.getSuburb();
    
    for (int i=path.size()-2; i>=0; i--) {
      temp = (Node)path.elementAt(i);
      String tempSuburb = temp.getSuburb();
      if (tempSuburb.equals(goalSuburb)) {
        temPos = i;
        break;
      }
    }
    if (path.size() > 1) {
    if (level == 0) {
      //System.out.println("FixupGoal 0");
      //System.out.println("start: " + temp.getNodeID() + " goal: " + goal.getNodeID());
      //System.out.println();
      AStar as = new AStar(temp.getNodeID(), goal.getNodeID(), graph_0, goalPath, 1);
      as.run();
    }
    else if (level == 1) {
      //System.out.println("FixupGoal 1");
      //System.out.println("start: " + temp.getNodeID() + " goal: " + goal.getNodeID());
      //System.out.println();
      AStar as = new AStar(temp.getNodeID(), goal.getNodeID(), graph_1, goalPath, 1);
      as.run();
    }
    }
    for (int i=0; i<goalPath.size()-1; i++) {
      fpath.add(goalPath.elementAt(i));
    }
    for (int i=temPos; i<path.size(); i++) {
      fpath.add(path.elementAt(i));
    }
    
    return fpath;
  }
  
  private Node getClosestNode(Node node, Node end) {
    
    arpNode temp;
    arpArc[] arcs;
    Node minNode = new Node(0,0,0);
    Node tmpNode;
    double minDis = 999999;
    double d;
    
    PriorityVector pv = new PriorityVector();
    
    if (node.getLevel() == 0) {
      for (Enumeration e = graph_1.nodes.elements(); e.hasMoreElements();) {
        temp = (arpNode)e.nextElement();
        arcs = temp.getArcs();
        
        String suburb = arcs[0].getSuburb();
        int level = 1;
        
        tmpNode = new Node(temp.getID(), temp.getX(), temp.getY());
        
        d = Heuristics.computeH(node, tmpNode, 1);
        
        tmpNode.setLevel(level);
        tmpNode.setSuburb(suburb);
        tmpNode.setF(d);
        
        pv.add(tmpNode);
      }
    }
    
    for (int i=0; i<8; i++) {
      tmpNode = (Node)pv.remove();
      
      d = tmpNode.getF();
      d = Heuristics.computeH(tmpNode, end, 1) + d;
      
      if (d < minDis) {
        minDis = d;
        minNode = tmpNode;
      }
    }
    
    //System.out.println("minNode: " + minNode.getNodeID());
    return minNode;
  }
}