import java.util.Vector;

/**
 * Class used to filter the raw result
 * and stores it into the finalResult
 * 
 * @author Chang, Mei Yung (TONY)
 * @version 1.0
 */

public class Filter {

  public Vector filterResult(Vector path) { 

        Vector finalResult = new Vector();

        int j = 0;
		
        if (path.size() > 0) {
		  j = path.size()-2;
        }

        float len = 0;
        String road, type, suburb;
        Node tmp;
        
        
        tmp = (Node)path.elementAt(j--);
        len = tmp.getDistance();
        road = tmp.getRoadName();
        type = tmp.getRoadType();
        suburb = tmp.getSuburb();
        
        while (j >= 0) {
          tmp = (Node)path.elementAt(j);
          
          if ( tmp.getRoadName().equals(road) ) {
            len += tmp.getDistance();
          }
          else {
            finalResult.add(new FinalData(road, type, suburb, len));
            len = 0;
            len += tmp.getDistance();
          }
          
          road = tmp.getRoadName();
          type = tmp.getRoadType();
          suburb = tmp.getSuburb();
          
          j--;
        }
        finalResult.add(new FinalData(road, type, suburb, len));

        return finalResult;
  }
}
