package arpClasses.Serialize;
import java.sql.*;

public class SQLConn{

  protected boolean connected = false;
  private Connection con;
  private String driverName = "org.gjt.mm.mysql.Driver";
  private String dbName = "jdbc:mysql://localhost:3306/IT";

  private static SQLConn instance = new SQLConn();
  
  public SQLConn() {
  
  }
  
  public static SQLConn getInstance() {
    return instance;
  }

  public boolean connect() throws Exception {
    if (connected)
      return true;
    else {
      Class.forName(driverName);
      con = DriverManager.getConnection(dbName);
      con.setAutoCommit(true);
      connected = true;
      return true;

    }
	
  }

  public void disconnect() throws Exception {
    con.close();
    connected = false;
  }
  
  public boolean isConnected() {
	  return connected;
  }

  public synchronized void execute(String sql) throws Exception {
    Statement stmt = con.createStatement();
    stmt.execute(sql);
  }
  
  public synchronized ResultSet executeQuery(String sql) throws Exception {
    Statement stmt = con.createStatement();
    ResultSet rs = stmt.executeQuery(sql);
    return rs;
  }
  
  public synchronized void setAutoCommit(boolean status) throws Exception {
    con.setAutoCommit(status);
  }
  
  public synchronized void commit() throws Exception {
    con.commit();
  }
  
  public synchronized void rollback() throws Exception {
    con.rollback();
  }
}