package arpClasses.Search;

import java.util.Vector;
import java.util.Hashtable;

/**
 * Data Structure used as the OPEN list for the A* Search
 * 
 * @author Chang, Mei Yung (TONY)
 * @version 1.1
 */

public class PriorityVector {
  
  private Vector data;
  
  public PriorityVector() {
    data = new Vector();
  }
  
  public Node peek() {
  // pre: !isEmpty()
  // post: returns the minimum value in the priority queue
    return (Node)data.elementAt( size() - 1 );
  }
  
  public Node remove() {
  // pre: !isEmpty()
  // post: removes and returns minimum value in priority queue
    Node result = (Node)data.elementAt( size() - 1 );
    data.removeElementAt( size() - 1 );
    return result;
  }
  
  public void add(Node value) {
  // pre: value is non-null
  // post: inserts value in priority queue
  //       leaves elements in order
    int position = indexOf((Comparable)value);
    data.insertElementAt(value,position);
  }
  
  protected int indexOf(Comparable target) {
  // pre: value is a non-null comparable object
  // post: returns ideal position of value in vector
    Comparable midValue;
    int low = 0;  // lowest possible location
    int high = data.size(); // highest possible location
    int mid = (low + high)/2; // low <= mid <= high
    // mid == high iff low == high
    while (low < high) {
      midValue = (Comparable)data.elementAt(mid);
      if (midValue.compareTo(target) > 0) {
        low = mid+1;
      }
      else {
        high = mid;
      }
      mid = (low+high)/2;
    }
    return low;
  }
  
  public int findNode(int nodeID) {
  // post: returns position of the element in the queue
    Node temp;
    for (int i=0; i<data.size(); i++) {
      temp = (Node) data.elementAt(i);
      if ( temp.getNodeID() == nodeID )
        return i;
    }
    return -1;
  }
  
  public Node elementAt(int index) {
  // post: returns element of the given index
    return (Node)data.elementAt(index);
  }
  
  public void removeElement(Node obj) {
  // post: removes element of the given index
    data.removeElement(obj);
  } 
  
  public boolean isEmpty() {
  // post: returns true iff the priority queue is empty
    return data.size() == 0;
  }

  public int size() {
  // post: returns number of elements in priority queue 
    return data.size();
  }

  public void clear() {
  // post: removes all elements from priority queue.
    data.clear();
  }

  public String toString() {
  // post: returns string representation of priority vector
    return "<PriorityVector: "+data+">";
  }
}