package arpClasses.Search;

/**
 * Data Structure uses to store the Node information.
 * 
 * @author Chang, Mei Yung (TONY)
 * @version 1.1
 */

public class Node implements Comparable {

  private int ID;
  private Node parent;
  private double x, y;
  private double f, g;
  private float distance;
  private String roadName;
  private String roadType;
  private int level;
  private String suburb;
  
  public Node(int ID, double x, double y) {
    this.ID = ID;
    this.x = x;
    this.y = y;
    parent = null;
    f = 0;
    g = 0;
    distance = 0;
    roadName = "";
  }
  
  // This overrides the compareTo() in the comparable interface
  // comparing two node based on the f value
  public int compareTo(Object object) {
    Node node = (Node)object;
    double thisF = this.f;
    double otherF = node.getF();
    
    if (thisF < otherF)
      return -1;
    else if (thisF > otherF)
      return 1;
    else
      return 0;
  }
  
  // All the set methods.
  public void setParent(Node parent) {
    this.parent = parent;
  }
  
  public void setNodeID(int value) {
    ID = value;
  }
  
  public void setX(double value) {
    x = value;
  }
  
  public void setY(double value) {
    y = value;
  }
  
  public void setF(double value) {
    f = value;
  }
  
  public void setG(double value) {
    g = value;
  }
  
  public void setDistance(float value) {
    distance = value;
  }
  
  public void setRoadName(String name) {
    roadName = name;
  }
  
  public void setRoadType(String type) {
    roadType = type;
  }
  
  public void setLevel(int level) {
    this.level = level;
  }
  
  public void setSuburb(String suburb) {
    this.suburb = suburb;
  }
  
  // All the get methods.
  public int getNodeID() {
    return ID;
  }
  
  public Node getParent() {
    return parent;
  }
  
  public double getX() {
    return x;
  }
  
  public double getY() {
    return y;
  }
  
  public double getF() {
    return f;
  }
  
  public double getG() {
    return g;
  }
  
  public float getDistance() {
    return distance;
  }
  
  public String getRoadName() {
    return roadName;
  }
  
  public String getRoadType() {
    return roadType;
  }
  
  public int getLevel() {
    return level;
  }
  
  public String getSuburb() {
    return suburb;
  }
}