package arpClasses.Search;
import arpClasses.Serialize.*;
import java.util.*;
import java.lang.Math;

/*******************
*
* 2002 IT Double Semester Project -- ARP
*
* Author: Mark Chan
* UPI: ccha196
*
* Description: This program is used to searh the route using islands.
*	       It implies the A* search algorithm developed by Tony.
*	       Island search algorithm breaks the search into parts so
*	       so that the search space is much smaller. It is believed 
*	       to be much faster.
*
* Version: 1.0
*
********************/



public class ISearch {

  private int start;
  private int goal;
  private arpGraph graph;
  
  public ISearch(int start, int goal, arpGraph graph){

 	this.start = start;
	this.goal = goal;
	this.graph = graph;
  }

  public void start(Vector four){

      
	boolean use = false;
	Vector one = new Vector();
	Vector two = new Vector();
	Vector three = new Vector();
	Vector tmpfour = new Vector();
	
	String previous = "**";
	use = HBridge(start, goal);
	
	if(use == true){
		  int b = isNorth(start);
		  if(b == 1){
	      two = findRoute(start, 8218);
	      one = findRoute(8218, goal);
		for(int i=0; i < one.size(); i++){
		Node ans = (Node)one.elementAt(i);
		String s = ans.getRoadName();	
		if( s.equals("") != true){
			three.addElement(ans);
		}
            }
		
	   
	    for(int i=1; i < two.size(); i++){
		Node ans = (Node)two.elementAt(i);
		String s = ans.getRoadName();	
		if( s.equals("") != true){
			three.addElement(ans);
		}
		//System.out.print(ans.getRoadName() + " --> ");
            }
		  } 
		  else{
			one = findRoute(start, 8218);
		  	two = findRoute(8218, goal);
			for(int i=1; i < two.size(); i++){
			  Node ans = (Node)two.elementAt(i);
			  String s = ans.getRoadName();	
			  if( s.equals("") != true){
			    three.addElement(ans);
			  }
		        } 
			for(int i=1; i < one.size(); i++){
			   Node ans = (Node)one.elementAt(i);
			   String s = ans.getRoadName();	
			   if( s.equals("") != true){
			     three.addElement(ans);
			   }
		         } 
		  	
		  }
	    
	}

	else{
	    one = findRoute(start, goal);
	    for(int i=0; i < one.size(); i++){
		Node ans = (Node)one.elementAt(i);
		String s = ans.getRoadName();	
		if( s.equals("") != true){
			three.addElement(ans);
		}
		//System.out.print(ans.getRoadName() + " --> ");
            }
	}
	

	three.addElement(null);
	System.out.println();
	Filter f = new Filter();	
	tmpfour = f.filterResult(three);
	float len = 0;
	for(int i=0; i < tmpfour.size(); i++){
		FinalData ans = (FinalData)tmpfour.elementAt(i);
		four.addElement(ans);
		len = len + ans.getLen();
	}
  four.addElement(new Integer((int)len));
	System.out.println(len);
	
	//return four;

  }

  // This method is use to find the route using island
  // It has the following steps: 
  //    1) find suitable islands for island set
  //    2) determine island set
  // 	3) Run A* algorithm
  //    4) combine answers
  private Vector findRoute(int start, int goal){

            // Find suitable islands for island set
	Vector cache = new Vector();
        Vector islands = new Vector();
	islands = findIsland(start, goal);
	System.out.println("suitable islands no: " + islands.size());

	    // Determine island set
	Vector island_set = new Vector();
	island_set = ISet(start, goal, islands);
	System.out.println("island set size: " + island_set.size());

	    // Run A* Algorithm
	Vector fin = new Vector();
	
	for(int i=0; i < island_set.size()-1; i++){
	    arpNode temp1 = (arpNode)island_set.elementAt(i);
	    arpNode temp2 = (arpNode)island_set.elementAt(i+1);
	    //System.out.println(temp1.getID() + "--> " + temp2.getID());
	    Vector mark = new Vector();
	    AStar as = new AStar( temp1.getID(), temp2.getID(), graph, mark, 1);
	    as.run();
	    for(int y = mark.size()-1; y >= 0; y--){
		
		Node name = (Node)mark.elementAt(y);
		fin.addElement(name);
		
	    }
	   
	   
	}
		// Print results
	System.out.println();
	int direction = get_direction(start, goal);
        if( direction == 1 || direction == 3){
	   for( int i =0; i < fin.size(); i++){
		Node name = (Node)fin.elementAt(i);
		cache.addElement(name);
		//System.out.print( name.getRoadName() + " --> " );
	   }
	}else{
	    for( int i =fin.size()-1; i >=0; i--){
		Node name = (Node)fin.elementAt(i);
		cache.addElement(name);
		//System.out.print( name.getRoadName() + " --> " );
	   }
	}
        
	
	System.out.println();
	//System.out.println("direction = " + direction);
	return cache;

  }

	// This method is used to determine the island set
  private Vector ISet(int start, int goal, Vector islands){
	
	int direction = 0;
       
	Vector cache = new Vector();
        
	arpNode start_node = graph.getNode(start);
	arpNode goal_node = graph.getNode(goal);
    /*
	int sx = start_node.getX();
	int sy = start_node.getY();
	
	int gx = goal_node.getX();
	int gy = goal_node.getY();
	if( sx <= gx && sy <= gy){ direction = 1;}
	if( sx <= gx && sy >= gy){ direction = 2;}
	if( sx >= gx && sy <= gy){ direction = 3;}
	if( sx >= gx && sy >= gy){ direction = 4;}
	*/
        direction = get_direction(start, goal);
	if( direction == 1){
 		System.out.println("*** In Direction 1 ***");
		cache.addElement(goal_node);
		int closest = 0;
		closest = find_closest( goal,start, islands,1);
		while ( closest != start){
			
			arpNode temp = graph.getNode(closest);
			cache.addElement(temp);
			closest = find_closest(closest,start, islands,1);
			
		}
		arpNode temp = graph.getNode(closest);
		cache.addElement(temp);
		
	}
	if( direction == 2){
		System.out.println("*** In Direction 2 ***");
		cache.addElement(start_node);
		int closest = 0;
		closest = find_closest( start,goal, islands,2);
		while ( closest != goal){
			
			arpNode temp = graph.getNode(closest);
			cache.addElement(temp);
			closest = find_closest(closest,goal, islands,2);
			
		}
		arpNode temp = graph.getNode(closest);
		cache.addElement(temp);
		
	}
	if(direction == 3){
		System.out.println("*** In Direction 3 ***");
		cache.addElement(goal_node);
		int closest = 0;
		closest = find_closest( goal,start, islands,2);
		while ( closest != start){
			arpNode temp = graph.getNode(closest);
			cache.addElement(temp);
			closest = find_closest(closest,start, islands,2);
			
		}
		arpNode temp = graph.getNode(closest);
		cache.addElement(temp);
	}
	if( direction == 4){
		System.out.println("*** In Direction 4 ***");
		cache.addElement(start_node);
		int closest = 0;
		closest = find_closest( start,goal, islands,1);
		while ( closest != goal){
			
			arpNode temp = graph.getNode(closest);
			cache.addElement(temp);
			closest = find_closest(closest,goal, islands,1);
			
		}
		arpNode temp = graph.getNode(closest);
		cache.addElement(temp);
		
	}
	return cache;
	

  }
     // THis method search the closest node in the direction from
     //  top-left to bottom-right
  private int find_closest(int closest, int end, Vector islands, int option){

	int output = 0;
	arpNode start_node = graph.getNode(closest);
	int sx = start_node.getX();
	int sy = start_node.getY();
	arpNode end_node = graph.getNode(end);
	int ex = end_node.getX();
	int ey = end_node.getY();
        float min = 1000000000;
	for(int i=0; i< islands.size(); i++){
		arpNode a = (arpNode)islands.elementAt(i);
		int x = a.getX();
		int y = a.getY();
		if( a.getID() != closest){
		     if( option == 1){
			if ( x <= sx && x >= ex && y <= sy && y >= ey){
				float dist = calDist(start_node, a);
				if( dist < min){
					min = dist;
					output = a.getID();
				}
			}
		     }
		     if( option ==2){
			if ( x >= sx && x <= ex && y <= sy && y >= ey){
				float dist = calDist(start_node, a);
				if( dist < min){
					min = dist;
					output = a.getID();
				}
			}
		     }
		}
	}
	return output;			
        

  }

  // This method calculates the the distance between two nodes
  private float calDist(arpNode a, arpNode b){

	float x = a.getX() - b.getX();
	float y = a.getY() - b.getY();
	return (float)Math.sqrt( x*x + y*y );
  }

  // This method select all the islands inside the rectangle 
  // formed by start and goal nodes at each corners. These selected
  // islands are potential islands for island set
  private Vector findIsland(int start, int goal){

	  
	Vector islands = graph.getIslands();
	arpNode start_node = graph.getNode(start);
	int sx = start_node.getX();
	int sy = start_node.getY();
	arpNode goal_node = graph.getNode(goal);
	int gx = goal_node.getX();
	int gy = goal_node.getY();
	
	Vector cache = new Vector();
	if( sx <= gx && sy <= gy){
		//System.out.println( "s --> bl, g --> tr");
        }
	if( sx <= gx && sy >= gy){
 		//System.out.println( "s --> tl, g --> br");
	}
	if( sx >= gx && sy <= gy){
		//System.out.println( "s --> br, g --> tl");
	}
	if( sx >= gx && sy >= gy){
		//System.out.println( "s --> tr, g --> bl");
	}
	for(int i =0; i < islands.size(); i++){
		arpNode a = (arpNode)islands.elementAt(i);
		int x = a.getX();
		int y = a.getY();

		// start_node: bottom left
		// goal_node: top right
		if( sx <= gx && sy <= gy){
			if( x >= sx && x <= gx && y >= sy && y <= gy){
				cache.addElement(a);
			}
		}
		// start_node: top left
		// goal_node: bottom right
		if( sx <= gx && sy >= gy){
			if ( x >= sx && x <= gx && y <= sy && y >= gy){
				cache.addElement(a);
			}
		}
		// start_node: bottom right
		// goal_node: top left
		if( sx >= gx && sy <= gy){
			if( x <= sx && x >= gx && y >= sy && y <= gy){
				cache.addElement(a);
			}
		}
		// start_node: top right
		// goal_node: bottom left
		if( sx >= gx && sy >= gy){
			if( x <= sx && x >= gx && y <= sy && y >= gy){
				cache.addElement(a);
			}
		}  
	}
	cache.addElement(start_node);
	cache.addElement(goal_node);
	return cache;
	  
  }
	
  // The method is used to determine whether the H. Bridge
  // is treated as island
  private boolean HBridge(int start, int goal){

	int con1 = 0;
	int con2 =0;
	con1 = isNorth(start);
	con2 = isNorth(goal);
	if(con1==0){
		con1 = isSouth(start);
	}
	if(con2==0){
		con2 = isSouth(goal);
	}
	
	if( con1 == 0  || con2 == 0 ){
		return false;
	}
	if( con1 != con2){
		//System.out.println("*** Add bridge *** ");
		return true;
	}
	return false;
  }

  // This method determine whether the node is in North Harbor Area
  // if yes: return 1
  private int isNorth(int node){
	
	arpNode a = graph.getNode(node);
	int x = a.getX();
	int y = a.getY();
	if(  x > 2660231 && y > 6483600){
		//System.out.println("node: " + node + " is in North Area");
		return 1;
	}
	return 0;
  }

  // This method determine whether the node is in South Area
  // if yes: return 2
  private int isSouth(int node){

	arpNode a = graph.getNode(node);
	int x = a.getX();
	int y = a.getY();
	if(  x > 2660231 && y < 6483600){
		//System.out.println("node: " + node + " is in South Area");
		return 2;
	}
	return 0;
  }

  private int get_direction(int start, int goal){

	int direction = 0;
	arpNode start_node = graph.getNode(start);
	int sx = start_node.getX();
	int sy = start_node.getY();
	arpNode goal_node = graph.getNode(goal);
	int gx = goal_node.getX();
	int gy = goal_node.getY();
	if( sx <= gx && sy <= gy){ direction = 1;}
	if( sx <= gx && sy >= gy){ direction = 2;}
	if( sx >= gx && sy <= gy){ direction = 3;}
	if( sx >= gx && sy >= gy){ direction = 4;}
  	return direction;
   }

 // This method creates an arpGraph which only formed by the potential
  // islands
private arpGraph createGraph(Vector islands, int start, int goal){

	arpGraph local = new arpGraph();
	int key = 0;
        for( int i=0; i < islands.size(); i++){
		arpArc[] attach;
		arpNode node1 = (arpNode)islands.elementAt(i);
		attach = new arpArc[islands.size()-1];
		int counter =0;
		for(int k=0; k < islands.size(); k++){
		    if( k != i){
			arpNode node2 = (arpNode)islands.elementAt(k);
			   float dist = calDist(node1, node2);
			   arpArc arc = new arpArc(key, node1.getID(), node2.getID(), dist, ""+ key, " ", " ", 0);
			   attach[counter++] = arc;
			   local.putArc(new Integer(key), arc);
			   key++;
			
		    }
		}
  		arpNode node = new arpNode(node1.getID(), attach, node1.getX(), node1.getY());
		local.putNode(new Integer(node1.getID()), node);
	}
	return local;
  }
}