package arpClasses.Search;
import arpClasses.Serialize.*;
import java.util.*;

/** 
 * Dijkstra's Algorithm - Dial's implementation with approx buckets
 * This is used to search the shortest path from 2 points.
 * @author Alan Sheung Chi MAK
 * @version 1.1
 */
 
public class DialAlg{
	private Hashtable finished, visited;
	private ArpBucket[] buckets;
	private arpGraph graph; 	
	public DialAlg(arpGraph graph){
		this.graph = graph;
	}
	
	public Vector run(int src, int des){
		//long startTime = System.currentTimeMillis();  
		int ptr =0;	//ptr is a pointer point to the current bucket
		int index =0;  
		int nodeExp = 0;                   
		init(src, des);
		int bucketSize = buckets.length;  //total no of bucket used
		NodePath current = null;	
		while(!finished.containsKey(""+des)){
			ptr = index%bucketSize;      //to cal which is the active bucket
			if(!buckets[ptr].isEmpty()){
				 current=buckets[ptr].remove();
				 int currentNodeID = current.getID();
				 //System.out.println("CurrentID ="+currentNodeID);
				 arpNode currNode = graph.getNode(currentNodeID);
				 arpArc[] arcs = currNode.getArcs();
				 //if(arcs!=null){    //check is this oneway 
				 String name;
	       for (int arcNo=0; arcNo<arcs.length; arcNo++){
	   	     
	     int desID = arcs[arcNo].getTo();
	     //System.out.println("desID ="+desID);
	     if(!finished.containsKey(""+desID)){
	     	 name = arcs[arcNo].getFullName(); //get road name
	     	 int dist = (int)(arcs[arcNo].getDistance());
	   	       if(visited.containsKey(""+desID)){
	   	       	
	   	       	 int sDist = ((Integer)visited.get(""+desID)).intValue();
	   	         dist += current.getTotalDistance();
	   	       	 if(sDist>dist){   //the current path is shorter than the old path
	   	       	 	  buckets[sDist%bucketSize].removeNodePath(desID);
	   	       	    NodePath path = new NodePath(dist,desID,addRoad(current,name));
	   	       	    //System.out.println("ID ="+path.getID()+" :Dist = "+path.getTotalDistance());
	   	       	    buckets[dist%bucketSize].add(path);
	   	       	    visited.remove(""+desID);
	   	       	    visited.put(""+desID,new Integer(dist));
	   	       	 }
	   	       }  
	   	       else{
		            dist += current.getTotalDistance();
		            NodePath path = new NodePath(dist,desID,addRoad(current,name));
		            //System.out.println("ID ="+path.getID()+" :Dist = "+path.getTotalDistance());
		            buckets[dist%bucketSize].add(path);
		            visited.put(""+desID,new Integer(dist));                         //set the des node as temp label
	   	       }
	         }        
			//put the NodePath to the ArpBucket with the same dist Label
		     }//end for
         visited.remove(""+currentNodeID);
         finished.put(""+currentNodeID,"");
         //nodeExp++;
			}
			else{  //buckets is empty
				buckets[ptr].updateLabel(ptr+bucketSize);
				index++;
			}
			
	  }// end while
		//react the destination node  
	    //long runTime = System.currentTimeMillis() - startTime;
      //System.out.println("runTime = " + runTime);
      //System.out.println("node exp "+visited.size()+" finish "+finished.size());
		return current.getPath();
	}//end method start()
	
	private void init(int src, int des){
      finished = new Hashtable();  //store all permanently label
		  visited = new Hashtable();   //store all the temporarily label with finite distance
      arpNode start= graph.getNode(src);             //the starting node
		  arpNode finish = graph.getNode(des);           //the destination of the search
      buckets = new ArpBucket[(int)graph.getMaxSegment()+1];
    //initial all the buckets that it need to handel all the labels(node)
    for (int i=0; i<buckets.length; i++){
     	buckets[i] = new ArpBucket(i);         
     	//setup all the buckets need to maintain the label
		}
		arpArc[] arcs = start.getArcs();              //get all the associate arcs
		for (int arcNo=0; arcNo<arcs.length; arcNo++){
			Vector v = new Vector();
			v.addElement(arcs[arcNo].getFullName());
			int id = arcs[arcNo].getTo();
			int dist = (int)arcs[arcNo].getDistance();
			NodePath startPath = new NodePath(dist,id,v);
			visited.put(""+id,new Integer(dist));                         //set the des node as temp label
			buckets[dist].add(startPath);        
			//put the NodePath to the ArpBucket with the same dist Label
		}
		finished.put(""+src,"");                   //start node become permanently label    	
	}//end method init()
		
	private Vector addRoad(NodePath current, String name){
	    Vector v = current.getPath();
	    Vector nv= (Vector)v.clone();
	   	nv.addElement(name);
	   	return nv;
	}
	
}//end class dialAlg