package arpClasses.Search;

import arpClasses.Serialize.*;
import java.util.*;

/**
 * The main part of the A* search algorithm
 * This class extends Thread, so a number of search can be
 * carry out at the same time. 
 *
 * @author Chang, Mei Yung (TONY)
 * @version 1.2
 */

public class AStar extends Thread {
  
  private int startID;
  private int goalID;
  private arpGraph graph;
  private int type;
  private Vector path;
  
  public AStar(int startID, int goalID, arpGraph graph, Vector path, int type) {
    this.startID = startID;
    this.goalID = goalID;
    this.graph = graph;
    this.type = type;
    this.path = path;
  }
  
  // The main code of the search
  public void run() {
    
    long startTime = System.currentTimeMillis();
    
    boolean found = false;
    PriorityVector open = new PriorityVector();
    Hashtable h_open = new Hashtable();
    //LinkedList closed = new LinkedList();
    Hashtable h_closed = new Hashtable();
    
    Node start, goal, n, ndash, foundNode;
    Node openFound, closedFound;
    arpNode temp;
    arpArc[] arcs;
    
    temp = graph.getNode(startID);
    start = new Node( temp.getID(), temp.getX(), temp.getY() );
    temp = graph.getNode(goalID);
    goal = new Node( temp.getID(), temp.getX(), temp.getY() );
    
    // A counter that count the number of node expanded during the search
    int nodeExpanded = 0;
    
    open.add(start);
    h_open.put(new Integer(start.getNodeID()), start);
    
    while ( ( !open.isEmpty() ) && ( !found ) ) {
      
      //System.out.println("open size = " + open.size());
      //System.out.println("h_open size = " + h_open.size());
      //System.out.println("closed size = " + h_closed.size());
      
      n = open.remove(); // Get the minimum node and remove it from open
      h_open.remove(new Integer(n.getNodeID()));
      //closed.add(n); // add the node to the closed
      h_closed.put(new Integer(n.getNodeID()), n);
      
      //System.out.println("n = " + n.getNodeID());
      nodeExpanded++;
      
      // check the node, and see if its the goal node
      if (n.getNodeID() == goal.getNodeID()) {
        found = true; // Done
      }
      else {
        // Get the all successors
        temp = graph.getNode( n.getNodeID() );
        arcs = temp.getArcs();
        
        //System.out.println("Node expanding: " + n.getNodeID());
        
        // For each sucessor
        for (int i=0; i<arcs.length; i++) {
          
          //System.out.println("Successors: " + i + " " + arcs[i].getTo() + " " + arcs[i].getRoadName() + " " + arcs[i].getSuburb());
          
          temp = graph.getNode( arcs[i].getTo() );
          // For higher level, it some of the segment are disconnected to the "toNode"
          // so temp would be NULL, then skip once
          if (temp == null) continue;
          ndash = new Node( temp.getID(), temp.getX(), temp.getY() );
          ndash.setDistance( arcs[i].getDistance() );
          ndash.setRoadName( arcs[i].getRoadName() );
          ndash.setRoadType( arcs[i].getRoadType() );
          ndash.setSuburb( arcs[i].getSuburb() );
          
          // See if its the previous one. avoid loop back
          if ( (n.getParent() == null) || (ndash.getNodeID() != (n.getParent().getNodeID()) )) {
            ndash.setParent( n );
            
            double gdash = n.getG() + ndash.getDistance();
            
            //openFoundNum = open.findNode( ndash.getNodeID() );
            openFound = (Node)h_open.get(new Integer(ndash.getNodeID()));
            
            // If ndash has found in open, it cant be in closed      
            if (openFound != null) {
              closedFound = null;
            }
            else {
              //closedFound = findNode( closed, ndash.getNodeID() );
              closedFound = (Node)h_closed.get(new Integer(ndash.getNodeID()));
            }
            
            // If ndash not in both open and closed
            if ((openFound == null) && (closedFound == null)) {
              ndash.setG(gdash);
              ndash.setF( ndash.getG() + Heuristics.computeH(ndash, goal, type) );
              open.add(ndash);
              h_open.put(new Integer(ndash.getNodeID()), ndash);
            }
            // see which one contain ndash
            else {
              // closed contain ndash
              if (closedFound != null) {
                foundNode = closedFound;
                //System.out.println("Closed");
              }
              // open contain ndash
              else {
                foundNode = openFound;
                //System.out.println("Open");
              }
              
              if (foundNode.getG() > gdash) {
                foundNode.setDistance( ndash.getDistance() );
                foundNode.setParent( n );
                foundNode.setG( gdash );
                foundNode.setF( foundNode.getG() + Heuristics.computeH(foundNode, goal, type) );
                foundNode.setRoadName( ndash.getRoadName() );
                foundNode.setRoadType( ndash.getRoadType() );
                foundNode.setSuburb( ndash.getSuburb() );
                
                // If closed contain ndash, then remove from closed and add to open
                if (closedFound != null) {
                  //closed.remove(foundNode);
                  h_closed.remove(new Integer(foundNode.getNodeID()));
                  open.add(foundNode);
                  h_open.put(new Integer(foundNode.getNodeID()), foundNode);
                }
                else {
                  open.removeElement(foundNode);
                  open.add(foundNode);
                }
              }
            }
          }
        } //End for
      } //End found if
    } //End outer while
    //return closed;
    System.out.println("Node Expanded = " + nodeExpanded);
    //saveRoute(closed);
    saveRoute(h_closed);
    
    long runTime = System.currentTimeMillis() - startTime;
    System.out.println("runTime for this AStar = " + runTime);
    System.out.println();
  }
  
  // Currently, it just print the path to the standard output.
  // Later, it will return a Vector contains all the street name of the computed path.
  /*private synchronized void saveRoute(LinkedList closed) {
    int totalLength = 0;
    
    Node n = (Node)closed.removeLast();
    Node parent = n.getParent();
    
    // store the path into the vector
    path.add(n);
    totalLength += n.getDistance();
    
    while (parent != null) {
      path.add(parent);
      
      totalLength += parent.getDistance();
      
      parent = parent.getParent();
      
    }
    System.out.println("Total distance = " + totalLength);
  }*/
  
  private synchronized void saveRoute(Hashtable closed) {
    int totalLength = 0;
    
    Node n = (Node)closed.remove(new Integer(goalID));
    Node parent = n.getParent();
    
    // store the path into the vector
    path.add(n);
    totalLength += n.getDistance();
    
    while (parent != null) {
      path.add(parent);
      
      totalLength += parent.getDistance();
      
      parent = parent.getParent();
      
    }
    System.out.println("Total distance = " + totalLength);
  }
  
  // Takes a list as input, then find the node which match the nodeID
  // and returns the position of the node in the list.
  private Node findNode(LinkedList list, int nodeID) {
    Node temp;
    for (int i=0; i<list.size(); i++) {
      temp = (Node)list.get(i);
      if ( temp.getNodeID() == nodeID )
        return temp;
    }
    return null;
  }
}