package arpClasses.Interface;
import arpClasses.DB.*;
import arpClasses.Search.*;
import arpClasses.Serialize.*;
import arpClasses.Drawing.*;
import java.util.Vector;
import java.sql.*;
import java.lang.Object;
import java.util.StringTokenizer;

/*
 * Core of ARP, handle different common from the user interface
 * @author Alan Sheung Chi Mak
 * @version 1.3
 */

public class arpInterface{
	Vector suburb = null;
	private arpGraph graph = deserializeObject.graph_0;
	//private Vector graph_0 = deserializeObject.soundexList;
	mapInterface mi;
	int[] box;
	dbManager db = new dbManager();
	Vector ids = new Vector();      //stored the shape_id

  public arpInterface() {
  	//this.graph=deserializeObject.graphObject;
  }
    
  public int[] AStarSearch(int start, int goal, Vector result, int[] box, String alg){
  	 int sid = segmentToNodeID(start);
  	 int gid = segmentToNodeID(goal);
  	 if(sid!=-1&&gid!=-1){
  	 	 if(alg.equals("Aalg")){
  	 	 	System.out.println("A star");
  	 	 HSearch hs = new HSearch(deserializeObject.graph_0, deserializeObject.graph_1, 1);
  	 	 Node sn = hs.getNode(sid);
  	 	 Node gn = hs.getNode(gid);
  	       hs.getPath(sn, gn, result);
  	 	 }
  	 	 else{	
  	   
  	        System.out.println("ISearch");
  	        ISearch is = new ISearch(sid,gid,graph);
  	        is.start(result);
  	 	 }
  	     
  	     System.out.println(result.size());
         if(box==null){
           ids.clear();	
           box = db.findBox(result, ids, graph.getArc(start),graph.getArc(goal));
         }
         showMap(box, ids);
  	   return box;
  	 }
  	 else{
  	 	return null;
  	 }
  }
  
  //method a segment_id and return one of the node id connected to the segment
  public int segmentToNodeID(int segment_id){
  	  try{
  	   	  return graph.getArc(segment_id).getTo();
  	  }
  	  catch(Exception e){
  	  	 System.out.println("Error at convert id: "+e);
  	  	 return -1;
  	  }
  }
  
  public String getRoadName(int segment_id){
     try{
     	System.out.println("segment "+segment_id);
  	  return graph.getArc(segment_id).getFullName()+"<i>("+graph.getArc(segment_id).getSuburb()+")</i>";
  	}
  	catch(Exception e){
  	 System.out.println("Error at found roadname: "+e);
  	 return "";
  	 }
  }
  
  public Vector searchRoadList(String input, String suburbInput,String smode){
  	 Vector result=new Vector();
      if(smode==null){
      	smode="";
      }
    	int pos = 0;
    	String sqlstr = "";
    	String lastWord ="";
    	String soundex="";
    try {	
    	if(!arpSQLConn.getInstance().isConnected()){
    	  arpSQLConn.getInstance().connect();
      }
      
      if(!input.equals("")&&input!=null){
      	soundex = db.getSoundex(input);         
      }
      System.out.println("Soundex ="+soundex);
      //check is there any ' in the input variable
      if((pos=input.indexOf('\''))!=-1){
      	input = input.substring(0,pos)+"\\"+input.substring(pos);
      }
      input = input.replace(';', ' ');          //for security make sure no ';' in suburbInput
      suburbInput = suburbInput.replace(';', ' ');          //for security make sure no ';' in suburbInput
          
      StringTokenizer st = new StringTokenizer(input);
      if (st.hasMoreTokens()){
        input  = st.nextToken();
        while (st.hasMoreTokens()) {
          lastWord = st.nextToken();
        }
      }
      
      if(!lastWord.equals("")){
      	if(lastWord.equalsIgnoreCase("rd")){
      	   lastWord = "road";
            }
            else if(lastWord.equalsIgnoreCase("st")){
               lastWord = "Street";
            }
            else if(lastWord.equalsIgnoreCase("pl")){
               lastWord = "place";
            }
            else if(lastWord.equalsIgnoreCase("cl")){
               lastWord = "close";
            }
            else if(lastWord.equalsIgnoreCase("cres")){
               lastWord = "crescent";
            }
            else if(lastWord.equalsIgnoreCase("ave")){
               lastWord = "avenue";
            }
            else if(lastWord.equalsIgnoreCase("DR")){
               lastWord = "drive";
            }
            else if(lastWord.equalsIgnoreCase("ct")){
               lastWord = "court";
            }
            else if(lastWord.equalsIgnoreCase("ln")){
               lastWord = "lane";
            }
            else if(lastWord.equalsIgnoreCase("ter")){
               lastWord = "terrace";
            }
      }	
      //long startTime = System.currentTimeMillis();
      //query all road_name match the input
      
      if(!input.equals("")){
        if(lastWord.equals("")){   
          sqlstr="select segment_id, road_name, road_type, suburb from segment";
          sqlstr+=" where road_name like '"+input+"%' order by road_name, road_type, suburb";
        }
        else{
          sqlstr="select segment_id, road_name, road_type, suburb from segment";
          sqlstr+=" where road_name like '"+input+"%' and road_type ='"+lastWord+"' order by road_name, road_type, suburb";
          result=db.extractSearchData(result,sqlstr,"");
          sqlstr="select segment_id, road_name, road_type, suburb from segment";
          sqlstr+=" where road_name like '"+input+"%' and road_type !='"+lastWord+"' order by road_name, road_type, suburb";
        }
        result=db.extractSearchData(result,sqlstr,"");
      
        
      //query to match any road have a similar sound
      long startTime = System.currentTimeMillis();
      sqlstr="select segment_id, segment.road_name, segment.road_type, segment.suburb from road, segment";
      sqlstr+=" where road.road_id=segment.road_id and dex = '"+soundex+"' and road.road_name not like '"+input+"%'";
      sqlstr+=" order by road_name, road_type, suburb";
      result=db.extractSearchData(result,sqlstr,suburbInput);
            
      long runTime = System.currentTimeMillis() - startTime;
      System.out.println("search runTime = " + runTime);
      //query all the match suburb with the inputsuburb
      sqlstr="select segment_id, road_name, road_type, suburb from segment";
      sqlstr+=" where road_name not like '"+input+"%' and suburb ='"+suburbInput+"' order by road_name, road_type";
      }
      else{
        //query all the match suburb with the inputsuburb
        sqlstr="select segment_id, segment.road_name, segment.road_type, segment.suburb from road, segment";
        sqlstr+=" where road.road_id=segment.road_id and segment.suburb ='"+suburbInput+"' order by road_name, road_type";
      }
      result=db.extractSearchData(result,sqlstr,"");
      
      if(smode.equals("more")){
      	if(!input.equals("")){
         sqlstr="select segment_id, segment.road_name, segment.road_type, segment.suburb from road, segment";
         sqlstr+=" where road.road_id=segment.road_id"; 
         if(input.length()>3){
            sqlstr+=" and road.road_name regexp '^"+input.substring(0,2)+".{"+(input.length()-3)+","+input.length()+"}'";  
         }
         sqlstr+=" and road.road_name not like '"+input+"%' order by road_name, road_type, suburb";
         System.out.println(sqlstr);
         result=db.extractSearchData(result,sqlstr,suburbInput);
      	}
      }
            
        
    }catch (Exception e) {
    	  System.out.println("Search Mode - error: "+e);
    }
         
         return result; 
        
  }//end searchRoadList()
  
  	
  //This method return a list of road name with the same beginning letter
  public Vector getList(char input, String suburbInput){
    try {
    	String sqlstr = "";
    	if(!arpSQLConn.getInstance().isConnected()){
    	  arpSQLConn.getInstance().connect();
      }
         sqlstr="select distinct segment_id, road_name, road_type, suburb from segment where";
         if(input!=' '){
           sqlstr+=" road_name like '"+input+"%'";
         }
         else{
         	sqlstr+=" road_name =''";
         }
         //if(suburbInput!=null){
         	suburbInput = suburbInput.replace(';', ' ');          //for security make sure no ';' in suburbInput
         	sqlstr+=" or suburb = '"+suburbInput+"'";
         //}
         sqlstr+=" order by road_name, road_type, suburb";
         System.out.println(sqlstr);
         ResultSet rs = arpSQLConn.getInstance().executeQuery(sqlstr);
         Vector result = new Vector();
         String road, type, suburb;
         String lastroad = "";
         String lastsuburb ="";
         int id;
         boolean firstLine = true;
         while(rs.next()) {
              road = rs.getString("road_name");
              id   = rs.getInt("segment_id");
        	  type = rs.getString("road_type");
        	  suburb=rs.getString("suburb");
           
          if(!(type.equals("MOTORWAY")||type.equals("HIGHWAY"))){
           	  if(!(road.equals(lastroad)&&suburb.equals(lastsuburb))){
                String returnlist="value='"+id+"'";	  
                if(firstLine){
                	returnlist+=" checked";
                	firstLine = false;
                }
                returnlist+=">"+road+" "+type+"<i class='blue'> ("+suburb+")</i>";
                //if(!result.contains(returnlist))
        	    result.addElement(returnlist);
        	    lastsuburb = suburb;
        	    lastroad = road;
        	  }
          }
         }
         
         return result; 
    }
    catch (Exception e) {
    	  System.out.println("List Mode - error:"+e);
        return null;
    }
    
  }//end getList()
  	
    public Vector getSuburb(){
       return deserializeObject.graph_0.getSuburb();
       //return graph.getSuburb();
    }
   	 
  // ** list of method for control mapInterface ** //  	
  public void showMap(int[] box, Vector ids){
    if(mi==null){
  		mi = new mapInterface();
    }
    mi.setStartPoint(box, ids);	
    mi.showWindow();
    //mi.export();
  }
  public void closeMap(){
  	mi.hideWindow();
  }
  public String drawMap(){
  	return mi.export();
  }
  public int[] zoonOut(int[] box){
  	System.out.println("out");
  	return mi.zoonOut(box);
  }
  public int[] zoonIn(int[] box){
  	System.out.println("in");
  	return mi.zoonIn(box);
  }
  public int[] toEast(int[] box){
  	return mi.toEast(box);
  }
  public int[] toSouth(int[] box){
  	return mi.toSouth(box);
  }
  public int[] toWest(int[] box){
  	return mi.toWest(box);
  }
  public int[] toNorth(int[] box){
  	return mi.toNorth(box);
  }
  public int[] viewCity(){
  	return mi.viewCity();
  }
}//end class arpInterface