package arpClasses.Drawing;

import java.util.Vector;
import java.awt.*;
import java.awt.event.*;
import arpClasses.Interface.*;
import javax.imageio.*;
import java.io.*;
import java.awt.image.BufferedImage; 
import com.sun.image.codec.jpeg.*;

public class mapInterface extends Frame implements ActionListener, MouseListener
{
    DrawingCanvas canvas;
    public final static int WIDTH = 588;
    public final static int HEIGHT = 550;
       
    PolyLine points;
    Vector all;
    
    Panel mainPanel = new Panel(new BorderLayout());
    Panel mapPanel = new Panel(new BorderLayout());
    Panel buttonsPanel = new Panel(new GridLayout(4,1));
    Button east = new Button(">");
    Button west = new Button("<");
    Button north = new Button("north");
    Button south = new Button("south");
    Button in = new Button("Zoom In");
    Button out = new Button("Zoom Out");
    Button full = new Button("Full Map");
    Button city = new Button("City Map");
       
    public mapInterface()
    {
    	
	    init();         
    }
    
    public void init()
    {
        	     
	addWindowListener(new WindowAdapter() {
	public void windowClosing(WindowEvent e) {
	   System.exit(0);
	   //hideWindow();
	}    
	});
	  
	  setTitle("Map");
	  
	  canvas = new DrawingCanvas(deserializeObject.roadsShape);
	  setSize(WIDTH,HEIGHT);
	  canvas.setSize(470,470);
        buttonsPanel.add(in);
        buttonsPanel.add(out);
        buttonsPanel.add(full);
        buttonsPanel.add(city);
        mapPanel.add(east,BorderLayout.EAST);
        mapPanel.add(south,BorderLayout.SOUTH);
        mapPanel.add(west,BorderLayout.WEST);
        mapPanel.add(north,BorderLayout.NORTH);
        mapPanel.add(canvas,BorderLayout.CENTER);
        mainPanel.add(mapPanel,BorderLayout.CENTER);
        mainPanel.add(buttonsPanel, BorderLayout.WEST);
        
        add(mainPanel);
        in.addActionListener(this);
        out.addActionListener(this);
        full.addActionListener(this);
        city.addActionListener(this);
        east.addActionListener(this);
        south.addActionListener(this);
        west.addActionListener(this);
        north.addActionListener(this);
        canvas.addMouseListener(this);

    }
    public String export(){
    	String filename = canvas.xmin+""+canvas.ymax+""+(int)(Math.random()*100)+".jpeg";
    	try{
    	  Image fileImage = createImage(470,470);
        Graphics2D graphics2D = (Graphics2D) fileImage.getGraphics();
        canvas.paint(graphics2D);
        graphics2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION,
	      RenderingHints.VALUE_INTERPOLATION_BILINEAR);
	      BufferedOutputStream out = new BufferedOutputStream(
	  	  new FileOutputStream("C:/Blazix/webfiles/arp/images/"+filename));
	      JPEGImageEncoder encoder = JPEGCodec.createJPEGEncoder(out);
	      JPEGEncodeParam param = encoder.getDefaultJPEGEncodeParam((BufferedImage)fileImage);
	      int quality = 80;
	      quality = Math.max(0, Math.min(quality, 100));
	      param.setQuality((float)quality / 100.0f, false);
	      encoder.setJPEGEncodeParam(param);
	      encoder.encode((BufferedImage)fileImage);
	      System.out.println("Done.");
	      graphics2D.dispose();
    	}
    	catch(Exception e){ System.out.println("Error During export: "+e);}
    	return filename;
    }
    
    public void setStartPoint(int[] box, Vector result){
    	canvas.setResult(result);
    	int dx = box[2] - box[0];
    	int dy = box[3] - box[1];
    	System.out.println(box[0]+";"+box[1]+";"+box[2]+";"+box[3]); 
    	
    	if(dx>dy){
    	  canvas.xmin=box[0];
    	  canvas.ymin=box[1]-(dx-dy)/2;
    	  canvas.xmax=box[2];
    	  canvas.ymax=box[3]+(dx-dy)/2;
      }
      else{
    	  canvas.xmin=box[0]-(dy-dx)/2;
    	  canvas.ymin=box[1];
    	  canvas.xmax=box[2]+(dy-dx)/2;
    	  canvas.ymax=box[3];
      }
      
  	canvas.updateScale();
  	
    }
    
    public void showWindow()
    // show frame
    {
        setVisible(true);
    }

    public void hideWindow()
    // hide frame
    {
        setVisible(false);
    }
    public void mouseClicked(MouseEvent e){
    	if(e.getSource() == canvas){
    		//System.out.println("Clicked "+e.getX() + " ; "+ e.getY());
    		canvas.focusArea(e.getX(),e.getY());
    	}
    }
    public void mousePressed(MouseEvent e){
       //System.out.println("Pres "+e.getX() + " ; "+ e.getY());
    }
    public void mouseReleased(MouseEvent e){
    	 //System.out.println("Release "+e.getX() + " ; "+ e.getY());
    }
    public void mouseEntered(MouseEvent me){
    }
    public void mouseExited(MouseEvent me){
    }
    public void actionPerformed(ActionEvent e){    
    	  
    	  Object source = e.getSource();
        if(source == out){
        	canvas.zoonOut();
        }
        else if(source == in){
        	canvas.zoonIn();
        }
        else if(source == full){
        	canvas.reset();
        }
        else if(source == city){
        	canvas.viewCity();
        }
        else if(source == east){
        	canvas.toEast();
        }
        else if(source == south){
        	canvas.toSouth();
        }
        else if(source == west){
        	canvas.toWest();
        }
        else if(source == north){
        	canvas.toNorth();
        }
    }
    public int[] zoonIn(int[] box){
   	//int[] box = new int[4];
   	int dX = (box[2]-box[0])/4;
   	int dY = (box[3]-box[1])/4;
   	box[0] += dX;
   	box[1] += dY;
   	box[2] -= dX;
   	box[3] -= dY;
   	return box;
   }
   public int[] zoonOut(int[] box){
   	int dX = (box[2]-box[0])/2;
   	int dY = (box[3]-box[1])/2;
   	box[0] -= dX;
   	if(box[0]<shapeExtractor.XMIN){
   		box[0]=shapeExtractor.XMIN;
   	}
   	box[1] -= dY;
   	if(box[1]<shapeExtractor.YMIN){
   		box[1]=shapeExtractor.YMIN;
   	}
   	box[2] += dX;
   	if(box[2]>shapeExtractor.XMAX){
   		box[2] = shapeExtractor.XMAX;
   	}
   	box[3] += dY;
   	if(box[3]>shapeExtractor.YMAX){
   		box[3] = shapeExtractor.YMAX;
   	}
      return box;
   }
   public int[] reset(){
   	int[] box = new int[4];
   	box[0] = shapeExtractor.XMAX;
      box[1] = shapeExtractor.YMAX;
      box[2] = shapeExtractor.XMIN;
      box[3] = shapeExtractor.YMIN;
      return box;
   }
   public int[] viewCity(){
   	int[] box = new int[4];
   	box[0] = 2655000;
   	box[1] = 2682000;
      box[2] = 6465000;
      box[3] = 6492000;
      return box;
   }
   public int[] toEast(int[] box){
   	int currentRangeX = box[2]-box[0];
   	box[2] += currentRangeX/2;
   	if(box[2]>shapeExtractor.XMAX){
   		box[2] = shapeExtractor.XMAX;
   	}
   	box[0] = box[2] - currentRangeX;
   	return box;
   }
   public int[] toWest(int[] box){
   	int currentRangeX = box[2]-box[0];
   	box[0] -= currentRangeX/2;
   	if(box[0]<shapeExtractor.XMIN){
   		box[0] = shapeExtractor.XMIN;
   	}
   	box[2] = box[0] + currentRangeX;
   	return box;
   }
   public int[] toNorth(int[] box){
   	int currentRangeY = box[3]-box[1];
   	box[3] += currentRangeY/2;
   	if(box[3]>shapeExtractor.YMAX){
   		box[3] = shapeExtractor.YMAX;
   	}
   	box[1] = box[3] - currentRangeY;
   	return box;
   }
   public int[] toSouth(int[] box){
   	int currentRangeY = box[3]-box[1];
   	box[1] -= currentRangeY/2;
   	if(box[1]<shapeExtractor.YMIN){
   		box[1] = shapeExtractor.YMIN;
   	}
   	box[3] = box[1] + currentRangeY;
   	return box;
   }
}