package arpClasses.DB;

import java.sql.*;

public class arpSQLConn{

    protected boolean connected = false;
    private Connection con;

    private String driverName = "org.gjt.mm.mysql.Driver";
    private String dbName = "jdbc:mysql://localhost:3306/IT";

    private static arpSQLConn instance = new arpSQLConn();
    
    public arpSQLConn(){

    }
    
    public static arpSQLConn getInstance(){
        return instance;
    }

    public void connect() throws Exception{
   	    if(connected)
   	        return;
        else {
         Class.forName(driverName);
          con = DriverManager.getConnection(dbName);
          con.setAutoCommit(true);
          connected = true;
        }
    }

    public void disconnect() throws Exception{
        con.close();
        connected = false;
    }

    public boolean isConnected(){
		return connected;
    }

    public synchronized void execute(String sql) throws Exception{
        Statement stmt = con.createStatement();
        stmt.execute(sql);
    }

    public synchronized ResultSet executeQuery(String sql) throws Exception{
        Statement stmt = con.createStatement();
        ResultSet rs = stmt.executeQuery(sql);
        return rs;
    }

    public synchronized void setAutoCommit(boolean status) throws Exception{
      con.setAutoCommit(status);
    }

    public synchronized void commit() throws Exception{
        con.commit();
    }

    public synchronized void rollback() throws Exception{
        con.rollback();
    }

}