//package arpClasses.Drawing;

import java.io.*;
import java.util.*;
import java.awt.*;
/**
   *   An application for serialized PolyLine and running the map application
   *   @author Alan Sheung Chi Mak
   */
public class shapeExtractor{
	static int counter=0;
	static numberConverter convert = new numberConverter();
	static Vector cstline = new Vector();
	static Vector roads = new Vector();
	public final static int XMIN = 2614635;
	public final static int YMIN = 6399726;
	public final static int XMAX = 2716627;
	public final static int YMAX = 6564006; 
	
	public shapeExtractor(){
	}
	
	public static void main(String[] args){
		try{
		FileInputStream fis;	
		  
		  int value =0;
		  
		  int fileLength=0;
		  double Xmin, Ymin, Xmax, Ymax;
      mapInterface mi = new mapInterface();
      mi.showWindow();
                
	}
	catch(Exception e){
	  System.out.println(e);
	}
   }	//end main
   	
   	//for big endian
   public static int extractFourHeaderBytes(FileInputStream fis) throws Exception{
   	String binValue="";
   	for(int i=0; i<4 ;i++){
   		binValue+=convert.toBinaryString(fis.read());
   		counter++;
   	}
   	return convert.BintoDec(binValue);
   }
   public static int extractFourBytes(FileInputStream fis) throws Exception{
   	String binValue="";
   	for(int i=0; i<4 ;i++){
   		binValue=convert.toBinaryString(fis.read())+binValue;
   		counter++;
   	}
   	return convert.BintoDec(binValue);
   }
   public static double extractEightBytes(FileInputStream fis) throws Exception{
   	String binValue="";
   	for(int i=0; i<8 ;i++){
   		binValue=convert.toBinaryString(fis.read())+binValue;
   		counter++;
   	}
   	return convert.convertToDouble(binValue);
   	
   }
   public static PolyLine extractPolyLine(FileInputStream fis) throws Exception{
   	  int contentLen, recordNum,endPoint;
        double x,y;
        recordNum = extractFourHeaderBytes(fis);
        contentLen = extractFourHeaderBytes(fis);
        endPoint=counter+2*contentLen;
        	  
         	int[] box = new int[4];
        	   extractFourHeaderBytes(fis);
        	   for(int i=0;i<4;i++){
        	     	  box[i]=(int)extractEightBytes(fis);
        	   }
         	   
        	   int numParts = extractFourBytes(fis);
        	   int numPoints = extractFourBytes(fis);
        	   int[] Parts = new int[numParts];
        	   for(int i=0;i<numParts;i++){
        	     	  Parts[i]=extractFourBytes(fis);
        	   }
        	   Point[] points = new Point[numPoints];
        	   for(int i=0;i<numPoints;i++){
        	     	   x=(extractEightBytes(fis));
        	     	   y=(extractEightBytes(fis));
        	     	   points[i]=new Point((int)(x),(int)(y));
       	   }
       	   return new PolyLine(box, numParts, numPoints, Parts, points);
       	   
   }//end extractPolyLine
   	
   public static void serializeShapedata(Vector allData){
   	try{
   		  dbManager db = new dbManager();
   	    db.addShapesRoadName(allData);
   	    System.out.println("Start serializaion");
   	    FileOutputStream out = new FileOutputStream("roadsShape");
	      ObjectOutputStream s = new ObjectOutputStream(out);
	      s.writeObject(allData);
	      s.flush();
	      s.close();
	      System.out.println("End serializaion");
   	}
   	catch (Exception e){
   		System.out.println(e);
   	}
   }
}