/**********************************************************************
 * 	Program reused by Peter McClymont, University of Auckland
 *	by permission of Author : Dr. S. Manoharan
 **********************************************************************/


#ifndef _GetLongOpt_h_
#define _GetLongOpt_h_

#include <iostream.h>

class GetLongOpt {
public:
   enum OptType {
      FlagOption, ValueOption
   };
   enum OptStatus {
      Public, Protected, Private
   };
   enum ParseAction {
      IgnoreUnknown, RaiseError
   };
private:
   struct Cell {
      const char *option;      // option name
      OptType type;            // option type
      const char *description; // a description of option
      const char *value;       // value of option (string)
      Cell *next;              // pointer to the next cell
      OptStatus status;                // option status - public, private, etc

      Cell() { option = description = value = 0; next = 0; }
   };
private:
  Cell *table;                         // option table
  const char *ustring;                 // usage message
  char *pname;                         // program basename
  char optmarker;                      // option marker
  char dirmarker;                      // directory marker
  int opt_index;                       // index for non-options
  char **argV;                         // argument vector
  int argC;                            // argument count

  bool enrollDone;                     // finished enrolling
  int enrolledPublic;                  // Public options enrolled
  Cell *last;                          // last entry in option table

private:
   enum SCstatus { SC_ERROR, SC_TOKCONSUMED, SC_TOKNOTCONSUMED };
   char *basename(char * const p) const;
   SCstatus setcell(Cell *c, char *valtoken, char *nexttoken, const char *p);

   virtual void cleanup();
protected:
   void copy(const GetLongOpt &);
public:
   GetLongOpt();
   GetLongOpt(const GetLongOpt& c)     { copy(c); }
   virtual ~GetLongOpt()               { cleanup(); }

   GetLongOpt& operator=(const GetLongOpt&);

   char optmark() const                        { return optmarker; }
   void optmark(const char mark);
   char dirmark() const                        { return dirmarker; }
   void dirmark(const char mark);

   bool parse(int argc, char **argv,
                       const ParseAction a = RaiseError);
   bool parse(char * const str, char * const p,
                       const ParseAction a = RaiseError);

   bool enroll(const char * const opt, const OptType t,
      const char * const desc, const char * const val = 0,
      const OptStatus stat = GetLongOpt::Public);
   const char *retrieve(const char * const opt) const;

   int argCount() const                        { return (argC - opt_index); }
   const char *getarg(const int) const;

   void usage(ostream &outfile = cout) const;
   void usage(const char *str)                 { ustring = str; }

   void manpage(ostream &outfile = cout) const;

   void valuesP(ostream &outfile = cout) const;
   void values(ostream &outfile = cout) const;

   const char *progname() const                        { return pname; }
};

#endif // _GetLongOpt_h_
