/***********************************************************************
                           Dsim_register.h
                           Peter McClymont
                           University of Auckland.
 **********************************************************************/

#ifndef _Dsim_register_h_
#define _Dsim_register_h_

#include <assert.h>
#include <iostream.h>

#include "Dsim_types.h"

class Dsim_register {
friend ostream& operator<<(ostream&, const Dsim_register&);
private:
   char* name;
   // assuming that data is 32 bits long
   Dsim_data data;   

protected:
   virtual void cleanup();
   void copy(const Dsim_register&);


public:

   Dsim_register(char *n);
   Dsim_register(char *n, Dsim_data d);

   // in case Dsim_register is called with a Dsim_register make this 
   // a deep copy of the passed Dsim_register.
   Dsim_register(const Dsim_register& c)		{ copy(c); }

   // destructor calls cleanup()
   virtual ~Dsim_register()			{ cleanup(); }

   Dsim_register& operator=(const Dsim_register&);
   
   //methods to access data within
   //a register.
   Dsim_data getData();
   Dsim_data getUpper16();
   Dsim_data getLower16();
   Dsim_data getLU8();
   Dsim_data getLL8();

   //methods to modify the data within
   //a register
   void  setData(Dsim_data d);
   void  setUpper16(Dsim_data d);
   void  setLower16(Dsim_data d);
   void  setLU8(Dsim_data d);
   void  setLL8(Dsim_data d);

public:

};

#endif // _Dsim_register_h_
