/***********************************************************************
                           Dsim_processor.h
                           Peter McClymont
                           University of Auckland.
 **********************************************************************/

#ifndef _Dsim_processor_h_
#define _Dsim_processor_h_

#include <assert.h>
#include <iostream.h>

#include "Dsim_register.h"
#include "Dsim_core.h"
#include "Dsim_instruction.h"
#include "Dsim_decode.h"
#include "Dsim_syscall.h"

class Dsim_processor {


friend ostream& operator<<(ostream&, const Dsim_processor&);

private:
   Dsim_core* core;
   Dsim_syscall* sys;
   Dsim_decode* decoder;

protected:
   virtual void cleanup();
   void copy(const Dsim_processor&);

public:

   Dsim_processor(Dsim_core *c);
 
   // in case Dsim_processor is called with a Dsim_processor make this 
   // a deep copy of the passed Dsim_processor.
   Dsim_processor(const Dsim_processor& c){ copy(c); }

   // destructor calls cleanup()
   virtual ~Dsim_processor()	{ cleanup(); }

   Dsim_processor& operator=(const Dsim_processor&);

public:
   // maybe the registers don't need to be public
   // but are public for the time being for easier
   // access.
   int indentValue;
   //Dsim_syscall *sys;
  
   /** the data registers **/
   Dsim_register *EAX;
   Dsim_register *EBX;
   Dsim_register *ECX;
   Dsim_register *EDX;
   Dsim_register *EFLAG;

   /** pointer/index registers **/
   Dsim_register *ESP;
   Dsim_register *EBP;
   Dsim_register *ESI;
   Dsim_register *EDI;
   Dsim_register *EIP;
   Dsim_register *CS;
   Dsim_register *DS;
   Dsim_register *SS;
   Dsim_register *ES;
   Dsim_register *FS;
   Dsim_register *GS;
   Dsim_register *FPUControl;

   //Dsim_register *FLAG;
   Dsim_register* get_register(int regnum);
   //Dsim_register* get_register(char* name);
   int disasm(int *data, Dsim_instruction *curr_ins);
   void execute(Dsim_instruction* ins, int lendis);
   void getOffset(Dsim_instruction *curr_ins, int &length, int* &data);
   void getSIB(Dsim_instruction *curr_ins, int &length, int* &data);
   void setRMReg8(Dsim_instruction *curr_ins, int n);
   int getRMReg8(Dsim_instruction *curr_ins);
   void setData(int value, int bits, Dsim_instruction *curr_ins, int mod, int reg);
   void setRM(Dsim_instruction *curr_ins, int value, int bits); 

   int getSIB32(Dsim_instruction *curr_ins);
   int getRM32Address(Dsim_instruction *curr_ins);
   void setFlags32(int value);
   int getWord(int addr);
   void putWord(int addr, int word);
   int getReg8(Dsim_instruction *curr_ins);
   void setReg8(Dsim_instruction *curr_ins, int n);
   int getReg32(Dsim_instruction *curr_ins);
   void setReg32(Dsim_instruction *curr_ins, int n);
   void setReg16(Dsim_instruction *curr_ins, int n);
   void setRM32(Dsim_instruction *curr_ins, int value);
   void setRM16(Dsim_instruction *curr_ins, int value);
   void setRM8(Dsim_instruction *curr_ins, int value);
   int getRM32(Dsim_instruction *curr_ins);
   int getRM16(Dsim_instruction *curr_ins);
   int getRM8(Dsim_instruction *curr_ins);
   int getRM(Dsim_instruction *curr_ins);

   //int getReg32(Dsim_instruction *curr_ins);

   int getReg16(Dsim_instruction *curr_ins);
   bool getFlagStatus(int value);

   void setFlag(int value);

   void clearFlag(int value);

   void start();
   void cycle(int *sum);
   void print_def();
   void set_register8(int regnum, int value);
   int get_register8(int regnum);
   void putByte(int addr, int word);
   int getByte(int addr);
   void putDoubleWord(int addr, int word);
   int getDoubleWord(int addr);
   void setFlags32(long long c, long long b, long long value);
   void indent();


};

#endif // _Dsim_processor_h_
