/***********************************************************************
                          Dsim_main.cc
                          Peter McClymont
                     University of Auckland
************************************************************************/

#include <iostream.h>
#include <stdlib.h>


#include "GetLongOpt.h"
#include "Dsim_core.h"
#include "Dsim_error.h"
#include "Dsim_global.h"
#include "Dsim_processor.h"

// to hold all the command line params
GetLongOpt option;	

// the core of the simulator
Dsim_core core;			

// to enroll the options
static void enrollOptions();     

/**
 * The main method, the entry point in the program. It does some
 * argument checking and transfers the flow of control to Dsim_core
 * constructor.
 **/
int 
main(int num_args, char **args)
{  
   option.usage("[options] <executable filename>");
   enrollOptions(); 
  
   if ( option.parse(num_args, args) == false ) 
     return EXIT_FAILURE;
  
   if ( option.retrieve("help") ) {
     option.usage();
     return EXIT_SUCCESS;;
   }

   if ( option.retrieve("values") ) {
     option.values();
     return EXIT_SUCCESS; 
   }

   //starting up the core
   ::core.init();
   ::core.load();
    
   Dsim_processor *cpu = new Dsim_processor(&core);

   delete cpu;

   return EXIT_SUCCESS;

} // end of main method


/**
 * Enrolls the options, this uses
 * GetLongOpt and thus is taken from the Alpha
 * simulator.
 **/ 
static void
enrollOptions()
{

   // Options for help and identification.
   option.enroll("help", GetLongOpt::FlagOption,
      "print this option summary");
   option.enroll("values", GetLongOpt::FlagOption,
      "print the current values of options");

   // Core options.
   //option.enroll("environment", GetLongOpt::FlagOption,
   //   "load environment variables onto stack");
   option.enroll("coreSize", GetLongOpt::ValueOption,
      "set core size to $val bytes", "32388608");
   

   option.enroll("stackSize", GetLongOpt::ValueOption,
      "set stack size to $val bytes", "65536");

}//end of enrollOptions
