/***********************************************************************
                           Dsim_instruction.h
                           Peter McClymont
                           University of Auckland.
 **********************************************************************/

#ifndef _Dsim_instruction_h_
#define _Dsim_instruction_h_

#include <assert.h>
#include <iostream.h>

#include "Dsim_types.h"

class Dsim_instruction {
friend ostream& operator<<(ostream&, const Dsim_instruction&);
private:


   int operands;
   int prefixes[4];           /* instruction prefixes, if any */
   int noprefix;                       /* number of entries in above */
   int opcode;                        /* the opcode - not just the string */
   int opcode2;


   int relativeLength;
   int relative[4];			// relative information
   int immediateLength;
   int immediate[4];			// immediate information
   int offsetLength;
   int offset[4];		// offset information
   int modrm;
   int SIB;

    
protected:
   virtual void cleanup();
   void copy(const Dsim_instruction&);

public:

   Dsim_instruction();
 
   // in case Dsim_instruction is called with a Dsim_instruction make this 
   // a deep copy of the passed Dsim_instruction.
   Dsim_instruction(const Dsim_instruction& c)		{ copy(c); }

   // destructor calls cleanup()
   virtual ~Dsim_instruction()			{ cleanup(); }

   Dsim_instruction& operator=(const Dsim_instruction&);

public:
   // all the types of instructions
   enum InstType { 
   };

   int get_prefix(int index);
   int get_opcode();
   int get_opcode2();
   int get_numoperands();
   int get_numprefix();
   int getModRm();
   int getMod();
   int getReg();
   int getRm();
   int getImmediate(int index);
   int getImmediateLength();
   int getImmediate();
   int getShortImmediate();
   int getSIB();
   int getS();
   int getI();
   int getRelative();
   int getB();
   int getOffset();

   void set_opcode2(int op);
   void setOffsetLength(int length);
   void setOffset(int value, int index);
   void set_prefix(int prefix, int index);
   void set_opcode(int op);
   void set_numoperands(int numops);
   void set_numprefix(int n);
   void setModRm(int mod);
   void setImmediate(int value, int index);
   void setImmediateLength(int length);
   void setRelativeLength(int length);
   void setRelative(int value, int index);
   void setSIB(int value);

   void reset();

};

#endif // _Dsim_instruction_h_