/***********************************************************************
                          Dsim_instruction.cc
                          Peter McClymont
                     University of Auckland
************************************************************************/

#include "Dsim_instruction.h"
#include "Dsim_types.h"
#include "Dsim_error.h"

/**
 * overloaded operator << for use normally with cout.
 **/
ostream&
operator<<(ostream& os, const Dsim_instruction&)
{
   return os;
}

/**
 * main initial constructor.
 **/
Dsim_instruction::Dsim_instruction()
{
}

/**
 * cleanup is the actual function that does the 
 * the destruction . Called by the destructor.
 **/
void
Dsim_instruction::cleanup()
{
}

/**
 * deep copying . 
 **/
void
Dsim_instruction::copy(const Dsim_instruction&)
{
   assert(0);
}

/**
 * For things like Dsim_instruction a = b;
 * overloaded operator = 
 **/
Dsim_instruction&
Dsim_instruction::operator=(const Dsim_instruction& c)
{
   // making sure that the passed parameter 
   // is not itself.
   if ( this != &c ) {	
      // do a cleanup and copy.	
      cleanup(); copy(c);
   }

   return *this;
}

/**
 * sets the value of the opcode of the instruction
 * to the passed value.
 **/
void
Dsim_instruction::set_opcode(int op)
{
  opcode = op;
}

void
Dsim_instruction::set_opcode2(int op)
{
  opcode2 = op;
}

int
Dsim_instruction::get_opcode2()
{
   return opcode2;
}

/**
 * returns the integer value of the instruction's
 * opcode
 **/
int
Dsim_instruction::get_opcode()
{
   return opcode;
}


/**
 * sets one of the prefixes in the prefix array.
 * takes in the index value of the index in the
 * array.
 **/
void
Dsim_instruction::set_prefix(int prefix,int index)
{
  prefixes[index] = prefix;
}

/**
 * gets the prefix at a specified index in the
 * instruction.
 **/
int
Dsim_instruction::get_prefix(int index)
{
   return prefixes[index];
}


/**
 * sets the number of operands in the instruction.
 **/
void
Dsim_instruction::set_numoperands(int numop)
{
   operands = numop;
}

/**
 * gets the number of operands in the instrucion.
 **/
int
Dsim_instruction::get_numoperands()
{
   return operands;
}





















/**
 * sets the number of prefixes in the 
 * instruction.
 **/
void
Dsim_instruction::set_numprefix(int n)
{
   noprefix = n;
}

/**
 * retuns the number of prefixes in the 
 * instruction.
 **/
int
Dsim_instruction::get_numprefix()
{
   return noprefix;
}


void
Dsim_instruction::setModRm(int mod) {
  modrm = mod;
  }

int
Dsim_instruction::getModRm() {
  return modrm;
  }

int
Dsim_instruction::getMod() {
  return (modrm & 192) / 64;
  }

int
Dsim_instruction::getReg() {
  return (modrm & 56) / 8;
  }

int
Dsim_instruction::getRm() {
  return (modrm & 7);
  }

void
Dsim_instruction::setSIB(int value) {
  SIB = value;
  }

int
Dsim_instruction::getSIB() {
  return SIB;
  }

int
Dsim_instruction::getS() {
  return (SIB & 192) / 64;
  }

int
Dsim_instruction::getI() {
  return (SIB & 56) / 8;
  }

int
Dsim_instruction::getB() {
  return (SIB & 7);
  }

int
Dsim_instruction::getImmediateLength() {
  return immediateLength;
  }

void
Dsim_instruction::setImmediateLength(int length) {
  immediateLength = length;
  }

int
Dsim_instruction::getImmediate(int index) {
  return immediate[index];
  }

void
Dsim_instruction::setImmediate(int value, int index) {
  if (index > 3) {
    Dsim_error err("Internal program error in Instruction - setImmediate", true);  
    }
  immediate[index] = value;
  }

int
Dsim_instruction::getShortImmediate() {
  return immediate[0];
  }

int
Dsim_instruction::getImmediate() {
  if (immediateLength > 4) return 0;
  int result = immediate[0], multiple = 256;
  for(int n = 1; n < immediateLength; n++) {
    result = result + (immediate[n] * multiple);
    multiple = multiple * 256;
    }
  return result;
  }



int
Dsim_instruction::getOffset() {
  if (offsetLength > 4) return 0;
  int result = offset[0], multiple = 256;
  for(int n = 1; n < offsetLength; n++) {
    result = result + (offset[n] * multiple);
    multiple = multiple * 256;
    }
  return result;
  }

void
Dsim_instruction::setOffsetLength(int length) {
  offsetLength = length;
  }

void
Dsim_instruction::setOffset(int value, int index) {
  if (index > 3) {
    Dsim_error err("Internal program error in instruction - setOffset", true);
    }
  offset[index] = value;
  }



int
Dsim_instruction::getRelative() {
  if (relativeLength > 4) return 0;
  int result = relative[0], multiple = 256;
  for(int n = 1; n < relativeLength; n++) {
    result = result + (relative[n] * multiple);
    multiple = multiple * 256;
    }
  
  if (relativeLength == 1 & ((result & 0x80) == 0x80)) {
    result = result ^ 255;
    result = (result + 1) * -1;     // twos compliment
    }
 
  return result;
   }

void
Dsim_instruction::setRelativeLength(int length) {
  relativeLength = length;
  }

void
Dsim_instruction::setRelative(int value, int index) {
  if (index > 3) {
    Dsim_error err("Internal program error in instruction - setRelative", true);
    }
  relative[index] = value;
  }

void
Dsim_instruction::reset() {
   operands = 0;
   prefixes[0] = 0;
   prefixes[1] = 0;
   prefixes[2] = 0;
   prefixes[3] = 0;
   noprefix = 0;
   opcode = 0;
   opcode2 = 0;
   relativeLength = 0;
   relative[0] = 0;
   relative[1] = 0;
   relative[2] = 0;
   relative[3] = 0;
   immediateLength = 0;
   immediate[0] = 0;
   immediate[1] = 0;
   immediate[2] = 0;
   immediate[3] = 0;
   offsetLength = 0;
   offset[0] = 0;
   offset[1] = 0;
   offset[2] = 0;
   offset[3] = 0;
   modrm = 0;
   SIB = 0;
   }
