/***********************************************************************
                          Dsim_error.cc
                          Peter McClymont
                     University of Auckland
************************************************************************/
#include <iostream.h>

#include "Dsim_error.h"

/**
 * overloaded operator << for use normally with cout.
 **/
ostream&
operator<<(ostream& os, const Dsim_error&)
{
   return os;
}

/**
 * main initial constructor.
 * Must have error message in constructor.
 **/
Dsim_error::Dsim_error(char *error_message)
{
   print_message(error_message);
}

/**
 * overloaded initial constructor.
 * requires the message and a boolean which
 * tells whether this error is fatal or not
 **/
Dsim_error::Dsim_error(char *error_message , bool fatal)
{
   print_message(error_message);
   // in case of fatal , quit the program.
   if(fatal){
      cout << "error is fatal ... quitting !!!" << endl;
      exit(-1);
   }
}

/**
 * method print_message, prints out a given message
 * with an end of line character at its end.
 **/
void
Dsim_error::print_message(char *message)
{
   cout << message << endl;
}

/**
 * cleanup is the actual function that does the 
 * the destruction . Called by the destructor.
 **/
void
Dsim_error::cleanup()
{
}

/**
 * deep copying . 
 **/
void
Dsim_error::copy(const Dsim_error&)
{
   assert(0);
}

/**
 * For things like Dsim_error a = b;
 * overloaded operator = 
 **/
Dsim_error&
Dsim_error::operator=(const Dsim_error& c)
{
   // making sure that the passed parameter 
   // is not itself.
   if ( this != &c ) {	
      // do a cleanup and copy.	
      cleanup(); copy(c);
   }

   return *this;
}

