/***********************************************************************
                           Dsim_elfer.h
                           Peter McClymont
                           University of Auckland.
 **********************************************************************/

#ifndef _Dsim_elfer_h_
#define _Dsim_elfer_h_

#include <assert.h>
#include <iostream.h>
#include <elf.h>
#include <libelf/libelf.h>

#include "GetLongOpt.h"
#include "Dsim_global.h"
#include "Dsim_types.h"

class Dsim_elfer {

   friend ostream& operator<<(ostream&, const Dsim_elfer&);

private:
   const char *file_name;     // the name of input file.
   Elf32_Shdr *shdr;	// an Elf section header.
   Elf32_Ehdr *ehdr;	// the Elf header.
   Elf32_Phdr *phdr;	// the program header.
   Elf *elf;		// the Elf descriptor
   Elf_Scn *scn;	// an Elf section.
   Elf_Data *data;	// Elf data type.
   Elf32_Off textOff;	// Elf offset. 
   Dsim_address textEntry; // entry point address of text segment.
   Dsim_address dataEntry; // entry point address of data segment.
   Dsim_address bssEntry;  // entry point address of bss segment.
   long textOffset;     // offset till the text section.
   long dataOffset;     // offset till the data section.
   long textSize;       // the size of the text segment.
   long dataSize;	// the size of the data segment.
   long bssSize;        // the size of the bss segment.
   char* textSet;       // temporarily store the textSet.

protected:
   virtual void cleanup();
   void copy(const Dsim_elfer&);
   void start_reading();
   bool validate();

public:
   Dsim_elfer(const char *filename);
   Dsim_elfer(const Dsim_elfer& c)		{ copy(c); }
   virtual ~Dsim_elfer()			{ cleanup(); }
   Dsim_elfer& operator=(const Dsim_elfer&);
   Dsim_address getEntry();
   Dsim_address getTextSegEntry();
   Dsim_address getDataSegEntry();
   Dsim_address getBssSegEntry();
   
   int getTextSegOffset();

   long getTextSegSize();
   long getDataSegSize();
   long getBssSegSize();

   void fill_text(char* store);
   void fill_data(char* store);


public:

};

#endif // _Dsim_elfer_h_
