/***********************************************************************
                          Dsim_decode.cc
                          Peter McClymont
                     University of Auckland
************************************************************************/
#include <iostream.h>
#include <stdio.h>

#include "Dsim_decode.h"

/**
 * overloaded operator << for use normally with cout.
 **/
ostream&
operator<<(ostream& os, const Dsim_decode&)
{
   return os;
}


/**
 * main initial constructor.
 **/
Dsim_decode::Dsim_decode()
{
}

int Dsim_decode::disasm(int *data, Dsim_instruction *curr_ins)
{


  int length = 0;

  // Scan for prefixes

  int noPrefixes = 0, value;
  bool operandOveride = false;
  
    while(true) {
      if (*data == 0xF3 || *data == 0xF2) { // repeat
        curr_ins->set_prefix((int)*data, noPrefixes);
        noPrefixes++;
        length++;
        break;
        }
      else if (*data == 0xF0) { // lock
        curr_ins->set_prefix((int)*data++, noPrefixes);
        noPrefixes++;
        length++;
        }
      else if (*data == 0x2E || *data == 0x36 || *data == 0x3E || *data == 0x26 || *data == 0x64 || *data == 0x65) {  // Segment overide
        curr_ins->set_prefix((int)*data++, noPrefixes);
        noPrefixes++;
        length++;
        }
      else if (*data == 0x66) { // Operand size overide
        operandOveride = true;
	  curr_ins->set_prefix((int)*data++, noPrefixes);
        noPrefixes++;
        length++;
        }
      else if (*data == 0x67) { // segment size overide
        curr_ins->set_prefix((int)*data++, noPrefixes);
        noPrefixes++;
        length++;
        }
      else break;
    }
    
    curr_ins->set_numprefix(noPrefixes);

    switch(*data)
      {
      case 0x00:
        length++;
        length++;
        curr_ins->set_opcode((int)*data++);
        curr_ins->setModRm((int)*data++);
        getSIB(curr_ins, length, data);
        getOffset(curr_ins, length, data);
        printf("ADD r/m8,r8 \n");
        break;
      case 0x01:
        length++;
        length++;
        curr_ins->set_opcode((int)*data++);
        curr_ins->setModRm((int)*data++);
        getSIB(curr_ins, length, data);
        getOffset(curr_ins, length, data);
        printf("ADD r/m32,r32\n");
        break;
      case 0x03:
        length++;
        length++;
        curr_ins->set_opcode((int)*data++);
        curr_ins->setModRm(*data++);
        getSIB(curr_ins, length, data);
        getOffset(curr_ins, length, data);
        printf("ADD r8,r/m8\n");
        break;
      case 0x04:
        length++;
        length++;
        curr_ins->set_opcode((int)*data++);
        curr_ins->setImmediateLength(1);
        curr_ins->setImmediate((int)*data++, 0);
        printf("ADD AL,imm8\n");
        break;
      case 0x05:
        length= length + 5;
        curr_ins->set_opcode((int)*data++);
        curr_ins->setImmediateLength(4);
        curr_ins->setImmediate((int)*data++, 0);
        curr_ins->setImmediate((int)*data++, 1);
        curr_ins->setImmediate((int)*data++, 2);
        curr_ins->setImmediate((int)*data++, 3);
        printf("ADD EAX,imm32\n");
        break;
      case 0x06:
        length++;
        curr_ins->set_opcode((int)*data++);
        printf("PUSH ES\n");
        break;
      case 0x07:
        length++;
        curr_ins->set_opcode((int)*data++);
        printf("POP ES\n");
        break;
      case 0x08:
        length++;
        length++;
        curr_ins->set_opcode((int)*data++);
        curr_ins->setModRm(*data++);
        getSIB(curr_ins, length, data);
        getOffset(curr_ins, length, data);
        printf("OR r8,r/m8\n");
        break;
      case 0x09:
        length++;
        length++;
        curr_ins->set_opcode((int)*data++);
        curr_ins->setModRm(*data++);
        getSIB(curr_ins, length, data);
        getOffset(curr_ins, length, data);
        printf("OR r16,r/m16\n");
        break;
      case 0x0a:
        length++;
        length++;
        curr_ins->set_opcode((int)*data++);
        curr_ins->setModRm(*data++);
        getSIB(curr_ins, length, data);
        getOffset(curr_ins, length, data);
        printf("OR r8,r/m8\n");
        break;
      case 0x0b:
        length++;
        length++;
        curr_ins->set_opcode((int)*data++);
        curr_ins->setModRm(*data++);
        getSIB(curr_ins, length, data);
        getOffset(curr_ins, length, data);
        printf("OR r32,r/m32\n");
        break;
      case 0x0c:
        length++;
        length++;
        curr_ins->set_opcode((int)*data++);
        curr_ins->setImmediateLength(1);
        curr_ins->setImmediate((int)*data++, 0);
        printf("OR AL,imm8\n");
        break;
      case 0x0d:
        length = length + 5;
        curr_ins->set_opcode((int)*data++);
        curr_ins->setImmediateLength(4);
        curr_ins->setImmediate((int)*data++, 0);
        curr_ins->setImmediate((int)*data++, 1);
        curr_ins->setImmediate((int)*data++, 2);
        curr_ins->setImmediate((int)*data++, 3);
        printf("OR EAX,imm32\n");
        break;
      case 0x0f:
        length++;
        curr_ins->set_opcode((int)*data++);
        switch(*data) {
          case 0x80:
            length = length + 5;
            curr_ins->set_opcode2((int)*data++);
            curr_ins->setRelativeLength(4);
            curr_ins->setRelative((int)*data++, 0);
            curr_ins->setRelative((int)*data++, 1);
            curr_ins->setRelative((int)*data++, 2);
            curr_ins->setRelative((int)*data++, 3);
            printf("JO rel32\n");
            break;
          case 0x81:
            length = length + 5;
            curr_ins->set_opcode2((int)*data++);
            curr_ins->setRelativeLength(4);
            curr_ins->setRelative((int)*data++, 0);
            curr_ins->setRelative((int)*data++, 1);
            curr_ins->setRelative((int)*data++, 2);
            curr_ins->setRelative((int)*data++, 3);
            printf("JNO rel32\n");
            break;
         case 0x82:
            length = length + 5;
            curr_ins->set_opcode2((int)*data++);
            curr_ins->setRelativeLength(4);
            curr_ins->setRelative((int)*data++, 0);
            curr_ins->setRelative((int)*data++, 1);
            curr_ins->setRelative((int)*data++, 2);
            curr_ins->setRelative((int)*data++, 3);
            printf("JB rel32\n");
            break;
          case 0x83:
            length = length + 5;
            curr_ins->set_opcode2((int)*data++);
            curr_ins->setRelativeLength(4);
            curr_ins->setRelative((int)*data++, 0);
            curr_ins->setRelative((int)*data++, 1);
            curr_ins->setRelative((int)*data++, 2);
            curr_ins->setRelative((int)*data++, 3);
            printf("JAE rel32\n");
            break;
         case 0x84:
            length = length + 5;
            curr_ins->set_opcode2((int)*data++);
            curr_ins->setRelativeLength(4);
            curr_ins->setRelative((int)*data++, 0);
            curr_ins->setRelative((int)*data++, 1);
            curr_ins->setRelative((int)*data++, 2);
            curr_ins->setRelative((int)*data++, 3);
            printf("JE rel32\n");
            break;
          case 0x85:
            length = length + 5;
            curr_ins->set_opcode2((int)*data++);
            curr_ins->setRelativeLength(4);
            curr_ins->setRelative((int)*data++, 0);
            curr_ins->setRelative((int)*data++, 1);
            curr_ins->setRelative((int)*data++, 2);
            curr_ins->setRelative((int)*data++, 3);
            printf("JNE rel32\n");
            break;
          case 0x86:
            length = length + 5;
            curr_ins->set_opcode2((int)*data++);
            curr_ins->setRelativeLength(4);
            curr_ins->setRelative((int)*data++, 0);
            curr_ins->setRelative((int)*data++, 1);
            curr_ins->setRelative((int)*data++, 2);
            curr_ins->setRelative((int)*data++, 3);
            printf("JBE rel32\n");
            break;
          case 0x87:
            length = length + 5;
            curr_ins->set_opcode2((int)*data++);
            curr_ins->setRelativeLength(4);
            curr_ins->setRelative((int)*data++, 0);
            curr_ins->setRelative((int)*data++, 1);
            curr_ins->setRelative((int)*data++, 2);
            curr_ins->setRelative((int)*data++, 3);
            printf("JA rel32\n");
            break;
          case 0x88:
            length = length + 5;
            curr_ins->set_opcode2((int)*data++);
            curr_ins->setRelativeLength(4);
            curr_ins->setRelative((int)*data++, 0);
            curr_ins->setRelative((int)*data++, 1);
            curr_ins->setRelative((int)*data++, 2);
            curr_ins->setRelative((int)*data++, 3);
            printf("JSS rel32\n");
            break;
          case 0x89:
            length = length + 5;
            curr_ins->set_opcode2((int)*data++);
            curr_ins->setRelativeLength(4);
            curr_ins->setRelative((int)*data++, 0);
            curr_ins->setRelative((int)*data++, 1);
            curr_ins->setRelative((int)*data++, 2);
            curr_ins->setRelative((int)*data++, 3);
            printf("JNS rel32\n");
            break;
          case 0x8a:
            length = length + 5;
            curr_ins->set_opcode2((int)*data++);
            curr_ins->setRelativeLength(4);
            curr_ins->setRelative((int)*data++, 0);
            curr_ins->setRelative((int)*data++, 1);
            curr_ins->setRelative((int)*data++, 2);
            curr_ins->setRelative((int)*data++, 3);
            printf("JPE rel32\n");
            break;
          case 0x8b:
            length = length + 5;
            curr_ins->set_opcode2((int)*data++);
            curr_ins->setRelativeLength(4);
            curr_ins->setRelative((int)*data++, 0);
            curr_ins->setRelative((int)*data++, 1);
            curr_ins->setRelative((int)*data++, 2);
            curr_ins->setRelative((int)*data++, 3);
            printf("JPO rel32\n");
            break;
          case 0x8c:
            length = length + 5;
            curr_ins->set_opcode2((int)*data++);
            curr_ins->setRelativeLength(4);
            curr_ins->setRelative((int)*data++, 0);
            curr_ins->setRelative((int)*data++, 1);
            curr_ins->setRelative((int)*data++, 2);
            curr_ins->setRelative((int)*data++, 3);
            printf("JL rel32\n");
            break;
          case 0x8d:
            length = length + 5;
            curr_ins->set_opcode2((int)*data++);
            curr_ins->setRelativeLength(4);
            curr_ins->setRelative((int)*data++, 0);
            curr_ins->setRelative((int)*data++, 1);
            curr_ins->setRelative((int)*data++, 2);
            curr_ins->setRelative((int)*data++, 3);
            printf("JGE rel32\n");
            break;
          case 0x8e:
            length = length + 5;
            curr_ins->set_opcode2((int)*data++);
            curr_ins->setRelativeLength(4);
            curr_ins->setRelative((int)*data++, 0);
            curr_ins->setRelative((int)*data++, 1);
            curr_ins->setRelative((int)*data++, 2);
            curr_ins->setRelative((int)*data++, 3);
            printf("JLE rel32\n");
            break;
          case 0x8f:
            length = length + 5;
            curr_ins->set_opcode2((int)*data++);
            curr_ins->setRelativeLength(4);
            curr_ins->setRelative((int)*data++, 0);
            curr_ins->setRelative((int)*data++, 1);
            curr_ins->setRelative((int)*data++, 2);
            curr_ins->setRelative((int)*data++, 3);
            printf("JG rel32\n");
            break;
          case 0x94:
            length = length + 2;
            curr_ins->set_opcode2((int)*data++);
            curr_ins->setModRm(*data++);
            printf("SETE r/m8\n");
            break;
          case 0x95:
            length = length + 2;
            curr_ins->set_opcode2((int)*data++);
            curr_ins->setModRm(*data++);
            printf("SETNE r/m8\n");
            break;
          case 0x9f:
            length = length + 2;
            curr_ins->set_opcode2((int)*data++);
            curr_ins->setModRm(*data++);
            printf("SETG r/m8\n");
            break;
          case 0xa5:
            length = length + 2;
            curr_ins->set_opcode2((int)*data++);
            curr_ins->setModRm(*data++);
            getSIB(curr_ins, length, data);
            getOffset(curr_ins, length, data);
            printf("SHLD r/m32,r32,CL\n");
            break;
          case 0xad:
            length = length + 2;
            curr_ins->set_opcode2((int)*data++);
            curr_ins->setModRm(*data++);
            getSIB(curr_ins, length, data);
            getOffset(curr_ins, length, data);
            printf("SHRD r/m32,r32,CL\n");
            break;
          case 0xaf:
            length = length + 2;
            curr_ins->set_opcode2((int)*data++);
            curr_ins->setModRm(*data++);
            getSIB(curr_ins, length, data);
            getOffset(curr_ins, length, data);
            printf("IMUL r32,r/m32\n");
            break;
          case 0xb6:
            length = length + 2;
            curr_ins->set_opcode2((int)*data++);
            curr_ins->setModRm(*data++);
            getSIB(curr_ins, length, data);
            getOffset(curr_ins, length, data);
            printf("MOVZBL r32,r/m32\n");
            break;
         case 0xb7:
            length = length + 2;
            curr_ins->set_opcode2((int)*data++);
            curr_ins->setModRm(*data++);
            getSIB(curr_ins, length, data);
            getOffset(curr_ins, length, data);
            printf("MOVZX r32,r/m16\n");
            break;
          case 0xbc:
            length = length + 2;
            curr_ins->set_opcode2((int)*data++);
            curr_ins->setModRm(*data++);
            getSIB(curr_ins, length, data);
            getOffset(curr_ins, length, data);
            printf("BSF r32,r/m32\n");
            break;
          case 0xbd:
            length = length + 2;
            curr_ins->set_opcode2((int)*data++);
            curr_ins->setModRm(*data++);
            getSIB(curr_ins, length, data);
            getOffset(curr_ins, length, data);
            printf("BSR r32,r/m32\n");
            break;
          case 0xbe:
            length = length + 2;
            curr_ins->set_opcode2((int)*data++);
            curr_ins->setModRm(*data++);
            getSIB(curr_ins, length, data);
            getOffset(curr_ins, length, data);
            printf("MOVSBL (reg32),reg32\n");
            break;
          default:
            printf("Cannot decode instruction ...................\n");
            break;
         }
        break;
      case 0x13:
        length++;
        length++;
        curr_ins->set_opcode((int)*data++);
        curr_ins->setModRm(*data++);
        getSIB(curr_ins, length, data);
        getOffset(curr_ins, length, data);
        printf("ADC r32,r/m32\n");
        break;
      case 0x19:
        length++;
        length++;
        curr_ins->set_opcode((int)*data++);
        curr_ins->setModRm(*data++);
        getSIB(curr_ins, length, data);
        getOffset(curr_ins, length, data);
        printf("SBB r/m32,r32\n");
        break;
      case 0x1b:
        length++;
        length++;
        curr_ins->set_opcode((int)*data++);
        curr_ins->setModRm(*data++);
        getSIB(curr_ins, length, data);
        getOffset(curr_ins, length, data);
        printf("SBB r32,r/m32\n");
        break;
      case 0x20:
        length++;
        length++;
        curr_ins->set_opcode((int)*data++);
        curr_ins->setModRm(*data++);
        getSIB(curr_ins, length, data);
        getOffset(curr_ins, length, data);
        printf("AND r/m8,r8\n");
        break;
      case 0x21:
        length++;
        length++;
        curr_ins->set_opcode((int)*data++);
        curr_ins->setModRm(*data++);
        getSIB(curr_ins, length, data);
        getOffset(curr_ins, length, data);
        printf("AND r/m32,r32\n");
        break;
      case 0x23:
        length++;
        length++;
        curr_ins->set_opcode((int)*data++);
        curr_ins->setModRm(*data++);
        getSIB(curr_ins, length, data);
        getOffset(curr_ins, length, data);
        printf("AND r32,r/m32\n");
        break;
      case 0x24:
        length++;
        length++;
        curr_ins->set_opcode((int)*data++);
        curr_ins->setImmediateLength(1);
        curr_ins->setImmediate((int)*data++, 0);
        printf("AND AL,imm8\n");
        break;
      case 0x25:
        length = length + 3;
        curr_ins->set_opcode((int)*data++);
        curr_ins->setImmediateLength(2);
        curr_ins->setImmediate((int)*data++, 0);
        curr_ins->setImmediate((int)*data++, 1);
        if (operandOveride == false) {
          length = length + 2;
          curr_ins->setImmediateLength(4);
          curr_ins->setImmediate((int)*data++, 2);
          curr_ins->setImmediate((int)*data++, 3);
          }
        printf("AND eax,imm32\n");
        break;
      case 0x28:
        length++;
        length++;
        curr_ins->set_opcode((int)*data++);
        curr_ins->setModRm(*data++);
        getSIB(curr_ins, length, data);
        getOffset(curr_ins, length, data);
        printf("SUB r/m8,r8\n");
        break;
      case 0x2b:
        length++;
        length++;
        curr_ins->set_opcode((int)*data++);
        curr_ins->setModRm(*data++);
        getSIB(curr_ins, length, data);
        getOffset(curr_ins, length, data);
        printf("SUB r/m32,r32 \n");
        break;
      case 0x29:
        length++;
        length++;
        curr_ins->set_opcode((int)*data++);
        curr_ins->setModRm(*data++);
        getSIB(curr_ins, length, data);
        getOffset(curr_ins, length, data);
        printf("SUBL r/m32,r32\n");
        break;
      case 0x30:
        length++;
        length++;
        curr_ins->set_opcode((int)*data++);
        curr_ins->setModRm(*data++);
        printf("XOR r/m8,r8\n");
        break;
      case 0x31:
        length++;
        length++;
        curr_ins->set_opcode((int)*data++);
        curr_ins->setModRm(*data++);
        printf("XOR r/m32,r32\n");
        break;
      case 0x34:
        length = length + 2;
        curr_ins->set_opcode((int)*data++);
        curr_ins->setImmediateLength(1);
        curr_ins->setImmediate((int)*data++, 0);
        printf("XOR AL,imm8\n");
        break;
      case 0x35:
        length = length + 5;
        curr_ins->set_opcode((int)*data++);
        curr_ins->setImmediateLength(4);
        curr_ins->setImmediate((int)*data++, 0);
        curr_ins->setImmediate((int)*data++, 1);
        curr_ins->setImmediate((int)*data++, 2);
        curr_ins->setImmediate((int)*data++, 3);
        printf("XOR EAX,imm32\n");
        break;
      case 0x38:
        length++;
        length++;
        curr_ins->set_opcode((int)*data++);
        curr_ins->setModRm(*data++);
        getSIB(curr_ins, length, data);
        getOffset(curr_ins, length, data);
        printf("CMP r/m8,r8\n");
        break;
      case 0x39:
        length++;
        length++;
        curr_ins->set_opcode((int)*data++);
        curr_ins->setModRm(*data++);
        getSIB(curr_ins, length, data);
        getOffset(curr_ins, length, data);
        printf("CMPL r/m32,r32 \n");
        break;
      case 0x3b:
        length++;
        length++;
        curr_ins->set_opcode((int)*data++);
        curr_ins->setModRm(*data++);
        getSIB(curr_ins, length, data);
        getOffset(curr_ins, length, data);
        printf("CMP r32,r/m32\n");
        break;
      case 0x3c:
        length = length + 2;
        curr_ins->set_opcode((int)*data++);
        curr_ins->setImmediateLength(1);
        curr_ins->setImmediate((int)*data++, 0);
        printf("CMP AL,imm8\n");
        break;
      case 0x3d:
        length = length + 5;
        curr_ins->set_opcode((int)*data++);
        curr_ins->setImmediateLength(4);
        curr_ins->setImmediate((int)*data++, 0);
        curr_ins->setImmediate((int)*data++, 1);
        curr_ins->setImmediate((int)*data++, 2);
        curr_ins->setImmediate((int)*data++, 3);
        printf("CMPL eax, imm32 \n");
        break;
      case 0x40:case 0x41:case 0x42:case 0x43:
      case 0x44:case 0x45:case 0x46:case 0x47:
        length++;
        curr_ins->set_opcode((int)*data++);
        printf("INC r32 \n");
        break;
      case 0x48:case 0x49:case 0x4a:case 0x4b:
      case 0x4c:case 0x4d:case 0x4e:case 0x4f:
        length++;
        curr_ins->set_opcode((int)*data++);
        printf("DEC r32 \n");
        break;
      case 0x50:case 0x51:case 0x52:case 0x53:
      case 0x54:case 0x55:case 0x56:case 0x57:
        length++;
        curr_ins->set_opcode((int)*data++);
        printf("PUSH r32 \n");
        break;

      case 0x58:case 0x59:case 0x5a:case 0x5b:
      case 0x5c:case 0x5d:case 0x5e:case 0x5f:
        length++;
        curr_ins->set_opcode((int)*data++);
        printf("POP r32 \n");
        break;
      case 0x60:
        length++;
        curr_ins->set_opcode((int)*data++);
        printf("PUSHAD\n");
        break;
      case 0x68:
        length = length + 5;
        curr_ins->set_opcode((int)*data++);
        curr_ins->setImmediateLength(4);
        curr_ins->setImmediate((int)*data++, 0);
        curr_ins->setImmediate((int)*data++, 1);
        curr_ins->setImmediate((int)*data++, 2);
        curr_ins->setImmediate((int)*data++, 3);
        printf("PUSH imm32 \n");
        break;
      case 0x6a:
        length++;
        length++;
        curr_ins->set_opcode((int)*data++);
        curr_ins->setImmediateLength(1);
        curr_ins->setImmediate((int)*data++, 0);
        printf("PUSH imm8\n");
        break;
      case 0x70:
        length++;
        length++;
        curr_ins->set_opcode((int)*data++);
        curr_ins->setRelativeLength(1);
        curr_ins->setRelative((int)*data++, 0);
        printf("JO rel8\n");
        break;
      case 0x71:
        length++;
        length++;
        curr_ins->set_opcode((int)*data++);
        curr_ins->setRelativeLength(1);
        curr_ins->setRelative((int)*data++, 0);
        printf("JNO rel8\n");
        break;
      case 0x72:
        length++;
        length++;
        curr_ins->set_opcode((int)*data++);
        curr_ins->setRelativeLength(1);
        curr_ins->setRelative((int)*data++, 0);
        printf("JB rel8\n");
        break;
      case 0x73:
        length++;
        length++;
        curr_ins->set_opcode((int)*data++);
        curr_ins->setRelativeLength(1);
        curr_ins->setRelative((int)*data++, 0);
        printf("JAE rel8\n");
        break;
      case 0x74:
        length++;
        length++;
        curr_ins->set_opcode((int)*data++);
        curr_ins->setRelativeLength(1);
        curr_ins->setRelative((int)*data++, 0);
        printf("JE rel8\n");
        break;
      case 0x75:
        length++;
        length++;
        curr_ins->set_opcode((int)*data++);
        curr_ins->setRelativeLength(1);
        curr_ins->setRelative((int)*data++, 0);
        printf("JNE rel8\n");
        break;
      case 0x76:
        length++;
        length++;
        curr_ins->set_opcode((int)*data++);
        curr_ins->setRelativeLength(1);
        curr_ins->setRelative((int)*data++, 0);
        printf("JBE rel8\n");
        break;
      case 0x77:
        length++;
        length++;
        curr_ins->set_opcode((int)*data++);
        curr_ins->setRelativeLength(1);
        curr_ins->setRelative((int)*data++, 0);
        printf("JA rel8\n");
        break;
      case 0x78:
        length++;
        length++;
        curr_ins->set_opcode((int)*data++);
        curr_ins->setRelativeLength(1);
        curr_ins->setRelative((int)*data++, 0);
        printf("JS rel8\n");
        break;
      case 0x79:
        length++;
        length++;
        curr_ins->set_opcode((int)*data++);
        curr_ins->setRelativeLength(1);
        curr_ins->setRelative((int)*data++, 0);
        printf("JNS rel8\n");
        break;
      case 0x7a:
        length++;
        length++;
        curr_ins->set_opcode((int)*data++);
        curr_ins->setRelativeLength(1);
        curr_ins->setRelative((int)*data++, 0);
        printf("JPE rel8\n");
        break;
      case 0x7b:
        length++;
        length++;
        curr_ins->set_opcode((int)*data++);
        curr_ins->setRelativeLength(1);
        curr_ins->setRelative((int)*data++, 0);
        printf("JPO rel8\n");
        break;
      case 0x7c:
        length++;
        length++;
        curr_ins->set_opcode((int)*data++);
        curr_ins->setRelativeLength(1);
        curr_ins->setRelative((int)*data++, 0);
        printf("JL rel8\n");
        break;
      case 0x7d:
        length++;
        length++;
        curr_ins->set_opcode((int)*data++);
        curr_ins->setRelativeLength(1);
        curr_ins->setRelative((int)*data++, 0);
        printf("JNL rel8\n");
        break;
      case 0x7e:
        length++;
        length++;
        curr_ins->set_opcode((int)*data++);
        curr_ins->setRelativeLength(1);
        curr_ins->setRelative((int)*data++, 0);
        printf("JLE rel8\n");
        break;
      case 0x7f:
        length++;
        length++;
        curr_ins->set_opcode((int)*data++);
        curr_ins->setRelativeLength(1);
        curr_ins->setRelative((int)*data++, 0);
        printf("JG rel8\n");
        break;
      case 0x81:
        length++;
        length++;
        curr_ins->set_opcode((int)*data++);
        curr_ins->setModRm(*data++);
        getSIB(curr_ins, length, data);
        getOffset(curr_ins, length, data);
        switch (curr_ins->getReg()) {
        case 0x00:
          length = length + 4;
          curr_ins->setImmediateLength(4);
          curr_ins->setImmediate((int)*data++, 0);
          curr_ins->setImmediate((int)*data++, 1);
          curr_ins->setImmediate((int)*data++, 2);
          curr_ins->setImmediate((int)*data++, 3);
          printf("ADD r/m32, imm32\n");
          break;
        case 0x01:
          length = length + 4;
          curr_ins->setImmediateLength(4);
          curr_ins->setImmediate((int)*data++, 0);
          curr_ins->setImmediate((int)*data++, 1);
          curr_ins->setImmediate((int)*data++, 2);
          curr_ins->setImmediate((int)*data++, 3);
          printf("OR r/m32,imm32\n");
          break;
        case 0x04:
          length = length + 2;
          curr_ins->setImmediateLength(2);
          curr_ins->setImmediate((int)*data++, 0);
          curr_ins->setImmediate((int)*data++, 1);
          if (operandOveride == false) {
            length = length + 2;
            curr_ins->setImmediate((int)*data++, 2);
            curr_ins->setImmediate((int)*data++, 3);
            curr_ins->setImmediateLength(4);
            }
          printf("AND r/m32, imm32\n");
          break;
        case 0x05:
          length = length + 4;
          curr_ins->setImmediateLength(4);
          curr_ins->setImmediate((int)*data++, 0);
          curr_ins->setImmediate((int)*data++, 1);
          curr_ins->setImmediate((int)*data++, 2);
          curr_ins->setImmediate((int)*data++, 3);
          printf("SUB r/m32,imm32\n");
          break;
        case 0x06:
          length = length + 4;
          curr_ins->setImmediateLength(4);
          curr_ins->setImmediate((int)*data++, 0);
          curr_ins->setImmediate((int)*data++, 1);
          curr_ins->setImmediate((int)*data++, 2);
          curr_ins->setImmediate((int)*data++, 3);
          printf("XOR r/m32,imm32\n");
          break;
        case 0x07:
          length = length + 4;
          curr_ins->setImmediateLength(4);
          curr_ins->setImmediate((int)*data++, 0);
          curr_ins->setImmediate((int)*data++, 1);
          curr_ins->setImmediate((int)*data++, 2);
          curr_ins->setImmediate((int)*data++, 3);
          printf("CMPL r/m32, imm32\n");
          break;
          }
        break;
      case 0x80:
        length++;
        length++;
        curr_ins->set_opcode((int)*data++);
        curr_ins->setModRm(*data++);
        getSIB(curr_ins, length, data);
        getOffset(curr_ins, length, data);
        switch(curr_ins->getReg()) {
          case 0x00:
            length = length + 1;
            curr_ins->setImmediateLength(1);
            curr_ins->setImmediate((int)*data++, 0);
            printf("ADD r/m8,imm8\n");
            break;
          case 0x01:
            length = length + 1;
            curr_ins->setImmediateLength(1);
            curr_ins->setImmediate((int)*data++, 0);
            printf("OR r/m32, imm32\n");
            break;
          case 0x04:
            length++;
            curr_ins->setImmediateLength(1);
            curr_ins->setImmediate((int)*data++, 0);
            printf("AND r/m8,imm8\n");
            break;
          case 0x06:
            length++;
            curr_ins->setImmediateLength(1);
            curr_ins->setImmediate((int)*data++, 0);
            printf("XOR r/m8,imm8\n");
            break;
          case 0x07:
            curr_ins->setImmediateLength(1);
            curr_ins->setImmediate((int)*data++, 0);
            length++;
            printf("CMP r/m8,imm8\n");
            break;
          }
        break;
      case 0x83:
        length++;
        length++;
        curr_ins->set_opcode((int)*data++);
        curr_ins->setModRm(*data++);
        getSIB(curr_ins, length, data);
        getOffset(curr_ins, length, data);
        switch (curr_ins->getReg()) {
          case 0x00:
            length++;
            curr_ins->setImmediateLength(1);
            curr_ins->setImmediate((int)*data++, 0);
            printf("ADD r/m32,imm8\n");
            break;
          case 0x01:
            length++;
            curr_ins->setImmediateLength(1);
            curr_ins->setImmediate((int)*data++, 0);
            printf("OR r/m32,imm8\n");
            break;
          case 0x02:
            length++;
            curr_ins->setImmediateLength(1);
            curr_ins->setImmediate((int)*data++, 0);
            printf("ADC r/m32,imm8\n");
            break;
          case 0x03:
            length++;
            curr_ins->setImmediateLength(1);
            curr_ins->setImmediate((int)*data++, 0);
            printf("SUB r/m32, imm8\n");
            break;
          case 0x04:
            length++;
            curr_ins->setImmediateLength(1);
            curr_ins->setImmediate((int)*data++, 0);
            printf("AND r/m32,imm8 \n");
            break;
          case 0x05:
            length++;
            getSIB(curr_ins, length, data);
            getOffset(curr_ins, length, data);
            curr_ins->setImmediateLength(1);
            curr_ins->setImmediate((int)*data++, 0);
            printf("SUB r/m32, imm8\n");
            break;
          case 0x06:
            length++;
            curr_ins->setImmediateLength(1);
            curr_ins->setImmediate((int)*data++, 0);
            printf("XOR r/m32,imm8\n");
            break;
          case 0x07:
            curr_ins->setImmediateLength(1);
            curr_ins->setImmediate((int)*data++, 0);
            length++;
            printf("CMP r/m32,imm8\n");
            break;
          }
        break;
      case 0x84:
        length++;
        length++;
        curr_ins->set_opcode((int)*data++);
        curr_ins->setModRm((int)*data++);
        getSIB(curr_ins, length, data);
        getOffset(curr_ins, length, data);
        printf("TEST r/m8, r8\n");
        break;
      case 0x88:
        length++;
        length++;
        curr_ins->set_opcode((int)*data++);
        curr_ins->setModRm((int)*data++);
        getSIB(curr_ins, length, data);
        getOffset(curr_ins, length, data);
        printf("MOV r/m8,r8\n");
        break;
      case 0x89:
        length++;
        length++;
        curr_ins->set_opcode((int)*data++);
        curr_ins->setModRm((int)*data++);
        getSIB(curr_ins, length, data);
        getOffset(curr_ins, length, data);
        printf("MOV r/m32,r32\n");
        break;
      case 0x8a:
        length++;
        length++;
        curr_ins->set_opcode((int)*data++);
        curr_ins->setModRm(*data++);
        getSIB(curr_ins, length, data);
        getOffset(curr_ins, length, data);
        printf("MOV r8,r/m8\n");
        break;
      case 0x8b:
        length++;
        length++;
        curr_ins->set_opcode((int)*data++);
        curr_ins->setModRm(*data++);
        printf("MOV r32,r/m32\n");
        getSIB(curr_ins, length, data);
        getOffset(curr_ins, length, data);
        break;
      case 0x90:
        length++;
        curr_ins->set_opcode((int)*data++);
        printf("NOP \n");
        break;
      case 0x91: case 0x92: case 0x93: case 0x94:
      case 0x95: case 0x96: case 0x97:
        length++;
        curr_ins->set_opcode((int)*data++);
        printf("XCHG EAX,r32\n");
        break;
      case 0x99:
        length++;
        curr_ins->set_opcode((int)*data++);
        printf("CDQ\n");
        break;
      case 0xa3:
        length = length + 5;
        curr_ins->set_opcode((int)*data++);
        curr_ins->setImmediateLength(4);
        curr_ins->setImmediate((int)*data++, 0);
        curr_ins->setImmediate((int)*data++, 1);
        curr_ins->setImmediate((int)*data++, 2);
        curr_ins->setImmediate((int)*data++, 3);
        printf("MOV moffs32*,EAX\n");
        break;
      case 0x85:
        length++;
        length++;
        curr_ins->set_opcode((int)*data++);
        curr_ins->setModRm(*data++);
        getOffset(curr_ins, length, data);
        getSIB(curr_ins, length, data);
        printf("TEST r/m32,r32\n");
        break;
      case 0x8d:
        length = length + 2;
        curr_ins->set_opcode((int)*data++);
        curr_ins->setModRm(*data++);
        getSIB(curr_ins, length, data);
        getOffset(curr_ins, length, data);
        printf("LEA r32,m\n");
        break;
      case 0x9d:
        length++;
        curr_ins->set_opcode((int)*data++);
        printf("POPFD\n");
        break;
      case 0xa1:
        length = length + 5;
        curr_ins->set_opcode((int)*data++);
        curr_ins->setImmediateLength(4);
        curr_ins->setImmediate((int)*data++, 0);
        curr_ins->setImmediate((int)*data++, 1);
        curr_ins->setImmediate((int)*data++, 2);
        curr_ins->setImmediate((int)*data++, 3);
        printf("MOV eax, moffs32 \n");
        break;
      case 0xa4:
        length++;
        curr_ins->set_opcode((int)*data++);
        printf("MOVS m8,m8\n");
        break;
      case 0xa5:
        length++;
        curr_ins->set_opcode((int)*data++);
        printf("MOVS m32,m32\n");
        break;
      case 0xa8:
        length++;
        length++;
        curr_ins->set_opcode((int)*data++);
        curr_ins->setModRm(*data++);
        printf("TEST AL,imm8\n");
        break;
      case 0xb0: case 0xb1: case 0xb2: case 0xb3:
      case 0xb4: case 0xb5: case 0xb6: case 0xb7:
        length = length + 2;
        curr_ins->set_opcode((int)*data++);
        curr_ins->setImmediateLength(1);
        curr_ins->setImmediate((int)*data++, 0);
        printf("MOV r8,imm8\n");
        break;
      case 0xb8: case 0xb9: case 0xba: case 0xbb:
      case 0xbc: case 0xbd: case 0xbe: case 0xbf:
        length = length + 5;
        curr_ins->set_opcode((int)*data++);
        curr_ins->setImmediateLength(4);
        curr_ins->setImmediate((int)*data++, 0);
        curr_ins->setImmediate((int)*data++, 1);
        curr_ins->setImmediate((int)*data++, 2);
        curr_ins->setImmediate((int)*data++, 3);
        printf("MOV r32,imm32\n");
        break;
      case 0xc0:
        length++;
        length++;
        curr_ins->set_opcode((int)*data++);
        curr_ins->setModRm(*data++);
        switch(curr_ins->getReg()) {
          case 0x00:
            length++;
            curr_ins->setImmediateLength(1);
            curr_ins->setImmediate((int)*data++, 0);
            printf("ROL r/m8,imm8\n");
            break;
          case 0x01:
            length++;
            curr_ins->setImmediateLength(1);
            curr_ins->setImmediate((int)*data++, 0);
            printf("ROR r/m8,imm8\n");
            break;
          case 0x02:
            length++;
            curr_ins->setImmediateLength(1);
            curr_ins->setImmediate((int)*data++, 0);
            printf("RCL r/m8,imm8\n");
            break;
          case 0x03:
            length++;
            curr_ins->setImmediateLength(1);
            curr_ins->setImmediate((int)*data++, 0);
            printf("RCR r/m8,imm8\n");
            break;
          case 0x04:
            length++;
            curr_ins->setImmediateLength(1);
            curr_ins->setImmediate((int)*data++, 0);
            printf("SAL r/m8,imm8\n");
            break;
          case 0x05:
            length++;
            curr_ins->setImmediateLength(1);
            curr_ins->setImmediate((int)*data++, 0);
            printf("SHL r/m8,imm8\n");
            break;
          case 0x06:
            length++;
            curr_ins->setImmediateLength(1);
            curr_ins->setImmediate((int)*data++, 0);
            printf("SHR r/m8,imm8\n");
            break;
          case 0x07:
            length++;
            curr_ins->setImmediateLength(1);
            curr_ins->setImmediate((int)*data++, 0);
            printf("SAR r/m8,imm8\n");
            break;
          }
        break;
      case 0xc1:
        length++;
        length++;
        curr_ins->set_opcode((int)*data++);
        curr_ins->setModRm(*data++);
        switch(curr_ins->getReg()) {
          case 0x00:
            length++;
            curr_ins->setImmediateLength(1);
            curr_ins->setImmediate((int)*data++, 0);
            printf("ROL r/m32,imm8\n");
            break;
          case 0x01:
            length++;
            curr_ins->setImmediateLength(1);
            curr_ins->setImmediate((int)*data++, 0);
            printf("ROR r/m32,imm8\n");
            break;
          case 0x02:
            length++;
            curr_ins->setImmediateLength(1);
            curr_ins->setImmediate((int)*data++, 0);
            printf("RCL r/m32,imm8\n");
            break;
          case 0x03:
            length++;
            curr_ins->setImmediateLength(1);
            curr_ins->setImmediate((int)*data++, 0);
            printf("RCR r/m32,imm8\n");
            break;
          case 0x04:
            length++;
            curr_ins->setImmediateLength(1);
            curr_ins->setImmediate((int)*data++, 0);
            printf("SAL r/m32,imm8\n");
            break;
          case 0x05:
            length++;
            curr_ins->setImmediateLength(1);
            curr_ins->setImmediate((int)*data++, 0);
            printf("SHL r/m32,imm8\n");
            break;
          case 0x06:
            length++;
            curr_ins->setImmediateLength(1);
            curr_ins->setImmediate((int)*data++, 0);
            printf("SHR r/m32,imm8\n");
            break;
          case 0x07:
            length++;
            curr_ins->setImmediateLength(1);
            curr_ins->setImmediate((int)*data++, 0);
            printf("SAR r/m32,imm8\n");
            break;
          }
        break;
      case 0xcd:
        length++;
        length++;
        curr_ins->set_opcode((int)*data++);
        curr_ins->setImmediateLength(1);
        curr_ins->setImmediate((int)*data++, 0);
        printf("INT imm8\n");
        break;
      case 0xc3:
        length++;
        curr_ins->set_opcode((int)*data++);
        printf("RET\n");
        break;
      case 0xc6:
        length  = length + 3;
        curr_ins->set_opcode((int)*data++);
        curr_ins->setModRm(*data++);
        curr_ins->setImmediateLength(1);
        curr_ins->setImmediate((int)*data++, 0);
        getSIB(curr_ins, length, data);
        getOffset(curr_ins, length, data);
        printf("MOV r/m8,imm8\n");
        break;
      case 0xc7:
        length  = length + 2;
        curr_ins->set_opcode((int)*data++);
        curr_ins->setModRm(*data++);
        getSIB(curr_ins, length, data);
        getOffset(curr_ins, length, data);
        length = length + 2;
        curr_ins->setImmediateLength(4);
        curr_ins->setImmediate((int)*data++, 0);
        curr_ins->setImmediate((int)*data++, 1);
        if (!operandOveride) {
          length = length + 2;
          curr_ins->setImmediate((int)*data++, 2);
          curr_ins->setImmediate((int)*data++, 3);
          }
        printf("MOV r/m32,imm32\n");
        break;
      case 0xd0:
        length = length + 2;
        curr_ins->set_opcode((int)*data++);
        curr_ins->setModRm(*data++);
        switch (curr_ins->getReg()) {
          case 0x00:
            getSIB(curr_ins, length, data);
            getOffset(curr_ins, length, data);
            printf("ROL r/m8,1\n");
            break;
          case 0x01:
            length++;
            getSIB(curr_ins, length, data);
            getOffset(curr_ins, length, data);
            printf("ROR r/m8,1\n");
            break;
          case 0x02:
            length++;
            getSIB(curr_ins, length, data);
            getOffset(curr_ins, length, data);
            printf("RCL r/m8,1\n");
            break;
          case 0x03:
            length++;
            getSIB(curr_ins, length, data);
            getOffset(curr_ins, length, data);
            printf("RCR r/m8,1\n");
            break;
          case 0x04:
            length++;
            getSIB(curr_ins, length, data);
            getOffset(curr_ins, length, data);
            printf("SAL r/m8,1\n");
            break;
          case 0x05:
            length++;
            getSIB(curr_ins, length, data);
            getOffset(curr_ins, length, data);
            printf("SHL r/m8,1\n");
            break;
          case 0x06:
            length++;
            getSIB(curr_ins, length, data);
            getOffset(curr_ins, length, data);
            printf("SHR r/m8,1\n");
            break;
          case 0x07:
            length++;
            getSIB(curr_ins, length, data);
            getOffset(curr_ins, length, data);
            printf("SAR r/m8,1\n");
            break;
          }
        break;
      case 0xd3:
        length = length + 2;
        curr_ins->set_opcode((int)*data++);
        curr_ins->setModRm(*data++);
        printf("ROTATE r/m32, CL \n");
        break;
      case 0xd9:
        length = length + 2;
        curr_ins->set_opcode((int)*data++);
        curr_ins->setModRm(*data++);
        switch (curr_ins->getReg()) {
          case 0x05:
            getSIB(curr_ins, length, data);
            getOffset(curr_ins, length, data);
            printf("FLDCW m2byte\n");
            break;
          case 0x07:
            getSIB(curr_ins, length, data);
            getOffset(curr_ins, length, data);
            printf("FNSTCW m2byte\n");
            break;
          }
        break;
      case 0xdc:
        length = length + 2;
        curr_ins->set_opcode((int)*data++);
        curr_ins->setModRm(*data++);
        switch (curr_ins->getReg()) {
          case 0x03:
            getSIB(curr_ins, length, data);
            getOffset(curr_ins, length, data);
            printf("FCOMP m64real\n");
            break;
          }
        break;
      case 0xdb:
        length = length + 2;
        curr_ins->set_opcode((int)*data++);
        curr_ins->setModRm(*data++);
        switch (curr_ins->getReg()) {
          case 0x05:
            getSIB(curr_ins, length, data);
            getOffset(curr_ins, length, data);
            printf("FLD m80real\n");
            break;
          }
      case 0xdd:
        length = length + 2;
        curr_ins->set_opcode((int)*data++);
        curr_ins->setModRm(*data++);
        switch (curr_ins->getReg()) {
          case 0x00:
            getSIB(curr_ins, length, data);
            getOffset(curr_ins, length, data);
            printf("FLD m64real\n");
            break;
          }
      case 0xdf:
        length = length + 2;
        curr_ins->set_opcode((int)*data++);
        curr_ins->setModRm(*data++);
        switch (curr_ins->getReg()) {
          case 0x04:
            getSIB(curr_ins, length, data);
            getOffset(curr_ins, length, data);
            printf("FBLD m80bcd\n");
            break;
          }
      case 0xe3:
        length = length + 2;
        curr_ins->set_opcode((int)*data++);
        curr_ins->setRelativeLength(1);
        curr_ins->setRelative((int)*data++, 0);
        printf("JECXZ rel8");
        break;
     case 0xe8:
        length = length + 5;
        curr_ins->set_opcode((int)*data++);
        curr_ins->setRelativeLength(4);
        curr_ins->setRelative((int)*data++, 0);
        curr_ins->setRelative((int)*data++, 1);
        curr_ins->setRelative((int)*data++, 2);
        curr_ins->setRelative((int)*data++, 3);
        printf("CALL rel32 \n");
        break;
      case 0xe9:
        length = length + 5;
        curr_ins->set_opcode((int)*data++);
        curr_ins->setRelativeLength(4);
        curr_ins->setRelative((int)*data++, 0);
        curr_ins->setRelative((int)*data++, 1);
        curr_ins->setRelative((int)*data++, 2);
        curr_ins->setRelative((int)*data++, 3);
        printf("JMP rel32 \n");
        break;
      case 0xeb:
        length++;
        length++;
        curr_ins->set_opcode((int)*data++);
        curr_ins->setRelativeLength(1);
        curr_ins->setRelative((int)*data++, 0);
        printf("JMP abs32\n");
        break;

      case 0xf2:
        value = *data++;
        switch(*data) {
          case 0xae:
            length++;
            curr_ins->set_opcode((int)*data++);
            printf("REPNE SCAS m8\n");
            break;
          case 0xaf:
            length++;
            curr_ins->set_opcode((int)*data++);
            printf("REPNE SCAS m32\n");
            break;
          }
        break;
      case 0xf3:
        value = *data++;
        switch(*data) {
          case 0xa4:
            length++;
            curr_ins->set_opcode((int)*data++);
            printf("REP MOVS m8,m8\n");
            break;
          case 0xa5:
            length++;
            curr_ins->set_opcode((int)*data++);
            printf("REP MOVS m32,m32\n");
            break;
          case 0xa6:
            length++;
            curr_ins->set_opcode((int)*data++);
            printf("REPE CMPS m8,m8\n");
            break;
          case 0xa7:
            length++;
            curr_ins->set_opcode((int)*data++);
            printf("REPE CMPS m32,m32\n");
            break;
          case 0xa8:
            length++;
            length++;
            curr_ins->set_opcode((int)*data++);
            curr_ins->setModRm(*data++);
            printf("TEST AL,imm8\n");
            break;
          case 0xaa:
            length++;
            curr_ins->set_opcode((int)*data++);
            printf("REP STOS m8\n");
            break;
          case 0xab:
            length++;
            curr_ins->set_opcode((int)*data++);
            printf("REP STOS m32\n");
            break;
          }
        break;

      case 0xf4:
        length++;
        curr_ins->set_opcode((int)*data++);
        printf("HLT \n");
        break;
      case 0xf6:
        length++;
        length++;
        curr_ins->set_opcode((int)*data++);
        curr_ins->setModRm(*data++);
        switch(curr_ins->getReg()) {
          case 0x00:
            curr_ins->setImmediateLength(1);
            curr_ins->setImmediate((int)*data++, 0);
            length++;
            getSIB(curr_ins, length, data);
            getOffset(curr_ins, length, data);
            printf("TEST r/m8,imm8 \n");
            break;
          case 0x02:
            getSIB(curr_ins, length, data);
            printf("NEG r/m8\n");
            break;
          }
        break;
      case 0xf7:
        length++;
        length++;
        curr_ins->set_opcode((int)*data++);
        curr_ins->setModRm(*data++);
        switch(curr_ins->getReg()) {
          case 0x00:
            length = length + 2;
            getSIB(curr_ins, length, data);
            getOffset(curr_ins, length, data);
            curr_ins->setImmediateLength(2);
            curr_ins->setImmediate((int)*data++, 0);
            curr_ins->setImmediate((int)*data++, 1);
            if (operandOveride == false) {
              length = length + 2;
              curr_ins->setImmediateLength(4);
              curr_ins->setImmediate((int)*data++, 2);
              curr_ins->setImmediate((int)*data++, 3);
              }
            printf("TEST r/m32,imm32\n");
            break;
          case 0x02:
            getSIB(curr_ins, length, data);
            getOffset(curr_ins, length, data);
            printf("NOT r/m32\n");
            break;
          case 0x03:
            getSIB(curr_ins, length, data);
            getOffset(curr_ins, length, data);
            printf("NEG r/m32\n");
            break;
          case 0x04:
            getSIB(curr_ins, length, data);
            getOffset(curr_ins, length, data);
            printf("MUL r/m32\n");
            break;
          case 0x06:
            getSIB(curr_ins, length, data);
            getOffset(curr_ins, length, data);
            printf("DIV r/m32\n");
            break;
          }
        break;
      case 0xf8:
        length++;
        curr_ins->set_opcode((int)*data++);
        printf("CLC\n");
        break;
      case 0xf9:
        length++;
        curr_ins->set_opcode((int)*data++);
        printf("STC\n");
        break;
      case 0xfa:
        length++;
        curr_ins->set_opcode((int)*data++);
        printf("CLI\n");
        break;
      case 0xfb:
        length++;
        curr_ins->set_opcode((int)*data++);
        printf("STI\n");
        break;
      case 0xfc:
        length++;
        curr_ins->set_opcode((int)*data++);
        printf("CLD\n");
        break;
      case 0xfd:
        length++;
        curr_ins->set_opcode((int)*data++);
        printf("STD\n");
        break;
      case 0xfe:
        length++;
        length++;
        curr_ins->set_opcode((int)*data++);
        curr_ins->setModRm(*data);
        switch (curr_ins->getReg()) {
          case 0x00:
            getSIB(curr_ins, length, data);
            getOffset(curr_ins, length, data);
            printf("INC r/m8\n");
            break;
          case 0x01:
            getSIB(curr_ins, length, data);
            getOffset(curr_ins, length, data);
            printf("DEC r/m8\n");
            break;
          }
        break;
      case 0xff:
        length++;
        length++;
        curr_ins->set_opcode((int)*data++);
        curr_ins->setModRm((int)*data++);
        switch (curr_ins->getReg()) { 
          case 0x00:
            getSIB(curr_ins, length, data);
            getOffset(curr_ins, length, data);
            printf("INC r/m32\n");
            break;
          case 0x01:
            getSIB(curr_ins, length, data);
            getOffset(curr_ins, length, data);
            printf("DEC r/m32\n");
            break;
          case 0x02:
            getSIB(curr_ins, length, data);
            getOffset(curr_ins, length, data);
            printf("CALL r/m32\n");
            break;
          case 0x03:
            getSIB(curr_ins, length, data);
            getOffset(curr_ins, length, data);
            printf("CALL m16:32\n");
            break;
          case 0x04:
            getSIB(curr_ins, length, data);
            getOffset(curr_ins, length, data);
            printf("JMP r/m32\n");
            break;
          case 0x06:
            getSIB(curr_ins, length, data);
            getOffset(curr_ins, length, data);
            printf("PUSH r/m32\n");
            break;
          }
        break;
        default:
          printf("Cannot Decode Instruction !!!!!!!!!!!!!!!!!!!!!!!!!!!!\n");

    }
    return length;
}

void
Dsim_decode::getSIB(Dsim_instruction *curr_ins, int &length, int* &data) {
   
   if (curr_ins->getRm() == 0x4 & curr_ins->getMod() != 0x3) {
     curr_ins->setSIB(*data++);
     length++;
     if (curr_ins->getB() == 0x05 & curr_ins->getMod() == 0x00) {
       length = length + 4;
       curr_ins->setOffsetLength(4);
       curr_ins->setOffset((int)*data++, 0);
       curr_ins->setOffset((int)*data++, 1);
       curr_ins->setOffset((int)*data++, 2);
       curr_ins->setOffset((int)*data++, 3);
       }
     }
   } 


void
Dsim_decode::getOffset(Dsim_instruction *curr_ins, int &length, int* &data) {
   
   switch(curr_ins->getMod()) {
     case 0x01:
       length++;
       curr_ins->setOffsetLength(1);
       curr_ins->setOffset((int)*data++, 0);
       break;
     case 0x02:
       length = length + 4;
       curr_ins->setOffsetLength(4);
       curr_ins->setOffset((int)*data++, 0);
       curr_ins->setOffset((int)*data++, 1);
       curr_ins->setOffset((int)*data++, 2);
       curr_ins->setOffset((int)*data++, 3);
       break;
       }
     if (curr_ins->getMod() == 0x00 & curr_ins->getRm() == 0x05) {
       length = length + 4;
       curr_ins->setOffsetLength(4);
       curr_ins->setOffset((int)*data++, 0);
       curr_ins->setOffset((int)*data++, 1);
       curr_ins->setOffset((int)*data++, 2);
       curr_ins->setOffset((int)*data++, 3);
       }
     if ((curr_ins->getMod() == 0x01 | curr_ins->getMod() == 0x03) & curr_ins->getRm() == 0x04 & curr_ins->getB() == 0x05 ) {
       length = length + 4;
       curr_ins->setOffsetLength(4);
       curr_ins->setOffset((int)*data++, 0);
       curr_ins->setOffset((int)*data++, 1);
       curr_ins->setOffset((int)*data++, 2);
       curr_ins->setOffset((int)*data++, 3);
       }
     if (curr_ins->getMod() == 0x02 & curr_ins->getRm() == 0x04 & curr_ins->getB() == 0x05 ) {
       length++;
       curr_ins->setOffsetLength(4);
       curr_ins->setOffset((int)*data++, 0);
       }
   }
