/***********************************************************************
                           Dsim_core.h
                           Peter McClymont
                           University of Auckland.
 **********************************************************************/

#ifndef _Dsim_core_h_
#define _Dsim_core_h_

#include <assert.h>
#include <iostream.h>

#include "GetLongOpt.h"
#include "Dsim_elfer.h"
#include "Dsim_types.h"
#include "Dsim_misclib.h"

class Dsim_core {
   friend ostream& operator<<(ostream&, const Dsim_core& ); 

protected:
   virtual void cleanup();
   void copy(const Dsim_core&);
   void print(ostream& os);
   
   Dsim_address entryPoint;


public:
   enum SegmentTypes { 
	SYS_SEG , TEXT_SEG , DATA_SEG 
              , BSS_SEG , numSegments };

   struct SegmentInfo {
      unsigned int sz;

      // this is a virtual address
      Dsim_address startReal;  

      // this is a virtual address
      Dsim_address endReal;    
      Dsim_address startMapped;
      Dsim_address endMapped;

      // displacement real -> mapped
      Dsim_address disp;       
   }; 
 
   Dsim_core();
   Dsim_core(const Dsim_core& c)	{ copy(c); }
   virtual ~Dsim_core()			{ cleanup(); }
   Dsim_core& operator=(const Dsim_core&);
   void load();
   void init();
   void stackArgvEtc();
   int getOffset(Dsim_address va);
   Dsim_data inspectByte(Dsim_address addrs);
   Dsim_address virtual_address( Dsim_address pa );
   Dsim_address physical_address( Dsim_address va );
   Dsim_address physical_wordaddress( Dsim_address va );
   Dsim_data inspect( Dsim_address addrs );
   int readOnly( Dsim_address addrs );
   void replace( Dsim_address addrs , Dsim_data data );
   void insertByte(Dsim_address addrs, int byte);
   char* address2charPtr(Dsim_address);
   //void verify();
   Dsim_address get_entry(); 
   Dsim_address getInitStackValue(); 
   Dsim_address getInitProgValue(); 
   int get_text_offset(); 
 
   int get_textseg_size();
   int get_dataseg_size();
   int get_bssseg_size();
   
   int bytesPerWord;
   int log2bytesPerWord;
   
private:
   Dsim_elfer *elfer;
   static const char* segmentName[];
   SegmentInfo* segmentInfo;
   unsigned long core_size;
   Dsim_data* core_buffer;
   Dsim_address spValue;
   Dsim_address ipValue;
   short ofmagic;


public:

};

#endif // _Dsim_core_h_
