package foo;
import java.util.*;

public class TransferBean {
	
	private String amount;
	private String toAccount;
	private String fromAccount;
  private double sum=0.0;
	private Hashtable errors;

	public boolean validate() {
		boolean allOk=true;		
		
		if(fromAccount.equals(toAccount)) {
			 allOk = false;
		   errors.put("account","FromAccount is the Same as ToAccount"); 
		}
		
		try {
		  sum = Double.parseDouble(amount);
			if(sum < 0) {
			 allOk = false;
		   errors.put("amount","Please enter a non-negative amount to transfer ");
			}
		}
		catch(Exception ex) {
		 allOk = false;
		 errors.put("amount","Please enter a numeric value for transfer to proceed");	
		 return allOk;	
		}
		return allOk;
	}	

	public String getErrorMsg(String s) {
		String errorMsg =(String)errors.get(s.trim());
	      return (errorMsg == null) ? "":errorMsg;
	}

	public TransferBean() {
	 amount="";
	 toAccount="";
	 fromAccount="";	
 	 errors = new Hashtable();
	}

	public String getAmount() {
		return amount;
	}
 
  public String getToAccount() {
		return toAccount;
	}	
	
	public String getFromAccount() {
		return fromAccount;
	}	
	
	public void setAmount(String amt) {
	  amount=amt;
	}
	
	public void setToAccount(String toAcc) {
	  toAccount=toAcc;
	}
	
	public void setFromAccount(String fromAcc) {
	  fromAccount=fromAcc;
	}
	
	public void setErrors(String key, String msg) {	
		errors.put(key,msg);
	}

}

