package foo;
import java.util.*;

public class TransactionBean {
	
	private String accounts;
	
	private String toDate;
	
	private String fromDate;
	
	private String sort;
	
	private Hashtable errors;

	public boolean validate() {
		boolean allOk=true;		
		if (toDate.equals("")) {
			errors.put("toDate","Please enter the \"To\" Date");
			toDate="";
			allOk=false;
		}
		
		if (fromDate.equals("")) {
			errors.put("fromDate","Please enter the \"From\" Date");
			fromDate="";
			allOk=false;
		}

		return allOk;
	}	

	public String getErrorMsg(String s) {
		String errorMsg =(String)errors.get(s.trim());
	      return (errorMsg == null) ? "":errorMsg;
	}

	public TransactionBean() {
	 accounts="";
	 toDate="";
	 fromDate="";
	 sort="";	
 	 errors = new Hashtable();
	}
	
		
	
	public String getAccounts() {
		return accounts;
	}

	public String getToDate() {
		return toDate;
	}
	
	public String getFromDate() {
		return fromDate;
	}
	
	public String getSort() {
		return sort;
	}
	
	public void  setAccounts(String accts) {
		accounts=accts;
	}
	
	public void setToDate(String tdate) {
		toDate=tdate;
	}

	public void setFromDate(String fdate) {
		fromDate=fdate;
	}
	
	public void setSort(String srt) {
		sort=srt;
	}

	public void setErrors(String key, String msg) {	
		errors.put(key,msg);
	}

}

