package foo;
import java.util.*;

public class PasswordBean {
	
	private String oldpasswd;
	
	private String newpasswd;
	
	private String confirm;
	
	private Hashtable errors;

	public boolean validate() {
		boolean allOk=true;

		if (oldpasswd.equals("")) {
			errors.put("oldpasswd","Please enter your old password");
			oldpasswd="";
			allOk=false;
		}
		if (newpasswd.equals("")) {
			errors.put("newpasswd","Please enter your new password");
			newpasswd="";
			allOk=false;
		}
		
		

		if (confirm.equals("")) {
			errors.put("confirm","Please confirm your new password");
			confirm="";
			allOk=false;
		}
		
		if (!confirm.equals("") && (newpasswd.equals("") || !confirm.equals(newpasswd))) {
			errors.put("confirm","Please confirm your new password");
			confirm="";
			allOk=false;
		}
		return allOk;
	}	

	public String getErrorMsg(String s) {
		String errorMsg =(String)errors.get(s.trim());
	      return (errorMsg == null) ? "":errorMsg;
	}

	public PasswordBean() {
	 oldpasswd="";
	 newpasswd="";
	 confirm="";	
 	 errors = new Hashtable();
	}
	
		
	
	public String getOldPasswd() {
		return oldpasswd;
	}

	public String getNewPasswd() {
		return newpasswd;
	}
	
	public String getConfirm() {
		return confirm;
	}

	public void  setOldPasswd(String passwd) {
		oldpasswd=passwd;
	}

	public void setNewPasswd(String passwd) {
		newpasswd=passwd;
	}
 
	public void setConfirm(String confm) {
		confirm=confm;
	}
	
	public void setErrors(String key, String msg) {	
		errors.put(key,msg);
	}

}

